/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.BufferedReader;
import java.io.OutputStream;
import javajs.api.GenericFileInterface;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.ExportInterface;
import jspecview.api.JSVExporter;
import jspecview.api.JSVPanel;
import jspecview.common.Annotation;
import jspecview.common.ExportType;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.Spectrum;

public class Exporter
implements ExportInterface {
    static final String newLine = System.getProperty("line.separator");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String write(JSViewer jSViewer, Lst<String> lst, boolean bl) {
        if (lst == null) {
            return this.printPDF(jSViewer, null, false);
        }
        String string = null;
        String string2 = null;
        JSVPanel jSVPanel = jSViewer.selectedPanel;
        try {
            switch (lst.size()) {
                default: {
                    return "WRITE what?";
                }
                case 1: {
                    int n;
                    string2 = PT.trimQuotes((String)lst.get(0));
                    if (string2.indexOf(".") >= 0) {
                        string = "XY";
                    }
                    if (jSVPanel == null) {
                        return null;
                    }
                    ExportType exportType = ExportType.getType(string2);
                    switch (exportType) {
                        case PNG: 
                        case JPG: 
                        case PDF: {
                            return this.exportTheSpectrum(jSViewer, exportType, null, null, -1, -1, null, false);
                        }
                    }
                    jSViewer.fileHelper.setFileChooser(exportType);
                    String[] stringArray = this.getExportableItems(jSViewer, exportType.equals((Object)ExportType.SOURCE));
                    int n2 = n = stringArray == null ? -1 : jSViewer.getOptionFromDialog(stringArray, "Export", "Choose a spectrum to export");
                    if (n == Integer.MIN_VALUE) {
                        return null;
                    }
                    GenericFileInterface genericFileInterface = jSViewer.fileHelper.getFile(this.getSuggestedFileName(jSViewer, exportType), jSVPanel, true);
                    if (genericFileInterface == null) {
                        return null;
                    }
                    OC oC = jSViewer.getOutputChannel(genericFileInterface.getFullPath(), false);
                    String string3 = this.exportSpectrumOrImage(jSViewer, exportType, n, oC);
                    boolean bl2 = string3.startsWith("OK");
                    if (bl2) {
                        jSViewer.si.siUpdateRecentMenus(genericFileInterface.getFullPath());
                    }
                    return string3;
                }
                case 2: 
            }
            string = ((String)lst.get(0)).toUpperCase();
            string2 = PT.trimQuotes((String)lst.get(1));
            String string4 = string2.substring(string2.lastIndexOf(".") + 1).toUpperCase();
            if (string4.equals("BASE64")) {
                string2 = ";base64,";
            } else if (string4.equals("JDX")) {
                if (string == null) {
                    string = "XY";
                }
            } else if (ExportType.isExportMode(string4)) {
                string = string4;
            } else if (ExportType.isExportMode(string)) {
                string2 = String.valueOf(string2) + "." + string;
            }
            ExportType exportType = ExportType.getType(string);
            if (bl && exportType == ExportType.SVG) {
                exportType = ExportType.SVGI;
            }
            OC oC = jSViewer.getOutputChannel(string2, false);
            return this.exportSpectrumOrImage(jSViewer, exportType, -1, oC);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private String exportSpectrumOrImage(JSViewer jSViewer, ExportType exportType, int n, OC oC) {
        PanelData panelData = jSViewer.pd();
        if (n < 0 && (n = panelData.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        Spectrum spectrum = panelData.getSpectrumAt(n);
        int n2 = panelData.getStartingPointIndex(n);
        int n3 = panelData.getEndingPointIndex(n);
        String string = null;
        try {
            boolean bl = oC.isBase64();
            string = this.exportTheSpectrum(jSViewer, exportType, oC, spectrum, n2, n3, panelData, bl);
            if (bl) {
                return string;
            }
            if (string.startsWith("OK")) {
                return "OK - Exported " + exportType.name() + ": " + oC.getFileName() + string.substring(2);
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return "Error exporting " + oC.getFileName() + ": " + string;
    }

    @Override
    public String exportTheSpectrum(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, PanelData panelData, boolean bl) throws Exception {
        JSVPanel jSVPanel = jSViewer.selectedPanel;
        String string = exportType.name();
        switch (exportType) {
            case SVG: 
            case SVGI: 
            case CML: 
            case AML: {
                break;
            }
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                string = "JDX";
                break;
            }
            case PNG: 
            case JPG: {
                if (jSVPanel == null) {
                    return null;
                }
                jSViewer.fileHelper.setFileChooser(exportType);
                String string2 = this.getSuggestedFileName(jSViewer, exportType);
                GenericFileInterface genericFileInterface = jSViewer.fileHelper.getFile(string2, jSVPanel, true);
                if (genericFileInterface == null) {
                    return null;
                }
                return jSVPanel.saveImage(string.toLowerCase(), genericFileInterface, oC);
            }
            case PDF: {
                return this.printPDF(jSViewer, "PDF", bl);
            }
            case SOURCE: {
                if (jSVPanel == null) {
                    return null;
                }
                return Exporter.fileCopy(jSVPanel.getPanelData().getSpectrum().getFilePath(), oC);
            }
            case UNK: {
                return null;
            }
        }
        return ((JSVExporter)JSViewer.getInterface("jspecview.export." + string.toUpperCase() + "Exporter")).exportTheSpectrum(jSViewer, exportType, oC, spectrum, n, n2, null, false);
    }

    private String printPDF(JSViewer jSViewer, String string, boolean bl) {
        String string2;
        Object object;
        Object object2;
        JSVPanel jSVPanel;
        PrintLayout printLayout;
        block12: {
            boolean bl2;
            boolean bl3 = bl2 = string == null || string.length() == 0;
            if (!bl && !jSViewer.si.isSigned()) {
                return "Error: Applet must be signed for the PRINT command.";
            }
            PanelData panelData = jSViewer.pd();
            if (panelData == null) {
                return null;
            }
            boolean bl4 = false;
            panelData.closeAllDialogsExcept(Annotation.AType.NONE);
            bl4 = true;
            printLayout = jSViewer.getDialogPrint(bl2);
            if (printLayout == null) {
                return null;
            }
            if (!bl4) {
                printLayout.asPDF = true;
            }
            if (bl2 && printLayout.asPDF) {
                bl2 = false;
                string = "PDF";
            }
            jSVPanel = jSViewer.selectedPanel;
            if (!bl && !bl2) {
                object2 = jSViewer.fileHelper;
                object2.setFileChooser(ExportType.PDF);
                if (string.equals("?") || string.equalsIgnoreCase("PDF")) {
                    string = this.getSuggestedFileName(jSViewer, ExportType.PDF);
                }
                if ((object = object2.getFile(string, jSVPanel, true)) == null) {
                    return null;
                }
                if (!jSViewer.isJS) {
                    jSViewer.setProperty("directoryLastExportedFile", object2.setDirLastExported(object.getParentAsFile().getFullPath()));
                }
                string = object.getFullPath();
            }
            object2 = null;
            object = bl2 ? null : (bl ? new OC().setParams(null, ";base64,", false, null) : jSViewer.getOutputChannel(string, true));
            string2 = panelData.getPrintJobTitle(true);
            if (!printLayout.showTitle || (string2 = jSVPanel.getInput("Title?", "Title for Printing", string2)) != null) break block12;
            return null;
        }
        try {
            jSVPanel.printPanel(printLayout, (OutputStream)object, string2);
            object2 = ((OC)object).toString();
        }
        catch (Exception exception) {
            jSVPanel.showMessage(exception.toString(), "File Error");
        }
        return object2;
    }

    private String[] getExportableItems(JSViewer jSViewer, boolean bl) {
        PanelData panelData = jSViewer.pd();
        boolean bl2 = jSViewer.currentSource.isView;
        int n = panelData.getNumberOfSpectraInCurrentSet();
        if (n == 1 || !bl2 && bl || panelData.getCurrentSpectrumIndex() >= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = panelData.getSpectrumAt(n2).getTitle();
            ++n2;
        }
        return stringArray;
    }

    private String getSuggestedFileName(JSViewer jSViewer, ExportType exportType) {
        int n;
        PanelData panelData = jSViewer.pd();
        String string = panelData.getSpectrum().getFilePath();
        String string2 = JSVFileManager.getTagName(string);
        if (string2.startsWith("$")) {
            string2 = string2.substring(1);
        }
        String string3 = (n = string2.lastIndexOf(".")) < 0 ? string2 : string2.substring(0, n);
        String string4 = ".jdx";
        boolean bl = false;
        switch (exportType) {
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                if (!string3.endsWith("_" + (Object)((Object)exportType))) {
                    string3 = String.valueOf(string3) + "_" + (Object)((Object)exportType);
                }
                string4 = ".jdx";
                break;
            }
            case AML: {
                string4 = ".xml";
                break;
            }
            case PNG: 
            case JPG: 
            case PDF: {
                bl = true;
            }
            default: {
                string4 = "." + exportType.toString().toLowerCase();
            }
        }
        if (jSViewer.currentSource.isView) {
            string3 = panelData.getPrintJobTitle(bl);
        }
        string3 = String.valueOf(string3) + string4;
        return string3;
    }

    private static String fileCopy(String string, OC oC) {
        try {
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string, null);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                oC.append(string2);
                oC.append(newLine);
            }
            oC.closeChannel();
            return "OK " + oC.getByteCount() + " bytes";
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }
}

