/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "internalNameWithoutInnerClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getInternalNameWithoutInnerClasses", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/lang/String;", "javaFileFacadeFqName", "Lorg/jetbrains/kotlin/psi/KtFile;", "getJavaFileFacadeFqName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/name/FqName;", "isInsideJvmMultifileClassFile", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "frontend.java"})
public final class JvmFileClassUtilKt {
    private static final Logger LOG;

    @NotNull
    public static final FqName getJavaFileFacadeFqName(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Object t = CachedValuesManager.getCachedValue($receiver, new CachedValueProvider<T>($receiver){
            final /* synthetic */ KtFile $this_javaFileFacadeFqName;

            @Nullable
            public final CachedValueProvider.Result<FqName> compute() {
                FqName fqName2;
                if (this.$this_javaFileFacadeFqName.isCompiled()) {
                    FqName fqName3 = this.$this_javaFileFacadeFqName.getPackageFqName();
                    VirtualFile virtualFile2 = this.$this_javaFileFacadeFqName.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "virtualFile");
                    fqName2 = fqName3.child(Name.identifier(virtualFile2.getNameWithoutExtension()));
                } else {
                    fqName2 = JvmFileClassUtil.getFileClassInfoNoResolve(this.$this_javaFileFacadeFqName).getFacadeClassFqName();
                }
                Intrinsics.checkExpressionValueIsNotNull(fqName2, "if (isCompiled) packageF\u2026e(this).facadeClassFqName");
                FqName facadeFqName = fqName2;
                Name name = facadeFqName.shortName();
                Intrinsics.checkExpressionValueIsNotNull(name, "facadeFqName.shortName()");
                if (!Name.isValidIdentifier(name.getIdentifier())) {
                    JvmFileClassUtilKt.access$getLOG$p().error("An invalid fqName `" + facadeFqName + "` with short name `" + facadeFqName.shortName() + "` is created for file `" + this.$this_javaFileFacadeFqName.getName() + "` " + "(isCompiled = " + this.$this_javaFileFacadeFqName.isCompiled() + ')');
                }
                return new CachedValueProvider.Result<FqName>(facadeFqName, this.$this_javaFileFacadeFqName);
            }
            {
                this.$this_javaFileFacadeFqName = ktFile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, "CachedValuesManager.getC\u2026deFqName, this)\n        }");
        return (FqName)t;
    }

    public static final boolean isInsideJvmMultifileClassFile(@NotNull KtDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        KtFile ktFile = $receiver.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull(ktFile, "containingKtFile");
        return JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(ktFile, JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
    }

    @NotNull
    public static final String getInternalNameWithoutInnerClasses(@NotNull FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses($receiver);
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byFqNameWithoutInnerClasses(this)");
        String string = jvmClassName.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byFqNameWit\u2026lasses(this).internalName");
        return string;
    }

    static {
        Logger logger = Logger.getInstance("JvmFileClassUtil");
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getInstance(\"JvmFileClassUtil\")");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

