/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/CoroutineIntrinsicLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public final class CoroutineIntrinsicLowering
implements FileLoweringPass {
    private final LanguageVersionSettings languageVersion;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ CoroutineIntrinsicLowering this$0;

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrExpression call2 = super.visitCall(expression2);
                if (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(expression2.getDescriptor(), CoroutineIntrinsicLowering.access$getLanguageVersion$p(this.this$0))) {
                    irExpression = IrUtilsKt.irCall$default((IrMemberAccessExpression)expression2, this.this$0.getContext().getCoroutineSuspendOrReturn(), false, false, 12, null);
                } else {
                    if (CommonCoroutineCodegenUtilKt.isBuiltInIntercepted(expression2.getDescriptor(), CoroutineIntrinsicLowering.access$getLanguageVersion$p(this.this$0))) {
                        String string = "Intercepted should not be used with release coroutines";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    irExpression = Intrinsics.areEqual(expression2.getSymbol().getOwner(), (IrSimpleFunction)this.this$0.getContext().getIntrinsics().getJsCoroutineContext().getOwner()) ? (IrExpression)IrUtilsKt.irCall$default((IrMemberAccessExpression)expression2, this.this$0.getContext().getCoroutineGetContextJs(), false, false, 12, null) : call2;
                }
                return irExpression;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public CoroutineIntrinsicLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.languageVersion = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration());
    }

    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersion$p(CoroutineIntrinsicLowering $this) {
        return $this.languageVersion;
    }
}

