"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var addonProfiler_1 = require("../profilers/addonProfiler");
var inspectorProfiler_1 = require("../profilers/inspectorProfiler");
var constants_1 = require("../constants");
var Debug = require("debug");
var ProfilingConfig = (function () {
    function ProfilingConfig() {
    }
    return ProfilingConfig;
}());
exports.ProfilingConfig = ProfilingConfig;
var defaultProfilingConfig = {
    cpuJS: true,
    heapSnapshot: true,
    heapSampling: true,
    implementation: 'both'
};
var disabledProfilingConfig = {
    cpuJS: false,
    heapSnapshot: false,
    heapSampling: false,
    implementation: 'none'
};
var ProfilingFeature = (function () {
    function ProfilingFeature() {
        this.logger = Debug('axm:features:profiling');
    }
    ProfilingFeature.prototype.init = function (config) {
        if (config === true) {
            config = defaultProfilingConfig;
        }
        else if (config === false) {
            config = disabledProfilingConfig;
        }
        else if (config === undefined) {
            config = defaultProfilingConfig;
        }
        if (process.env.PM2_PROFILING_FORCE_FALLBACK === 'true') {
            config.implementation = 'addon';
        }
        if (config.implementation === undefined || config.implementation === 'both') {
            config.implementation = constants_1.canUseInspector() === true ? 'inspector' : 'addon';
        }
        switch (config.implementation) {
            case 'inspector': {
                this.logger('using inspector implementation');
                this.profiler = new inspectorProfiler_1.default();
                break;
            }
            case 'addon': {
                this.logger('using addon implementation');
                this.profiler = new addonProfiler_1.default();
                break;
            }
            default: {
                return this.logger("Invalid profiler implementation choosen: " + config.implementation);
            }
        }
        this.logger('init');
        this.profiler.init();
    };
    ProfilingFeature.prototype.destroy = function () {
        this.logger('destroy');
        if (this.profiler === undefined)
            return;
        this.profiler.destroy();
    };
    return ProfilingFeature;
}());
exports.ProfilingFeature = ProfilingFeature;
//# sourceMappingURL=data:application/json;base64,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