/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.Version;

public class StructuralReasoner
extends OWLReasonerBase {
    @Nonnull
    private final ClassHierarchyInfo classHierarchyInfo = new ClassHierarchyInfo();
    @Nonnull
    private final ObjectPropertyHierarchyInfo objectPropertyHierarchyInfo = new ObjectPropertyHierarchyInfo();
    @Nonnull
    private final DataPropertyHierarchyInfo dataPropertyHierarchyInfo = new DataPropertyHierarchyInfo();
    @Nonnull
    private static final Version VERSION = new Version(1, 0, 0, 0);
    private boolean interrupted = false;
    @Nonnull
    protected final ReasonerProgressMonitor pm;
    private boolean prepared = false;

    public StructuralReasoner(@Nonnull OWLOntology rootOntology, @Nonnull OWLReasonerConfiguration configuration, @Nonnull BufferingMode bufferingMode) {
        super(rootOntology, configuration, bufferingMode);
        OWLAPIPreconditions.checkNotNull(configuration, "configuration cannot be null");
        this.pm = configuration.getProgressMonitor();
        this.prepareReasoner();
    }

    @Override
    @Nonnull
    public String getReasonerName() {
        return "Structural Reasoner";
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return FreshEntityPolicy.ALLOW;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return IndividualNodeSetPolicy.BY_NAME;
    }

    @Override
    @Nonnull
    public Version getReasonerVersion() {
        return VERSION;
    }

    @Override
    protected void handleChanges(@Nonnull Set<OWLAxiom> addAxioms, @Nonnull Set<OWLAxiom> removeAxioms) {
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.classHierarchyInfo);
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.objectPropertyHierarchyInfo);
        StructuralReasoner.handleChanges(addAxioms, removeAxioms, this.dataPropertyHierarchyInfo);
    }

    private static <T extends OWLObject> void handleChanges(@Nonnull Set<OWLAxiom> added, @Nonnull Set<OWLAxiom> removed, @Nonnull AbstractHierarchyInfo<T> hierarchyInfo) {
        Set<T> sig = hierarchyInfo.getEntitiesInSignature(added);
        sig.addAll(hierarchyInfo.getEntitiesInSignature(removed));
        hierarchyInfo.processChanges(sig, added, removed);
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    private void ensurePrepared() {
        if (!this.prepared) {
            this.prepareReasoner();
        }
    }

    public final void prepareReasoner() {
        this.classHierarchyInfo.computeHierarchy();
        this.objectPropertyHierarchyInfo.computeHierarchy();
        this.dataPropertyHierarchyInfo.computeHierarchy();
        this.prepared = true;
    }

    @Override
    public void precomputeInferences(InferenceType ... inferenceTypes) {
        this.prepareReasoner();
    }

    @Override
    public boolean isPrecomputed(InferenceType inferenceType) {
        return true;
    }

    @Override
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return CollectionFactory.createSet(new InferenceType[]{InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY});
    }

    protected void throwExceptionIfInterrupted() {
        if (this.interrupted) {
            this.interrupted = false;
            throw new ReasonerInterruptedException();
        }
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean isSatisfiable(@Nonnull OWLClassExpression classExpression) {
        return !classExpression.isAnonymous() && !this.getEquivalentClasses(classExpression.asOWLClass()).contains(this.getDataFactory().getOWLNothing());
    }

    @Override
    @Nonnull
    public Node<OWLClass> getUnsatisfiableClasses() {
        return OWLClassNode.getBottomNode();
    }

    @Override
    public boolean isEntailed(OWLAxiom axiom) {
        return this.getRootOntology().containsAxiom(axiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS);
    }

    @Override
    public boolean isEntailed(@Nonnull Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            assert (oWLAxiom != null);
            if (this.getRootOntology().containsAxiom(oWLAxiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    @Override
    public Node<OWLClass> getTopClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLThing());
    }

    @Override
    public Node<OWLClass> getBottomClassNode() {
        this.ensurePrepared();
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLNothing());
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getSubClasses(@Nonnull OWLClassExpression ce, boolean direct) {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyChildren(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getSuperClasses(@Nonnull OWLClassExpression ce, boolean direct) {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            this.ensurePrepared();
            return this.classHierarchyInfo.getNodeHierarchyParents(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    public Node<OWLClass> getEquivalentClasses(@Nonnull OWLClassExpression ce) {
        this.ensurePrepared();
        if (!ce.isAnonymous()) {
            return this.classHierarchyInfo.getEquivalents(ce.asOWLClass());
        }
        return new OWLClassNode();
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getDisjointClasses(@Nonnull OWLClassExpression ce) {
        this.ensurePrepared();
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(ce.asOWLClass())) {
                    for (OWLClassExpression op : ax.getClassExpressions()) {
                        if (op.isAnonymous()) continue;
                        nodeSet.addNode(this.getEquivalentClasses(op));
                    }
                }
            }
        }
        return nodeSet;
    }

    @Override
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopObjectProperty());
    }

    @Override
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomObjectProperty());
    }

    @Override
    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    @Override
    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    @Override
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        return this.objectPropertyHierarchyInfo.getEquivalents(pe);
    }

    @Override
    @Nonnull
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) {
        return new OWLObjectPropertyNodeSet();
    }

    @Override
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(@Nonnull OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        OWLObjectPropertyExpression inv = pe.getInverseProperty().getSimplified();
        return this.getEquivalentObjectProperties(inv);
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyDomains(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
            for (OWLObjectPropertyExpression invPe : this.getInverseObjectProperties(pe).getEntities()) {
                assert (invPe != null);
                for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getObjectPropertyRanges(@Nonnull OWLObjectPropertyExpression pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(pe)) {
                result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
            }
            for (OWLObjectPropertyExpression invPe : this.getInverseObjectProperties(pe).getEntities()) {
                assert (invPe != null);
                for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopDataProperty());
    }

    @Override
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomDataProperty());
    }

    @Override
    @Nonnull
    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    @Override
    @Nonnull
    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    @Override
    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) {
        this.ensurePrepared();
        return this.dataPropertyHierarchyInfo.getEquivalents(pe);
    }

    @Override
    @Nonnull
    public NodeSet<OWLDataProperty> getDisjointDataProperties(@Nonnull OWLDataPropertyExpression pe) {
        this.ensurePrepared();
        OWLDataPropertyNodeSet result = new OWLDataPropertyNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDisjointDataPropertiesAxiom axiom : ontology.getDisjointDataPropertiesAxioms(pe.asOWLDataProperty())) {
                for (OWLDataPropertyExpression dpe : axiom.getPropertiesMinus(pe)) {
                    if (dpe.isAnonymous()) continue;
                    result.addNode(this.dataPropertyHierarchyInfo.getEquivalents(dpe.asOWLDataProperty()));
                    result.addAllNodes(this.getSubDataProperties(dpe.asOWLDataProperty(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyDomainAxiom axiom : ontology.getDataPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) {
        this.ensurePrepared();
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(ind)) {
                OWLClassExpression ce = axiom.getClassExpression();
                if (ce.isAnonymous()) continue;
                result.addNode(this.classHierarchyInfo.getEquivalents(ce.asOWLClass()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(ce, false).getNodes());
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public NodeSet<OWLNamedIndividual> getInstances(@Nonnull OWLClassExpression ce, boolean direct) {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        if (!ce.isAnonymous()) {
            OWLClass cls = ce.asOWLClass();
            HashSet<OWLClass> clses = new HashSet<OWLClass>();
            clses.add(cls);
            if (!direct) {
                clses.addAll(this.getSubClasses(cls, false).getFlattened());
            }
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLClass curCls : clses) {
                    assert (curCls != null);
                    for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(curCls)) {
                        OWLIndividual individual = axiom.getIndividual();
                        if (individual.isAnonymous()) continue;
                        if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                            result.addNode(this.getSameIndividuals(individual.asOWLNamedIndividual()));
                            continue;
                        }
                        result.addNode(new OWLNamedIndividualNode(individual.asOWLNamedIndividual()));
                    }
                }
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, @Nonnull OWLObjectPropertyExpression pe) {
        this.ensurePrepared();
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        Node<OWLObjectPropertyExpression> inverses = this.getInverseObjectProperties(pe);
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyAssertionAxiom axiom : ontology.getObjectPropertyAssertionAxioms(ind)) {
                OWLObjectPropertyExpression invPe;
                if (!((OWLIndividual)axiom.getObject()).isAnonymous() && ((OWLObjectPropertyExpression)axiom.getProperty()).getSimplified().equals(pe.getSimplified())) {
                    if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                        result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    } else {
                        result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    }
                }
                if (!((OWLIndividual)axiom.getObject()).equals(ind) || axiom.getSubject().isAnonymous() || (invPe = ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty().getSimplified()).isAnonymous() || !inverses.contains(invPe.asOWLObjectProperty())) continue;
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    continue;
                }
                result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) {
        this.ensurePrepared();
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        Set<OWLDataProperty> superProperties = this.getSuperDataProperties(pe, false).getFlattened();
        superProperties.addAll(this.getEquivalentDataProperties(pe).getEntities());
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyAssertionAxiom axiom : ontology.getDataPropertyAssertionAxioms(ind)) {
                if (!superProperties.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty())) continue;
                literals.add((OWLLiteral)axiom.getObject());
            }
        }
        return literals;
    }

    @Override
    @Nonnull
    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) {
        this.ensurePrepared();
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet<OWLSameIndividualAxiom> processed = new HashSet<OWLSameIndividualAxiom>();
        LinkedList<OWLNamedIndividual> stack = new LinkedList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            assert (currentInd != null);
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLSameIndividualAxiom axiom : ontology.getSameIndividualAxioms(currentInd)) {
                    if (processed.contains(axiom)) continue;
                    processed.add(axiom);
                    for (OWLIndividual i : axiom.getIndividuals()) {
                        OWLNamedIndividual namedInd;
                        if (i.isAnonymous() || !inds.add(namedInd = i.asOWLNamedIndividual())) continue;
                        stack.add(namedInd);
                    }
                }
            }
        }
        if (inds.isEmpty()) {
            inds.add(ind);
        }
        return new OWLNamedIndividualNode((Set<OWLNamedIndividual>)inds);
    }

    @Override
    @Nonnull
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) {
        this.ensurePrepared();
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet<OWLDifferentIndividualsAxiom> processed = new HashSet<OWLDifferentIndividualsAxiom>();
        LinkedList<OWLNamedIndividual> stack = new LinkedList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            assert (currentInd != null);
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLDifferentIndividualsAxiom axiom : ontology.getDifferentIndividualAxioms(currentInd)) {
                    if (processed.contains(axiom)) continue;
                    processed.add(axiom);
                    for (OWLIndividual i : axiom.getIndividuals()) {
                        OWLNamedIndividual namedInd;
                        if (i.isAnonymous() || !inds.add(namedInd = i.asOWLNamedIndividual())) continue;
                        stack.add(namedInd);
                    }
                }
            }
        }
        if (inds.isEmpty()) {
            inds.add(ind);
        }
        HashSet<Node<OWLNamedIndividual>> set = new HashSet<Node<OWLNamedIndividual>>();
        for (OWLNamedIndividual n : inds) {
            set.add(this.getSameIndividuals(n));
        }
        return new OWLNamedIndividualNodeSet((Set<Node<OWLNamedIndividual>>)set);
    }

    protected OWLDataFactory getDataFactory() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
    }

    public void dumpClassHierarchy(boolean showBottomNode) {
        this.dumpClassHierarchy(OWLClassNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpClassHierarchy(@Nonnull Node<OWLClass> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLClass representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentClasses(representative));
        for (Node node : this.getSubClasses(representative, true)) {
            assert (node != null);
            this.dumpClassHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpObjectPropertyHierarchy(boolean showBottomNode) {
        this.dumpObjectPropertyHierarchy(OWLObjectPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpObjectPropertyHierarchy(@Nonnull Node<OWLObjectPropertyExpression> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLObjectPropertyExpression representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentObjectProperties(representative));
        for (Node node : this.getSubObjectProperties(representative, true)) {
            assert (node != null);
            this.dumpObjectPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpDataPropertyHierarchy(boolean showBottomNode) {
        this.dumpDataPropertyHierarchy(OWLDataPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpDataPropertyHierarchy(@Nonnull Node<OWLDataProperty> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        StructuralReasoner.printIndent(level);
        OWLDataProperty representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentDataProperties(representative));
        for (Node node : this.getSubDataProperties(representative, true)) {
            assert (node != null);
            this.dumpDataPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    private static void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    private class RawDataPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLDataProperty> {
        RawDataPropertyHierarchyProvider() {
        }

        @Override
        @Nonnull
        public Collection<OWLDataProperty> getParents(@Nonnull OWLDataProperty child) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            Collection axioms = StructuralReasoner.this.getRootOntology().filterAxioms(Filters.subDataPropertyWithSub, child, Imports.INCLUDED);
            Collection<OWLDataPropertyExpression> expressions = Searcher.sup(axioms, OWLDataPropertyExpression.class);
            for (OWLDataPropertyExpression prop : expressions) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }

        @Override
        @Nonnull
        public Collection<OWLDataProperty> getChildren(@Nonnull OWLDataProperty parent) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            Collection axioms = StructuralReasoner.this.getRootOntology().filterAxioms(Filters.subDataPropertyWithSuper, parent, Imports.INCLUDED);
            for (OWLDataPropertyExpression prop : Searcher.sub(axioms, OWLDataPropertyExpression.class)) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }
    }

    private class RawObjectPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLObjectPropertyExpression> {
        private OWLObjectPropertyManager propertyManager;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> sub2Super;
        private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> super2Sub;

        RawObjectPropertyHierarchyProvider() {
            this.rebuild();
        }

        public final void rebuild() {
            this.propertyManager = new OWLObjectPropertyManager(StructuralReasoner.this.getRootOntology().getOWLOntologyManager(), StructuralReasoner.this.getRootOntology());
            this.sub2Super = this.propertyManager.getPropertyHierarchy();
            this.super2Sub = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
            for (OWLObjectPropertyExpression sub : this.sub2Super.keySet()) {
                for (OWLObjectPropertyExpression superProp : this.sub2Super.get(sub)) {
                    Set<OWLObjectPropertyExpression> subs = this.super2Sub.get(superProp);
                    if (subs == null) {
                        subs = new HashSet<OWLObjectPropertyExpression>();
                        this.super2Sub.put(superProp, subs);
                    }
                    subs.add(sub);
                }
            }
        }

        @Override
        @Nonnull
        public Collection<OWLObjectPropertyExpression> getParents(@Nonnull OWLObjectPropertyExpression child) {
            if (child.isBottomEntity()) {
                return CollectionFactory.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.sub2Super.get(child);
            if (propertyExpressions == null) {
                return CollectionFactory.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }

        @Override
        @Nonnull
        public Collection<OWLObjectPropertyExpression> getChildren(@Nonnull OWLObjectPropertyExpression parent) {
            if (parent.isTopEntity()) {
                return CollectionFactory.emptySet();
            }
            Set<OWLObjectPropertyExpression> propertyExpressions = this.super2Sub.get(parent);
            if (propertyExpressions == null) {
                return CollectionFactory.emptySet();
            }
            return new HashSet<OWLObjectPropertyExpression>(propertyExpressions);
        }
    }

    private class RawClassHierarchyProvider
    implements RawHierarchyProvider<OWLClass> {
        RawClassHierarchyProvider() {
        }

        @Override
        @Nonnull
        public Collection<OWLClass> getParents(OWLClass child) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : StructuralReasoner.this.getRootOntology().getImportsClosure()) {
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSubClass(child)) {
                    OWLClassExpression superCls = oWLSubClassOfAxiom.getSuperClass();
                    if (!superCls.isAnonymous()) {
                        result.add(superCls.asOWLClass());
                        continue;
                    }
                    if (!(superCls instanceof OWLObjectIntersectionOf)) continue;
                    OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)superCls;
                    for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                        if (conjunct.isAnonymous()) continue;
                        result.add(conjunct.asOWLClass());
                    }
                }
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ont.getEquivalentClassesAxioms(child)) {
                    for (OWLClassExpression ce : oWLEquivalentClassesAxiom.getClassExpressionsMinus(child)) {
                        if (!ce.isAnonymous()) {
                            result.add(ce.asOWLClass());
                            continue;
                        }
                        if (!(ce instanceof OWLObjectIntersectionOf)) continue;
                        OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)ce;
                        for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                            if (conjunct.isAnonymous()) continue;
                            result.add(conjunct.asOWLClass());
                        }
                    }
                }
            }
            return result;
        }

        @Override
        @Nonnull
        public Collection<OWLClass> getChildren(OWLClass parent) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLAxiom ax : StructuralReasoner.this.getRootOntology().getReferencingAxioms((OWLPrimitive)parent, Imports.INCLUDED)) {
                if (ax instanceof OWLSubClassOfAxiom) {
                    Set<OWLClassExpression> conjuncts;
                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                    if (sca.getSubClass().isAnonymous() || !(conjuncts = sca.getSuperClass().asConjunctSet()).contains(parent)) continue;
                    result.add(sca.getSubClass().asOWLClass());
                    continue;
                }
                if (!(ax instanceof OWLEquivalentClassesAxiom)) continue;
                OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                for (OWLClassExpression ce : eca.getClassExpressions()) {
                    if (!ce.containsConjunct(parent)) continue;
                    for (OWLClassExpression sub : eca.getClassExpressions()) {
                        if (sub.isAnonymous() || sub.equals(ce)) continue;
                        result.add(sub.asOWLClass());
                    }
                }
            }
            return result;
        }
    }

    private static interface RawHierarchyProvider<T> {
        @Nonnull
        public Collection<T> getParents(@Nonnull T var1);

        @Nonnull
        public Collection<T> getChildren(@Nonnull T var1);
    }

    private class DataPropertyHierarchyInfo
    extends AbstractHierarchyInfo<OWLDataProperty> {
        DataPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "data property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopDataProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomDataProperty(), (RawHierarchyProvider)new RawDataPropertyHierarchyProvider());
        }

        @Override
        protected Set<OWLDataProperty> getEntitiesInSignature(@Nonnull OWLAxiom ax) {
            return ax.getDataPropertiesInSignature();
        }

        @Override
        protected Set<OWLDataProperty> getEntities(@Nonnull OWLOntology ont) {
            return ont.getDataPropertiesInSignature();
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLDataProperty> createNode(Set<OWLDataProperty> cycle) {
            return new OWLDataPropertyNode(cycle);
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLDataProperty> createNode() {
            return new OWLDataPropertyNode();
        }
    }

    private class ObjectPropertyHierarchyInfo
    extends AbstractHierarchyInfo<OWLObjectPropertyExpression> {
        ObjectPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "object property", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLTopObjectProperty(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLBottomObjectProperty(), (RawHierarchyProvider)new RawObjectPropertyHierarchyProvider());
        }

        @Override
        @Nonnull
        protected Set<OWLObjectPropertyExpression> getEntitiesInSignature(@Nonnull OWLAxiom ax) {
            HashSet<OWLObjectPropertyExpression> result = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectProperty property : ax.getObjectPropertiesInSignature()) {
                result.add(property);
                result.add(property.getInverseProperty());
            }
            return result;
        }

        @Override
        @Nonnull
        protected Set<OWLObjectPropertyExpression> getEntities(@Nonnull OWLOntology ont) {
            HashSet<OWLObjectPropertyExpression> result = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ont.getObjectPropertiesInSignature()) {
                result.add(oWLObjectPropertyExpression);
                result.add(oWLObjectPropertyExpression.getInverseProperty());
            }
            return result;
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLObjectPropertyExpression> createNode(Set<OWLObjectPropertyExpression> cycle) {
            return new OWLObjectPropertyNode(cycle);
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLObjectPropertyExpression> createNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        public void processChanges(@Nonnull Set<OWLObjectPropertyExpression> signature, @Nonnull Set<OWLAxiom> added, @Nonnull Set<OWLAxiom> removed) {
            boolean rebuild = false;
            for (OWLAxiom ax : added) {
                if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                rebuild = true;
                break;
            }
            if (!rebuild) {
                for (OWLAxiom ax : removed) {
                    if (!(ax instanceof OWLObjectPropertyAxiom)) continue;
                    rebuild = true;
                    break;
                }
            }
            if (rebuild) {
                ((RawObjectPropertyHierarchyProvider)this.getRawParentChildProvider()).rebuild();
            }
            super.processChanges(signature, added, removed);
        }
    }

    private class ClassHierarchyInfo
    extends AbstractHierarchyInfo<OWLClass> {
        ClassHierarchyInfo() {
            super(StructuralReasoner.this, "class", (OWLObject)StructuralReasoner.this.getDataFactory().getOWLThing(), (OWLObject)StructuralReasoner.this.getDataFactory().getOWLNothing(), (RawHierarchyProvider)new RawClassHierarchyProvider());
        }

        @Override
        @Nonnull
        protected Set<OWLClass> getEntitiesInSignature(@Nonnull OWLAxiom ax) {
            return ax.getClassesInSignature();
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLClass> createNode(@Nonnull Set<OWLClass> cycle) {
            return new OWLClassNode(cycle);
        }

        @Override
        @Nonnull
        protected Set<OWLClass> getEntities(@Nonnull OWLOntology ont) {
            return ont.getClassesInSignature();
        }

        @Override
        @Nonnull
        protected DefaultNode<OWLClass> createNode() {
            return new OWLClassNode();
        }
    }

    private static class NodeCache<T extends OWLObject> {
        @Nonnull
        private final AbstractHierarchyInfo<T> hierarchyInfo;
        private Node<T> topNode;
        private Node<T> bottomNode;
        @Nonnull
        private final Map<T, Node<T>> map = new HashMap<T, Node<T>>();

        protected NodeCache(@Nonnull AbstractHierarchyInfo<T> hierarchyInfo) {
            this.hierarchyInfo = hierarchyInfo;
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void addNode(@Nonnull Node<T> node) {
            for (OWLObject element : node.getEntities()) {
                this.map.put(element, node);
                if (element.isTopEntity()) {
                    this.topNode = node;
                    continue;
                }
                if (!element.isBottomEntity()) continue;
                this.bottomNode = node;
            }
        }

        @Nonnull
        public Set<Node<T>> getNodes(@Nonnull Set<T> elements) {
            HashSet<Node<T>> result = new HashSet<Node<T>>();
            for (OWLObject element : elements) {
                assert (element != null);
                result.add(this.getNode(element));
            }
            return result;
        }

        @Nonnull
        public Node<T> getNode(@Nonnull T containing) {
            Node<T> parentNode = this.map.get(containing);
            if (parentNode != null) {
                return parentNode;
            }
            return this.hierarchyInfo.createNode(CollectionFactory.createSet(containing));
        }

        public void addNode(@Nonnull Set<T> elements) {
            this.addNode(this.hierarchyInfo.createNode(elements));
        }

        @Nonnull
        public Node<T> getTopNode() {
            return OWLAPIPreconditions.verifyNotNull(this.topNode);
        }

        @Nonnull
        public Node<T> getBottomNode() {
            return OWLAPIPreconditions.verifyNotNull(this.bottomNode);
        }

        public final void clearTopNode() {
            this.removeNode(this.hierarchyInfo.topEntity);
            this.topNode = this.hierarchyInfo.createNode(CollectionFactory.createSet(this.hierarchyInfo.topEntity));
            this.addNode(this.getTopNode());
        }

        public final void clearBottomNode() {
            this.removeNode(this.hierarchyInfo.bottomEntity);
            this.bottomNode = this.hierarchyInfo.createNode(CollectionFactory.createSet(this.hierarchyInfo.bottomEntity));
            this.addNode(this.getBottomNode());
        }

        public void clearNodes(@Nonnull Set<T> containing) {
            for (OWLObject entity : containing) {
                this.removeNode(entity);
            }
        }

        public void clear() {
            this.map.clear();
            this.clearTopNode();
            this.clearBottomNode();
        }

        public void removeNode(T containing) {
            Node<T> node = this.map.remove(containing);
            if (node != null) {
                for (OWLObject object : node.getEntities()) {
                    this.map.remove(object);
                }
            }
        }
    }

    private static abstract class AbstractHierarchyInfo<T extends OWLObject> {
        private final RawHierarchyProvider<T> rawParentChildProvider;
        @Nonnull
        T topEntity;
        @Nonnull
        T bottomEntity;
        @Nonnull
        private final Set<T> directChildrenOfTopNode = new HashSet<T>();
        @Nonnull
        private final Set<T> directParentsOfBottomNode = new HashSet<T>();
        private final NodeCache<T> nodeCache;
        private final String name;
        private int classificationSize;
        final /* synthetic */ StructuralReasoner this$0;

        AbstractHierarchyInfo(@Nonnull String name, @Nonnull T topEntity, T bottomEntity, RawHierarchyProvider<T> rawParentChildProvider) {
            this.this$0 = var1_1;
            this.topEntity = topEntity;
            this.bottomEntity = bottomEntity;
            this.nodeCache = new NodeCache(this);
            this.rawParentChildProvider = rawParentChildProvider;
            this.name = name;
        }

        public RawHierarchyProvider<T> getRawParentChildProvider() {
            return this.rawParentChildProvider;
        }

        @Nonnull
        protected abstract Set<T> getEntities(@Nonnull OWLOntology var1);

        @Nonnull
        protected abstract DefaultNode<T> createNode(@Nonnull Set<T> var1);

        @Nonnull
        protected abstract DefaultNode<T> createNode();

        @Nonnull
        protected abstract Set<? extends T> getEntitiesInSignature(@Nonnull OWLAxiom var1);

        @Nonnull
        Set<T> getEntitiesInSignature(@Nonnull Set<OWLAxiom> axioms) {
            HashSet<T> result = new HashSet<T>();
            for (OWLAxiom ax : axioms) {
                assert (ax != null);
                result.addAll(this.getEntitiesInSignature(ax));
            }
            return result;
        }

        public void computeHierarchy() {
            this.this$0.pm.reasonerTaskStarted("Computing " + this.name + " hierarchy");
            this.this$0.pm.reasonerTaskBusy();
            this.nodeCache.clear();
            HashMap cache = new HashMap();
            HashSet<T> entities = new HashSet<T>();
            for (OWLOntology ont : this.this$0.getRootOntology().getImportsClosure()) {
                assert (ont != null);
                entities.addAll(this.getEntities(ont));
            }
            this.classificationSize = entities.size();
            this.this$0.pm.reasonerTaskProgressChanged(0, this.classificationSize);
            this.updateForSignature(entities, cache);
            this.this$0.pm.reasonerTaskStopped();
        }

        private void updateForSignature(@Nonnull Set<T> signature, @Nullable Map<T, Collection<T>> cache) {
            HashSet<Set<T>> cyclesResult = new HashSet<Set<T>>();
            HashSet processed = new HashSet();
            this.nodeCache.clearTopNode();
            this.nodeCache.clearBottomNode();
            this.nodeCache.clearNodes(signature);
            this.directChildrenOfTopNode.removeAll(signature);
            HashSet equivTopOrChildrenOfTop = new HashSet();
            HashSet equivBottomOrParentsOfBottom = new HashSet();
            for (OWLObject oWLObject : signature) {
                assert (oWLObject != null);
                if (processed.contains(oWLObject)) continue;
                this.this$0.pm.reasonerTaskProgressChanged(processed.size(), signature.size());
                this.tarjan(oWLObject, 0, new Stack(), new HashMap(), new HashMap(), cyclesResult, processed, new HashSet(), cache, equivTopOrChildrenOfTop, equivBottomOrParentsOfBottom);
                this.this$0.throwExceptionIfInterrupted();
            }
            for (Set set : cyclesResult) {
                assert (set != null);
                this.nodeCache.addNode(set);
            }
            this.directChildrenOfTopNode.addAll(equivTopOrChildrenOfTop);
            this.directChildrenOfTopNode.removeAll(this.nodeCache.getTopNode().getEntities());
            this.directParentsOfBottomNode.addAll(equivBottomOrParentsOfBottom);
            this.directParentsOfBottomNode.removeAll(this.nodeCache.getBottomNode().getEntities());
            for (Set set : cyclesResult) {
                if (set.contains(this.topEntity) || set.contains(this.bottomEntity)) continue;
                boolean childOfTop = true;
                for (OWLObject element : set) {
                    assert (element != null);
                    Collection<OWLObject> parents = this.rawParentChildProvider.getParents(element);
                    parents.removeAll(set);
                    parents.removeAll(this.nodeCache.getTopNode().getEntities());
                    if (parents.isEmpty()) continue;
                    childOfTop = false;
                    break;
                }
                if (childOfTop) {
                    this.directChildrenOfTopNode.addAll(set);
                }
                boolean parentOfBottom = true;
                for (OWLObject element : set) {
                    assert (element != null);
                    Collection<OWLObject> children = this.rawParentChildProvider.getChildren(element);
                    children.removeAll(set);
                    children.removeAll(this.nodeCache.getBottomNode().getEntities());
                    if (children.isEmpty()) continue;
                    parentOfBottom = false;
                    break;
                }
                if (!parentOfBottom) continue;
                this.directParentsOfBottomNode.addAll(set);
            }
        }

        public void processChanges(@Nonnull Set<T> signature, @Nonnull Set<OWLAxiom> added, @Nonnull Set<OWLAxiom> removed) {
            this.updateForSignature(signature, null);
        }

        public void tarjan(@Nonnull T entity, int inputIndex, @Nonnull Stack<T> stack, @Nonnull Map<T, Integer> indexMap, @Nonnull Map<T, Integer> lowlinkMap, @Nonnull Set<Set<T>> result, @Nonnull Set<T> processed, @Nonnull Set<T> stackEntities, @Nullable Map<T, Collection<T>> cache, @Nonnull Set<T> childrenOfTop, @Nonnull Set<T> parentsOfBottom) {
            Collection<T> rawChildren;
            int index = inputIndex;
            this.this$0.throwExceptionIfInterrupted();
            if (processed.add(entity) && ((rawChildren = this.rawParentChildProvider.getChildren(entity)).isEmpty() || rawChildren.contains(this.bottomEntity))) {
                parentsOfBottom.add(entity);
            }
            this.this$0.pm.reasonerTaskProgressChanged(processed.size(), this.classificationSize);
            indexMap.put(entity, index);
            lowlinkMap.put(entity, index);
            ++index;
            stack.push(entity);
            stackEntities.add(entity);
            Collection<T> rawParents = null;
            if (cache != null) {
                rawParents = cache.get(entity);
                if (rawParents == null) {
                    rawParents = this.rawParentChildProvider.getParents(entity);
                    if (rawParents.isEmpty() || rawParents.contains(this.topEntity)) {
                        childrenOfTop.add(entity);
                    }
                    cache.put(entity, rawParents);
                }
            } else {
                rawParents = this.rawParentChildProvider.getParents(entity);
                if (rawParents.isEmpty() || rawParents.contains(this.topEntity)) {
                    childrenOfTop.add(entity);
                }
            }
            for (OWLObject superEntity : rawParents) {
                assert (superEntity != null);
                if (!indexMap.containsKey(superEntity)) {
                    this.tarjan(superEntity, index, stack, indexMap, lowlinkMap, result, processed, stackEntities, cache, childrenOfTop, parentsOfBottom);
                    lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), lowlinkMap.get(superEntity)));
                    continue;
                }
                if (!stackEntities.contains(superEntity)) continue;
                lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), indexMap.get(superEntity)));
            }
            if (lowlinkMap.get(entity).equals(indexMap.get(entity))) {
                OWLObject clsPrime;
                HashSet<OWLObject> scc = new HashSet<OWLObject>();
                do {
                    clsPrime = (OWLObject)stack.pop();
                    stackEntities.remove(clsPrime);
                    scc.add(clsPrime);
                } while (!clsPrime.equals(entity));
                if (scc.size() > 1) {
                    result.add(scc);
                }
            }
        }

        @Nonnull
        public NodeSet<T> getNodeHierarchyChildren(@Nonnull T parent, boolean direct, @Nonnull DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(parent);
            if (node.isBottomNode()) {
                return ns;
            }
            HashSet<OWLObject> directChildren = new HashSet<OWLObject>();
            for (OWLObject oWLObject : node) {
                assert (oWLObject != null);
                directChildren.addAll(this.rawParentChildProvider.getChildren(oWLObject));
                if (!this.directParentsOfBottomNode.contains(oWLObject)) continue;
                ns.addNode(this.nodeCache.getBottomNode());
            }
            directChildren.removeAll(node.getEntities());
            if (node.isTopNode()) {
                directChildren.addAll(this.directChildrenOfTopNode);
            }
            for (Node node2 : this.nodeCache.getNodes(directChildren)) {
                assert (node2 != null);
                ns.addNode(node2);
            }
            if (!direct) {
                for (OWLObject oWLObject : directChildren) {
                    assert (oWLObject != null);
                    this.getNodeHierarchyChildren(oWLObject, direct, ns);
                }
            }
            return ns;
        }

        @Nonnull
        public NodeSet<T> getNodeHierarchyParents(@Nonnull T child, boolean direct, @Nonnull DefaultNodeSet<T> ns) {
            Node<T> node = this.nodeCache.getNode(child);
            if (node.isTopNode()) {
                return ns;
            }
            HashSet<OWLObject> directParents = new HashSet<OWLObject>();
            for (OWLObject oWLObject : node) {
                assert (oWLObject != null);
                directParents.addAll(this.rawParentChildProvider.getParents(oWLObject));
                if (!this.directChildrenOfTopNode.contains(oWLObject)) continue;
                ns.addNode(this.nodeCache.getTopNode());
            }
            directParents.removeAll(node.getEntities());
            if (node.isBottomNode()) {
                directParents.addAll(this.directParentsOfBottomNode);
            }
            for (Node node2 : this.nodeCache.getNodes(directParents)) {
                assert (node2 != null);
                ns.addNode(node2);
            }
            if (!direct) {
                for (OWLObject oWLObject : directParents) {
                    assert (oWLObject != null);
                    this.getNodeHierarchyParents(oWLObject, direct, ns);
                }
            }
            return ns;
        }

        @Nonnull
        public Node<T> getEquivalents(@Nonnull T element) {
            return this.nodeCache.getNode(element);
        }
    }
}

