/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LiteralChecker {
    public static boolean isLiteralIsInLexicalSpace(OWLLiteral literal) {
        OWLDatatype d = literal.getDatatype();
        if (d.isRDFPlainLiteral()) {
            return true;
        }
        if (d.isString()) {
            return true;
        }
        if (d.isBuiltIn()) {
            OWL2Datatype builtIn = d.getBuiltInDatatype();
            if (builtIn.equals((Object)OWL2Datatype.RDF_XML_LITERAL)) {
                return LiteralChecker.checkXMLLiteral(literal);
            }
            Pattern pattern = builtIn.getPattern();
            return pattern.matcher(literal.getLiteral()).matches();
        }
        return true;
    }

    private static boolean checkXMLLiteral(OWLLiteral literal) {
        try {
            SAXParsers.initParserWithOWLAPIStandards(null, (String)"1000000").parse(new InputSource(new StringReader(literal.getLiteral())), new DefaultHandler());
            return true;
        }
        catch (IOException | SAXException e) {
            return false;
        }
    }
}

