/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.ActionSet;
import org.freehep.util.io.ByteCountOutputStream;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;
import org.freehep.util.io.TaggedOutput;
import org.freehep.util.io.UndefinedTagException;

public abstract class TaggedOutputStream
extends ByteCountOutputStream
implements TaggedOutput {
    protected TagSet tagSet;
    protected ActionSet actionSet;

    public TaggedOutputStream(OutputStream out, TagSet tagSet, ActionSet actionSet) {
        this(out, tagSet, actionSet, false);
    }

    public TaggedOutputStream(OutputStream out, TagSet tagSet, ActionSet actionSet, boolean littleEndian) {
        super(out, littleEndian);
        this.tagSet = tagSet;
        this.actionSet = actionSet;
    }

    protected abstract void writeTagHeader(TagHeader var1) throws IOException;

    protected int getTagAlignment() {
        return 1;
    }

    public void writeTag(Tag tag) throws IOException {
        int tagID = tag.getTag();
        if (!this.tagSet.exists(tagID)) {
            throw new UndefinedTagException(tagID);
        }
        this.pushBuffer();
        tag.write(tagID, this);
        int align = this.getTagAlignment();
        int pad = (align - this.getBufferLength() % align) % align;
        int i = 0;
        while (i < pad) {
            this.write(0);
            ++i;
        }
        int len = this.popBuffer();
        TagHeader header = this.createTagHeader(tag, len);
        this.writeTagHeader(header);
        this.append();
    }

    protected TagHeader createTagHeader(Tag tag, long len) {
        return new TagHeader(tag.getTag(), len);
    }

    protected abstract void writeActionHeader(ActionHeader var1) throws IOException;

    public void writeAction(Action action) throws IOException {
        if (action == null) {
            this.writeByte(0);
            return;
        }
        int actionCode = action.getCode();
        if (!this.actionSet.exists(actionCode)) {
            throw new UndefinedTagException(actionCode);
        }
        this.pushBuffer();
        action.write(actionCode, this);
        int len = this.popBuffer();
        ActionHeader header = new ActionHeader(actionCode, len);
        this.writeActionHeader(header);
        this.append();
    }
}

