/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.Ice.Identity;
import com.zeroc.Ice.ToStringMode;
import com.zeroc.Ice.Util;
import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.ObjectDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class PropertiesField
extends JTable {
    private DefaultTableModel _model;
    private Vector<String> _columnNames;
    private boolean _editable = false;
    private LinkedList<PropertyDescriptor> _hiddenProperties = new LinkedList();
    private Editor _editor;

    public PropertiesField(Editor editor) {
        this._columnNames = new Vector(2);
        this._columnNames.add("Name");
        this._columnNames.add("Value");
        this._editor = editor;
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PropertiesField.this._editable) {
                    int selectedRow;
                    if (PropertiesField.this.isEditing()) {
                        PropertiesField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = PropertiesField.this.getSelectedRow()) != -1) {
                        PropertiesField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void setProperties(List<PropertyDescriptor> properties, List<AdapterDescriptor> adapters, String[] logs, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        HashSet<String> hiddenPropertyNames = new HashSet<String>();
        HashSet<String> hiddenPropertyValues = new HashSet<String>();
        this._hiddenProperties.clear();
        if (adapters != null) {
            for (AdapterDescriptor p : adapters) {
                hiddenPropertyNames.add(p.name + ".Endpoints");
                hiddenPropertyNames.add(p.name + ".PublishedEndpoints");
                hiddenPropertyNames.add(p.name + ".ProxyOptions");
                for (ObjectDescriptor q : p.objects) {
                    hiddenPropertyValues.add(Util.identityToString((Identity)q.id, (ToStringMode)ToStringMode.Unicode));
                }
                for (ObjectDescriptor q : p.allocatables) {
                    hiddenPropertyValues.add(Util.identityToString((Identity)q.id, (ToStringMode)ToStringMode.Unicode));
                }
            }
        }
        if (logs != null) {
            for (String log : logs) {
                hiddenPropertyValues.add(log);
            }
        }
        Vector vector = new Vector(properties.size());
        for (PropertyDescriptor p : properties) {
            if (hiddenPropertyNames.contains(p.name)) {
                if (this._editable) {
                    this._hiddenProperties.add(p);
                }
                hiddenPropertyNames.remove(p.name);
                continue;
            }
            if (hiddenPropertyValues.contains(p.value)) {
                if (this._editable) {
                    this._hiddenProperties.add(p);
                }
                hiddenPropertyValues.remove(p.value);
                continue;
            }
            Vector<String> row = new Vector<String>(2);
            row.add(Utils.substitute(p.name, resolver));
            row.add(Utils.substitute(p.value, resolver));
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(2);
            newRow.add("");
            newRow.add("");
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return PropertiesField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (PropertiesField.this._editable) {
                    Object lastKey = PropertiesField.this._model.getValueAt(PropertiesField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        PropertiesField.this._model.addRow(new Object[]{"", ""});
                    }
                    PropertiesField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public LinkedList<PropertyDescriptor> getProperties() {
        assert (this._editable);
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        LinkedList<PropertyDescriptor> result = new LinkedList<PropertyDescriptor>(this._hiddenProperties);
        for (Vector row : vector) {
            String key = row.elementAt(0).toString();
            if (key == null || (key = key.trim()).equals("")) continue;
            String val = row.elementAt(1).toString();
            if (val == null) {
                val = "";
            }
            result.add(new PropertyDescriptor(key, val));
        }
        return result;
    }
}

