/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.io;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.glsof.common.io.XMLRepository;
import net.sourceforge.glsof.common.model.Preferences;

public class PreferencesRepository
extends XMLRepository<Preferences> {
    public PreferencesRepository(File baseDir) {
        super(baseDir);
    }

    public List<Boolean> getColumns(String name) {
        return this.read(name).getColumns();
    }

    public void saveColumns(List<Boolean> views, String name) {
        Preferences prefs = this.read(name);
        prefs.setColumns(views);
        this.save(prefs);
    }

    public Preferences read(String name) {
        return this.read(Preferences.class, name);
    }

    public void save(Preferences preferences) {
        this.write(preferences, preferences.getName());
    }

    public boolean rename(String oldName, String newName) {
        if (this.fileExists(newName)) {
            return false;
        }
        Preferences prefs = this.read(oldName);
        prefs.setName(newName);
        this.save(prefs);
        this.remove(oldName);
        return true;
    }

    public List<String> findAllNames() {
        String[] fileNames = this._baseDir.list();
        LinkedList<String> names = new LinkedList<String>();
        if (fileNames == null) {
            return names;
        }
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".xml")) continue;
            names.add(fileName.substring(0, fileName.indexOf(".xml")));
        }
        return names;
    }

    public void copy(String src, String dest) {
        Preferences p = this.read(src);
        p.setName(dest);
        this.save(p);
    }

    public boolean remove(String name) {
        return this.getRealFile(name).delete();
    }
}

