/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.TopComponentGroupModel;
import org.openide.windows.TopComponent;

final class DefaultTopComponentGroupModel
implements TopComponentGroupModel {
    private final String name;
    private boolean opened;
    private final Set<String> topComponents = new HashSet<String>(3);
    private final Set<String> openedTopComponents = new HashSet<String>(3);
    private final Set<String> openedBeforeTopComponents = new HashSet<String>(3);
    private final Set<String> openingTopComponents = new HashSet<String>(3);
    private final Set<String> closingTopComponents = new HashSet<String>(3);
    private final Object LOCK_OPENED = new Object();
    private final Object LOCK_TOPCOMPONENTS = new Object();

    public DefaultTopComponentGroupModel(String string, boolean bl) {
        this.name = string;
        this.opened = bl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(Collection<TopComponent> collection, Collection<TopComponent> collection2) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            String string;
            this.opened = true;
            this.openedTopComponents.clear();
            for (TopComponent topComponent : collection) {
                string = DefaultTopComponentGroupModel.getID(topComponent);
                if (string == null) continue;
                this.openedTopComponents.add(string);
            }
            this.openedBeforeTopComponents.clear();
            for (TopComponent topComponent : collection2) {
                string = DefaultTopComponentGroupModel.getID(topComponent);
                if (string == null) continue;
                this.openedBeforeTopComponents.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            this.opened = false;
            this.openedTopComponents.clear();
            this.openedBeforeTopComponents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            return this.opened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopComponent> getTopComponents() {
        HashSet<String> hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet<String>(this.topComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        for (String string : hashSet) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent(string);
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopComponent> getOpenedTopComponents() {
        HashSet<String> hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_OPENED;
        synchronized (hashSet2) {
            hashSet = new HashSet<String>(this.openedTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        for (String string : hashSet) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent(string);
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopComponent> getOpenedBeforeTopComponents() {
        HashSet<String> hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_OPENED;
        synchronized (hashSet2) {
            hashSet = new HashSet<String>(this.openedBeforeTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        for (String string : hashSet) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent(string);
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopComponent> getOpeningTopComponents() {
        HashSet<String> hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet<String>(this.openingTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        for (String string : hashSet) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent(string);
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TopComponent> getClosingTopComponents() {
        HashSet<String> hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet<String>(this.closingTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        for (String string : hashSet) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent(string);
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUnloadedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponents.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUnloadedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (this.openingTopComponents.contains(string)) {
                this.openingTopComponents.remove(string);
            }
            if (this.closingTopComponents.contains(string)) {
                this.closingTopComponents.remove(string);
            }
            return this.topComponents.remove(string);
        }
    }

    @Override
    public boolean addOpeningTopComponent(TopComponent topComponent) {
        return this.addUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(topComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUnloadedOpeningTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(string)) {
                this.topComponents.add(string);
            }
            return this.openingTopComponents.add(string);
        }
    }

    @Override
    public boolean removeOpeningTopComponent(TopComponent topComponent) {
        return this.removeUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(topComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUnloadedOpeningTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.openingTopComponents.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUnloadedClosingTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(string)) {
                this.topComponents.add(string);
            }
            return this.closingTopComponents.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUnloadedClosingTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.closingTopComponents.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUnloadedOpenedTopComponent(String string) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            if (!this.opened) {
                return false;
            }
            this.openedTopComponents.add(string);
        }
        return true;
    }

    private static TopComponent getTopComponent(String string) {
        return WindowManagerImpl.getInstance().getTopComponentForID(string);
    }

    private static String getID(TopComponent topComponent) {
        return WindowManagerImpl.getInstance().findTopComponentID(topComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet<String>(this.topComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getOpeningSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet<String>(this.openingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClosingSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet<String>(this.closingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getOpenedTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet<String>(this.openedTopComponents);
        }
    }
}

