/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerFeature;
import java.text.NumberFormat;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.api.icons.Icons;

public class JavaHeapSummaryView
extends HeapViewerFeature {
    private final HeapContext context;
    private JComponent component;
    private ProfilerToolbar toolbar;
    private String summaryText;
    private static final String LINE_PREFIX = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public JavaHeapSummaryView(HeapContext context) {
        super("java_heap_summary", Bundle.JavaHeapSummaryView_Name(), Bundle.JavaHeapSummaryView_Description(), Icons.getIcon((String)"HeapWalkerIcons.Properties"), 100);
        this.context = context;
        this.summaryText = this.createSummary();
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        HTMLTextArea text = new HTMLTextArea(this.summaryText);
        text.setCaretPosition(0);
        text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.component = new ScrollableContainer((JComponent)text);
        this.summaryText = null;
    }

    private String createSummary() {
        Heap heap = this.context.getFragment().getHeap();
        HeapSummary hsummary = heap.getSummary();
        long finalizers = this.computeFinalizers(heap);
        int nclassloaders = 0;
        JavaClass cl = heap.getJavaClassByName("java.lang.ClassLoader");
        NumberFormat numberFormat = (NumberFormat)NumberFormat.getInstance().clone();
        numberFormat.setMaximumFractionDigits(1);
        if (cl != null) {
            nclassloaders = cl.getInstancesCount();
            Collection jcs = cl.getSubClasses();
            for (JavaClass jc : jcs) {
                nclassloaders += jc.getInstancesCount();
            }
        }
        String liveBytes = LINE_PREFIX + Bundle.JavaHeapSummaryView_TotalBytesItemString(numberFormat.format(hsummary.getTotalLiveBytes()));
        String liveClasses = LINE_PREFIX + Bundle.JavaHeapSummaryView_TotalClassesItemString(numberFormat.format(heap.getAllClasses().size()));
        String liveInstances = LINE_PREFIX + Bundle.JavaHeapSummaryView_TotalInstancesItemString(numberFormat.format(hsummary.getTotalLiveInstances()));
        String classloaders = LINE_PREFIX + Bundle.JavaHeapSummaryView_ClassloadersItemString(numberFormat.format(nclassloaders));
        String gcroots = LINE_PREFIX + Bundle.JavaHeapSummaryView_GcRootsItemString(numberFormat.format(heap.getGCRoots().size()));
        String finalizersInfo = LINE_PREFIX + Bundle.JavaHeapSummaryView_FinalizersItemString(finalizers >= 0L ? numberFormat.format(finalizers) : Bundle.JavaHeapSummaryView_NotAvailableMsg());
        String oomeString = "";
        String memoryRes = Icons.getResource((String)"ProfilerIcons.HeapDump");
        return "<b><img border='0' align='bottom' src='nbresloc:/" + memoryRes + "'>&nbsp;&nbsp;" + Bundle.JavaHeapSummaryView_SummaryString() + "</b><br><hr>" + liveBytes + "<br>" + liveClasses + "<br>" + liveInstances + "<br>" + classloaders + "<br>" + gcroots + "<br>" + finalizersInfo + oomeString;
    }

    private long computeFinalizers(Heap heap) {
        Long len;
        Instance queue;
        JavaClass finalizerClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (finalizerClass != null && (queue = (Instance)finalizerClass.getValueOfStaticField("queue")) != null && (len = (Long)queue.getValueOfField("queueLength")) != null) {
            return len;
        }
        return -1L;
    }
}

