/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.api;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.api.Bundle;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExportAction.class.getName());
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.Export");
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_TXT = "txt";
    private static final String FILE_EXTENSION_BIN = "bin";
    public static final int MODE_CSV = 1;
    public static final int MODE_TXT = 2;
    public static final int MODE_BIN = 3;
    private static File exportDir;
    private JFileChooser fileChooser;
    private final ExportProvider exportProvider;
    private int exportedFileType;

    public ExportAction(ExportProvider exportProvider) {
        this.putValue("Name", Bundle.ExportAction_BasicExportActionName());
        this.putValue("ShortDescription", Bundle.ExportAction_BasicExportActionDescr());
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.exportProvider = exportProvider;
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasRawData()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_CSV));
        }
        if (this.exportProvider.hasText()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_TXT));
        }
        if (this.exportProvider.hasBinaryData()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_BIN));
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ExportAction_ExportDialogTitle());
            this.fileChooser.setApproveButtonText(Bundle.ExportAction_ExportDialogButton());
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        return !file.exists() || ProfilerDialogs.displayConfirmation((String)Bundle.ExportAction_OverwriteFileMsg(file.getName()), (String)Bundle.ExportAction_OverwriteFileCaption());
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String string;
        File file;
        int n;
        String string2 = exportProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        if ((n = jFileChooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) != 0) {
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        String string3 = null;
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (fileFilter == null || fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogCSVFilter())) {
            string3 = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        } else if (fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogTXTFilter())) {
            string3 = FILE_EXTENSION_TXT;
            this.exportedFileType = 2;
        } else if (fileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogBINFilter())) {
            string3 = FILE_EXTENSION_BIN;
            this.exportedFileType = 3;
        }
        if (file2.isDirectory()) {
            exportDir = file2;
            file = file2;
            string = string2;
        } else {
            file = this.fileChooser.getCurrentDirectory();
            String string4 = file2.getName();
            if (string4.endsWith("." + string3)) {
                int n2 = string4.lastIndexOf(46);
                string = string4.substring(0, n2);
            } else {
                string = string4;
            }
        }
        return new SelectedFile(file, string, string3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.exportProvider.hasRawData() && !this.exportProvider.hasText()) {
            ProfilerDialogs.displayError((String)Bundle.ExportAction_NoViewMsg());
            return;
        }
        SelectedFile selectedFile = this.selectExportTargetFile(this.exportProvider);
        if (selectedFile == null) {
            return;
        }
        final File file = selectedFile.getSelectedFile();
        if (!this.checkFileExists(file)) {
            return;
        }
        new NBSwingWorker(true){
            private final ProgressHandle ph;
            {
                super(bl);
                this.ph = ProgressHandle.createHandle((String)Bundle.ExportAction_ExportingViewMsg());
            }

            protected void doInBackground() {
                this.ph.setInitialDelay(500);
                this.ph.start();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ExportDataDumper exportDataDumper = new ExportDataDumper(fileOutputStream);
                    ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, exportDataDumper);
                    if (exportDataDumper.getCaughtException() != null) {
                        ProfilerDialogs.displayError((String)(exportDataDumper.getNumExceptions() + Bundle.ExportAction_IOException_Exporting_Msg()));
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    ProfilerDialogs.displayError((String)(Bundle.ExportAction_OomeExportingMsg() + outOfMemoryError.getMessage()));
                }
                catch (IOException iOException) {
                    ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(iOException.getLocalizedMessage()));
                    LOGGER.log(Level.WARNING, iOException.toString());
                }
            }

            protected void done() {
                this.ph.finish();
            }
        }.execute();
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String extension;

        public FileFilterImpl(String string) {
            this.extension = string;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase(Locale.US).endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            if (ExportAction.FILE_EXTENSION_CSV.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogCSVFilter();
            }
            if (ExportAction.FILE_EXTENSION_TXT.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogTXTFilter();
            }
            if (ExportAction.FILE_EXTENSION_BIN.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogBINFilter();
            }
            return null;
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File file, String string, String string2) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
        }

        File getSelectedFile() {
            String string = this.folder.getAbsolutePath();
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            return new File(string + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean isExportable();

        public boolean hasRawData();

        public boolean hasBinaryData();

        public boolean hasText();
    }
}

