/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.results.ColoredFilter;
import org.netbeans.lib.profiler.ui.results.PackageColorer;
import org.netbeans.lib.profiler.ui.swing.EditableHistoryCombo;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.spi.ActionsSupportProvider;

public final class FilterUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    public static final String ACTION_FILTER = messages.getString("FilterUtils_ActionFilter");
    private static final String SIDEBAR_CAPTION = messages.getString("FilterUtils_SidebarCaption");
    private static final String BTN_FILTER_TOOLTIP = messages.getString("FilterUtils_BtnFilterTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("FilterUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("FilterUtils_BtnCloseTooltip");
    private static final String MSG_INVALID_REGEXP = messages.getString("FilterUtils_MsgInvalidRegexp");
    private static final String FILTER_CONTAINS = messages.getString("FilterUtils_FilterContains");
    private static final String FILTER_NOT_CONTAINS = messages.getString("FilterUtils_FilterNotContains");
    private static final String FILTER_REGEXP = messages.getString("FilterUtils_FilterRegexp");
    private static final String FILTER_TYPE = messages.getString("FilterUtils_FilterType");
    private static final String INSERT_FILTER = messages.getString("FilterUtils_InsertFilter");
    public static final String FILTER_ACTION_KEY = "filter-action-key";
    private static final String FILTER_CHANGED = "filter-changed";

    public static boolean filterContains(ProfilerTable profilerTable, String string) {
        return FilterUtils.filterContains(profilerTable, string, false, null);
    }

    public static boolean filterContains(ProfilerTable profilerTable, String string, boolean bl, RowFilter rowFilter) {
        return FilterUtils.filter(profilerTable, (GenericFilter)new TextFilter(string, 10, bl), rowFilter);
    }

    public static boolean filterNotContains(ProfilerTable profilerTable, String string, boolean bl, RowFilter rowFilter) {
        return FilterUtils.filter(profilerTable, (GenericFilter)new TextFilter(string, 20, bl), rowFilter);
    }

    public static boolean filterRegExp(ProfilerTable profilerTable, String string, RowFilter rowFilter) {
        return FilterUtils.filter(profilerTable, (GenericFilter)new TextFilter(string, 30, false), rowFilter);
    }

    public static boolean filter(ProfilerTable profilerTable, final GenericFilter genericFilter, final RowFilter rowFilter) {
        final int n = profilerTable.getMainColumn();
        Filter filter = new Filter(){

            public boolean include(RowFilter.Entry entry) {
                if (rowFilter != null && rowFilter.include(entry)) {
                    return true;
                }
                return genericFilter.passes(entry.getValue(n).toString());
            }
        };
        if (!genericFilter.isEmpty()) {
            profilerTable.addRowFilter(filter);
            return profilerTable.getRowCount() > 0;
        }
        profilerTable.removeRowFilter(filter);
        return false;
    }

    public static JComponent createFilterPanel(ProfilerTable profilerTable) {
        return FilterUtils.createFilterPanel(profilerTable, null);
    }

    public static JComponent createFilterPanel(ProfilerTable profilerTable, RowFilter rowFilter) {
        return FilterUtils.createFilterPanel(profilerTable, rowFilter, null);
    }

    public static JComponent createFilterPanel(final ProfilerTable profilerTable, final RowFilter rowFilter, Component[] componentArray) {
        InvisibleToolbar invisibleToolbar = new InvisibleToolbar();
        if (UIUtils.isWindowsModernLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
            invisibleToolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        }
        invisibleToolbar.add(Box.createHorizontalStrut(6));
        invisibleToolbar.add(new JLabel(SIDEBAR_CAPTION));
        invisibleToolbar.add(Box.createHorizontalStrut(3));
        final EditableHistoryCombo editableHistoryCombo = new EditableHistoryCombo();
        final JTextComponent jTextComponent = editableHistoryCombo.getTextComponent();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)editableHistoryCombo, "Center");
        jPanel.setMinimumSize(editableHistoryCombo.getMinimumSize());
        jPanel.setPreferredSize(editableHistoryCombo.getPreferredSize());
        jPanel.setMaximumSize(editableHistoryCombo.getMaximumSize());
        invisibleToolbar.add(jPanel);
        if (PackageColorer.hasRegisteredColors()) {
            invisibleToolbar.add(new PopupButton(){
                {
                    this.setToolTipText(INSERT_FILTER);
                }

                @Override
                protected void populatePopup(JPopupMenu jPopupMenu) {
                    for (final ColoredFilter coloredFilter : PackageColorer.getRegisteredColors()) {
                        if (coloredFilter.getValue().trim().isEmpty()) continue;
                        Icon icon = coloredFilter.getColor() == null ? null : coloredFilter.getIcon(12, 12);
                        jPopupMenu.add(new JMenuItem(coloredFilter.getName(), icon){

                            @Override
                            protected void fireActionPerformed(ActionEvent actionEvent) {
                                String string = FilterUtils.getFilterString(editableHistoryCombo);
                                if (string == null) {
                                    string = "";
                                }
                                if (!string.isEmpty()) {
                                    string = string + " ";
                                }
                                string = string + coloredFilter.getValue();
                                jTextComponent.setText(string);
                                editableHistoryCombo.requestFocusInWindow();
                            }
                        });
                    }
                }
            });
        }
        invisibleToolbar.add(Box.createHorizontalStrut(5));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        final TextFilter textFilter = new TextFilter(){

            protected void handleInvalidFilter(String string, RuntimeException runtimeException) {
                ProfilerDialogs.displayError((String)MessageFormat.format(MSG_INVALID_REGEXP, string));
            }
        };
        final TextFilter textFilter2 = new TextFilter();
        final JButton jButton = new JButton(ACTION_FILTER, Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                final 4 var2_2 = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textFilter.copyFrom(textFilter2);
                        if (FilterUtils.filter(profilerTable, (GenericFilter)textFilter, rowFilter)) {
                            editableHistoryCombo.addItem(textFilter.getValue());
                        }
                        this.putClientProperty(FilterUtils.FILTER_CHANGED, null);
                        FilterUtils.updateFilterButton(var2_2, textFilter2, textFilter);
                    }
                });
            }
        };
        String string = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke2);
        jButton.setToolTipText(MessageFormat.format(BTN_FILTER_TOOLTIP, string));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (jButton.isEnabled()) {
                            jButton.doClick();
                            editableHistoryCombo.requestFocusInWindow();
                        }
                    }
                });
            }
        };
        FilterUtils.installAction(jButton, abstractAction, keyStroke2, FILTER_ACTION_KEY);
        invisibleToolbar.add(jButton);
        FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
        invisibleToolbar.add(Box.createHorizontalStrut(2));
        ((JToolBar)invisibleToolbar).addSeparator();
        invisibleToolbar.add(Box.createHorizontalStrut(1));
        final JToggleButton jToggleButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                if (this.isEnabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            textFilter2.setCaseSensitive(this.isSelected());
                            FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
                        }
                    });
                }
            }
        };
        jToggleButton.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
        FilterUtils.installAction(jToggleButton, abstractAction, keyStroke2, FILTER_ACTION_KEY);
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"GeneralIcons.FilterContains")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JMenuItem(FILTER_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        this.filterImpl(10, this.getIcon(), this.getText());
                    }
                });
                jPopupMenu.add(new JMenuItem(FILTER_NOT_CONTAINS, Icons.getIcon((String)"GeneralIcons.FilterNotContains")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        this.filterImpl(20, this.getIcon(), this.getText());
                    }
                });
                jPopupMenu.add(new JMenuItem(FILTER_REGEXP, Icons.getIcon((String)"GeneralIcons.FilterRegExp")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        this.filterImpl(30, this.getIcon(), this.getText());
                    }
                });
            }

            private void filterImpl(final int n, final Icon icon, final String string) {
                if (n == 30) {
                    jToggleButton.setEnabled(false);
                    jToggleButton.setSelected(false);
                } else if (!jToggleButton.isEnabled()) {
                    jToggleButton.setSelected(textFilter2.isCaseSensitive());
                    jToggleButton.setEnabled(true);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setIcon(icon);
                        this.setToolTipText(MessageFormat.format(FILTER_TYPE, string));
                        textFilter2.setType(n);
                        FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
                    }
                });
            }
        };
        popupButton.setToolTipText(MessageFormat.format(FILTER_TYPE, FILTER_CONTAINS));
        FilterUtils.installAction(popupButton, abstractAction, keyStroke2, FILTER_ACTION_KEY);
        invisibleToolbar.add(popupButton);
        invisibleToolbar.add(jToggleButton);
        if (componentArray != null) {
            for (Component object2 : componentArray) {
                invisibleToolbar.add(object2);
            }
        }
        invisibleToolbar.add(Box.createHorizontalStrut(2));
        editableHistoryCombo.setOnTextChangeHandler(new Runnable(){

            @Override
            public void run() {
                textFilter2.setValue(FilterUtils.getFilterString(editableHistoryCombo));
                FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
            }
        });
        final JPanel jPanel2 = new JPanel(new BorderLayout()){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl) {
                    profilerTable.requestFocusInWindow();
                }
            }

            @Override
            public boolean requestFocusInWindow() {
                if (jTextComponent != null) {
                    jTextComponent.selectAll();
                }
                return editableHistoryCombo.requestFocusInWindow();
            }
        };
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
        jPanel2.add((Component)invisibleToolbar, "Center");
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                textFilter.setValue("");
                FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
                FilterUtils.filter(profilerTable, (GenericFilter)textFilter, rowFilter);
                jPanel2.setVisible(false);
            }
        };
        JButton jButton2 = CloseButton.create(runnable);
        String string2 = ActionsSupport.keyAcceleratorString((KeyStroke)keyStroke);
        jButton2.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, string2));
        jPanel2.add((Component)jButton2, "East");
        String string3 = "hide-action";
        InputMap inputMap = jPanel2.getInputMap(1);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        jPanel2.getActionMap().put(string3, abstractAction2);
        inputMap.put(keyStroke, string3);
        if (jTextComponent != null) {
            inputMap = jTextComponent.getInputMap();
            AbstractAction abstractAction3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (editableHistoryCombo.isPopupVisible()) {
                        editableHistoryCombo.hidePopup();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (jButton.isEnabled()) {
                                jButton.doClick();
                            }
                        }
                    });
                }
            };
            jTextComponent.getActionMap().put(FILTER_ACTION_KEY, abstractAction3);
            inputMap.put(keyStroke2, FILTER_ACTION_KEY);
        }
        jPanel2.putClientProperty("SET_FILTER_CHANGED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.putClientProperty(FilterUtils.FILTER_CHANGED, Boolean.TRUE);
                FilterUtils.updateFilterButton(jButton, textFilter2, textFilter);
            }
        });
        return jPanel2;
    }

    private static void installAction(JComponent jComponent, Action action, KeyStroke keyStroke, String string) {
        jComponent.getActionMap().put(string, action);
        jComponent.getInputMap().put(keyStroke, string);
    }

    private static String getFilterString(EditableHistoryCombo editableHistoryCombo) {
        String string = editableHistoryCombo.getText();
        return string == null ? null : string.trim();
    }

    private static void updateFilterButton(JButton jButton, TextFilter textFilter, TextFilter textFilter2) {
        if (Boolean.TRUE.equals(jButton.getClientProperty(FILTER_CHANGED))) {
            jButton.setEnabled(true);
        } else {
            jButton.setEnabled(!textFilter.equals((Object)textFilter2));
        }
    }

    private FilterUtils() {
    }

    private static interface Support {

        public static final class FilterActionProvider
        extends ActionsSupportProvider {
            public KeyStroke registerAction(String string, Action action, ActionMap actionMap, InputMap inputMap) {
                if (!FilterUtils.FILTER_ACTION_KEY.equals(string)) {
                    return null;
                }
                KeyStroke keyStroke = KeyStroke.getKeyStroke(71, 2);
                actionMap.put(string, action);
                inputMap.put(keyStroke, string);
                return keyStroke;
            }
        }
    }

    private static abstract class Filter
    extends RowFilter {
        private Filter() {
        }

        public boolean equals(Object object) {
            return object instanceof Filter;
        }

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    }
}

