/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;

public final class HmacUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static Mac getHmacMd5(byte[] key2) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_MD5, key2);
    }

    public static Mac getHmacSha1(byte[] key2) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_1, key2);
    }

    public static Mac getHmacSha256(byte[] key2) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_256, key2);
    }

    public static Mac getHmacSha384(byte[] key2) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_384, key2);
    }

    public static Mac getHmacSha512(byte[] key2) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_512, key2);
    }

    public static Mac getInitializedMac(HmacAlgorithms algorithm, byte[] key2) {
        return HmacUtils.getInitializedMac(algorithm.toString(), key2);
    }

    public static Mac getInitializedMac(String algorithm, byte[] key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("Null key");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key2, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(keySpec);
            return mac;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (InvalidKeyException e3) {
            throw new IllegalArgumentException(e3);
        }
    }

    public static byte[] hmacMd5(byte[] key2, byte[] valueToDigest) {
        try {
            return HmacUtils.getHmacMd5(key2).doFinal(valueToDigest);
        }
        catch (IllegalStateException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static byte[] hmacMd5(byte[] key2, InputStream valueToDigest) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacMd5(key2), valueToDigest).doFinal();
    }

    public static byte[] hmacMd5(String key2, String valueToDigest) {
        return HmacUtils.hmacMd5(StringUtils.getBytesUtf8(key2), StringUtils.getBytesUtf8(valueToDigest));
    }

    public static String hmacMd5Hex(byte[] key2, byte[] valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacMd5(key2, valueToDigest));
    }

    public static String hmacMd5Hex(byte[] key2, InputStream valueToDigest) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacMd5(key2, valueToDigest));
    }

    public static String hmacMd5Hex(String key2, String valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacMd5(key2, valueToDigest));
    }

    public static byte[] hmacSha1(byte[] key2, byte[] valueToDigest) {
        try {
            return HmacUtils.getHmacSha1(key2).doFinal(valueToDigest);
        }
        catch (IllegalStateException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static byte[] hmacSha1(byte[] key2, InputStream valueToDigest) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha1(key2), valueToDigest).doFinal();
    }

    public static byte[] hmacSha1(String key2, String valueToDigest) {
        return HmacUtils.hmacSha1(StringUtils.getBytesUtf8(key2), StringUtils.getBytesUtf8(valueToDigest));
    }

    public static String hmacSha1Hex(byte[] key2, byte[] valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha1(key2, valueToDigest));
    }

    public static String hmacSha1Hex(byte[] key2, InputStream valueToDigest) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha1(key2, valueToDigest));
    }

    public static String hmacSha1Hex(String key2, String valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha1(key2, valueToDigest));
    }

    public static byte[] hmacSha256(byte[] key2, byte[] valueToDigest) {
        try {
            return HmacUtils.getHmacSha256(key2).doFinal(valueToDigest);
        }
        catch (IllegalStateException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static byte[] hmacSha256(byte[] key2, InputStream valueToDigest) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha256(key2), valueToDigest).doFinal();
    }

    public static byte[] hmacSha256(String key2, String valueToDigest) {
        return HmacUtils.hmacSha256(StringUtils.getBytesUtf8(key2), StringUtils.getBytesUtf8(valueToDigest));
    }

    public static String hmacSha256Hex(byte[] key2, byte[] valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha256(key2, valueToDigest));
    }

    public static String hmacSha256Hex(byte[] key2, InputStream valueToDigest) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha256(key2, valueToDigest));
    }

    public static String hmacSha256Hex(String key2, String valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha256(key2, valueToDigest));
    }

    public static byte[] hmacSha384(byte[] key2, byte[] valueToDigest) {
        try {
            return HmacUtils.getHmacSha384(key2).doFinal(valueToDigest);
        }
        catch (IllegalStateException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static byte[] hmacSha384(byte[] key2, InputStream valueToDigest) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha384(key2), valueToDigest).doFinal();
    }

    public static byte[] hmacSha384(String key2, String valueToDigest) {
        return HmacUtils.hmacSha384(StringUtils.getBytesUtf8(key2), StringUtils.getBytesUtf8(valueToDigest));
    }

    public static String hmacSha384Hex(byte[] key2, byte[] valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha384(key2, valueToDigest));
    }

    public static String hmacSha384Hex(byte[] key2, InputStream valueToDigest) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha384(key2, valueToDigest));
    }

    public static String hmacSha384Hex(String key2, String valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha384(key2, valueToDigest));
    }

    public static byte[] hmacSha512(byte[] key2, byte[] valueToDigest) {
        try {
            return HmacUtils.getHmacSha512(key2).doFinal(valueToDigest);
        }
        catch (IllegalStateException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static byte[] hmacSha512(byte[] key2, InputStream valueToDigest) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha512(key2), valueToDigest).doFinal();
    }

    public static byte[] hmacSha512(String key2, String valueToDigest) {
        return HmacUtils.hmacSha512(StringUtils.getBytesUtf8(key2), StringUtils.getBytesUtf8(valueToDigest));
    }

    public static String hmacSha512Hex(byte[] key2, byte[] valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha512(key2, valueToDigest));
    }

    public static String hmacSha512Hex(byte[] key2, InputStream valueToDigest) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha512(key2, valueToDigest));
    }

    public static String hmacSha512Hex(String key2, String valueToDigest) {
        return Hex.encodeHexString(HmacUtils.hmacSha512(key2, valueToDigest));
    }

    public static Mac updateHmac(Mac mac, byte[] valueToDigest) {
        mac.reset();
        mac.update(valueToDigest);
        return mac;
    }

    public static Mac updateHmac(Mac mac, InputStream valueToDigest) throws IOException {
        mac.reset();
        byte[] buffer = new byte[1024];
        int read2 = valueToDigest.read(buffer, 0, 1024);
        while (read2 > -1) {
            mac.update(buffer, 0, read2);
            read2 = valueToDigest.read(buffer, 0, 1024);
        }
        return mac;
    }

    public static Mac updateHmac(Mac mac, String valueToDigest) {
        mac.reset();
        mac.update(StringUtils.getBytesUtf8(valueToDigest));
        return mac;
    }
}

