/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppExecutable
extends DefaultCppBinary
implements CppExecutable,
ConfigurableComponentWithExecutable,
ConfigurableComponentWithRuntimeUsage,
SoftwareComponentInternal {
    private final RegularFileProperty executableFile;
    private final Property<Task> executableFileProducer;
    private final DirectoryProperty installationDirectory;
    private final Property<InstallExecutable> installTaskProperty;
    private final Property<LinkExecutable> linkTaskProperty;
    private final Property<Configuration> runtimeElementsProperty;
    private final ConfigurableFileCollection outputs;
    private final RegularFileProperty debuggerExecutableFile;

    @Inject
    public DefaultCppExecutable(Names names, ObjectFactory objectFactory, FileOperations fileOperations, Provider<String> baseName, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, objectFactory, baseName, sourceFiles, componentHeaderDirs, configurations, implementation, targetPlatform, toolChain, platformToolProvider, identity);
        this.executableFile = objectFactory.fileProperty();
        this.executableFileProducer = objectFactory.property(Task.class);
        this.debuggerExecutableFile = objectFactory.fileProperty();
        this.installationDirectory = objectFactory.directoryProperty();
        this.linkTaskProperty = objectFactory.property(LinkExecutable.class);
        this.installTaskProperty = objectFactory.property(InstallExecutable.class);
        this.runtimeElementsProperty = objectFactory.property(Configuration.class);
        this.outputs = fileOperations.configurableFiles();
    }

    @Override
    public ConfigurableFileCollection getOutputs() {
        return this.outputs;
    }

    public RegularFileProperty getExecutableFile() {
        return this.executableFile;
    }

    @Override
    public Property<Task> getExecutableFileProducer() {
        return this.executableFileProducer;
    }

    public DirectoryProperty getInstallDirectory() {
        return this.installationDirectory;
    }

    @Override
    public Property<InstallExecutable> getInstallTask() {
        return this.installTaskProperty;
    }

    @Override
    public Property<LinkExecutable> getLinkTask() {
        return this.linkTaskProperty;
    }

    public RegularFileProperty getDebuggerExecutableFile() {
        return this.debuggerExecutableFile;
    }

    @Override
    public Property<Configuration> getRuntimeElements() {
        return this.runtimeElementsProperty;
    }

    @Override
    public Provider<RegularFile> getRuntimeFile() {
        return this.executableFile;
    }

    @Override
    @Nullable
    public Linkage getLinkage() {
        return null;
    }

    @Override
    public boolean hasRuntimeFile() {
        return true;
    }

    public Set<? extends UsageContext> getUsages() {
        Configuration runtimeElements = (Configuration)this.runtimeElementsProperty.get();
        return Collections.singleton(new DefaultUsageContext(this.getIdentity().getRuntimeUsageContext(), (Set<? extends PublishArtifact>)runtimeElements.getAllArtifacts(), runtimeElements));
    }

    @Override
    public AttributeContainer getRuntimeAttributes() {
        return this.getIdentity().getRuntimeUsageContext().getAttributes();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return this.getIdentity().getCoordinates();
    }
}

