'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var configuration_1 = require("../configuration");
var serviceManager_1 = require("../serviceManager");
var debug_1 = require("debug");
var semver = require("semver");
var NotifyOptions = (function () {
    function NotifyOptions() {
    }
    return NotifyOptions;
}());
exports.NotifyOptions = NotifyOptions;
var ErrorContext = (function () {
    function ErrorContext() {
    }
    return ErrorContext;
}());
exports.ErrorContext = ErrorContext;
var optionsDefault = {
    catchExceptions: true
};
var NotifyFeature = (function () {
    function NotifyFeature() {
        this.logger = debug_1.default('axm:features:notify');
    }
    NotifyFeature.prototype.init = function (options) {
        if (options === undefined) {
            options = optionsDefault;
        }
        this.logger('init');
        this.transport = serviceManager_1.ServiceManager.get('transport');
        if (this.transport === undefined) {
            return this.logger("Failed to load transporter service");
        }
        configuration_1.default.configureModule({
            error: true
        });
        if (options.catchExceptions === false)
            return;
        this.logger('Registering hook to catch unhandled exception/rejection');
        this.catchAll();
    };
    NotifyFeature.prototype.destroy = function () {
        process.removeListener('uncaughtException', this.onUncaughtException);
        process.removeListener('unhandledRejection', this.onUnhandledRejection);
        this.logger('destroy');
    };
    NotifyFeature.prototype.notifyError = function (err, context) {
        if (typeof context !== 'object') {
            context = {};
        }
        if (!(err instanceof Error)) {
            console.error('You must use notifyError with an Error object, ignoring');
            console.trace();
            return -1;
        }
        if (this.transport === undefined) {
            return this.logger("Tried to send error without having transporter available");
        }
        var payload = {
            message: err.message,
            stack: err.stack,
            name: err.name,
            metadata: context
        };
        return this.transport.send('process:exception', payload);
    };
    NotifyFeature.prototype.onUncaughtException = function (error) {
        if (semver.satisfies(process.version, '< 6')) {
            console.error(error.stack);
        }
        else {
            console.error(error);
        }
        var payload = {
            message: error.message,
            stack: error.stack,
            name: error.name
        };
        if (serviceManager_1.ServiceManager.get('transport')) {
            serviceManager_1.ServiceManager.get('transport').send('process:exception', payload);
        }
        process.exit(1);
    };
    NotifyFeature.prototype.onUnhandledRejection = function (error) {
        if (error === undefined)
            return;
        console.error(error);
        var payload = {
            message: error.message,
            stack: error.stack,
            name: error.name
        };
        if (serviceManager_1.ServiceManager.get('transport')) {
            serviceManager_1.ServiceManager.get('transport').send('process:exception', payload);
        }
    };
    NotifyFeature.prototype.catchAll = function () {
        if (process.env.exec_mode === 'cluster_mode') {
            return false;
        }
        process.on('uncaughtException', this.onUncaughtException);
        process.on('unhandledRejection', this.onUnhandledRejection);
    };
    NotifyFeature.prototype.expressErrorHandler = function () {
        configuration_1.default.configureModule({
            error: true
        });
        return function errorHandler(err, req, res, next) {
            var payload = {
                message: err.message,
                stack: err.stack,
                name: err.name,
                metadata: {
                    http: {
                        url: req.url,
                        params: req.params,
                        method: req.method,
                        query: req.query,
                        body: req.body,
                        path: req.path,
                        route: req.route && req.route.path ? req.route.path : undefined
                    },
                    custom: {
                        user: typeof req.user === 'object' ? req.user.id : undefined
                    }
                }
            };
            if (serviceManager_1.ServiceManager.get('transport')) {
                serviceManager_1.ServiceManager.get('transport').send('process:exception', payload);
            }
            return next(err);
        };
    };
    NotifyFeature.prototype.koaErrorHandler = function () {
        configuration_1.default.configureModule({
            error: true
        });
        return function (ctx, next) {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var err_1, payload;
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            _a.trys.push([0, 2, , 3]);
                            return [4, next()];
                        case 1:
                            _a.sent();
                            return [3, 3];
                        case 2:
                            err_1 = _a.sent();
                            payload = {
                                message: err_1.message,
                                stack: err_1.stack,
                                name: err_1.name,
                                metadata: {
                                    http: {
                                        url: ctx.request.url,
                                        params: ctx.params,
                                        method: ctx.request.method,
                                        query: ctx.request.query,
                                        body: ctx.request.body,
                                        path: ctx.request.path,
                                        route: ctx._matchedRoute
                                    },
                                    custom: {
                                        user: typeof ctx.user === 'object' ? ctx.user.id : undefined
                                    }
                                }
                            };
                            if (serviceManager_1.ServiceManager.get('transport')) {
                                serviceManager_1.ServiceManager.get('transport').send('process:exception', payload);
                            }
                            return [3, 3];
                        case 3: return [2];
                    }
                });
            });
        };
    };
    return NotifyFeature;
}());
exports.NotifyFeature = NotifyFeature;
//# sourceMappingURL=data:application/json;base64,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