"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var serviceManager_1 = require("../serviceManager");
var Debug = require("debug");
var configuration_1 = require("../configuration");
var PluginConfig = (function () {
    function PluginConfig() {
    }
    return PluginConfig;
}());
exports.PluginConfig = PluginConfig;
var TracerIgnoreFilter = (function () {
    function TracerIgnoreFilter() {
    }
    return TracerIgnoreFilter;
}());
exports.TracerIgnoreFilter = TracerIgnoreFilter;
var TracingConfig = (function () {
    function TracingConfig() {
    }
    return TracingConfig;
}());
exports.TracingConfig = TracingConfig;
var enabledConfig = {
    enabled: true,
    ignoreFilter: {
        url: [],
        method: ['OPTIONS']
    },
    logLevel: 1
};
var TracingFeature = (function () {
    function TracingFeature() {
        this.logger = Debug('axm:features:tracing');
    }
    TracingFeature.prototype.init = function (config) {
        var _this = this;
        if (config === undefined)
            return;
        if (config === false)
            return;
        if (config === true) {
            config = enabledConfig;
        }
        if (config.enabled === false)
            return;
        this.logger('init');
        this.transport = serviceManager_1.ServiceManager.get('transport');
        if (this.transport === undefined) {
            return this.logger("Failed to load transporter service");
        }
        var tracerModule = require('@pm2/legacy-tracing');
        if (tracerModule.get().isActive()) {
            return this.logger("Tracing already enalbed");
        }
        this.tracer = tracerModule.start(config);
        this.logger("Tracing start and correctly enabled");
        configuration_1.default.configureModule({
            tracing_enabled: true
        });
        this.traceHandler = function (data) {
            if (_this.transport === undefined)
                return;
            _this.logger('received trace data');
            _this.transport.send('axm:trace', data);
        };
        this.tracer.getBus().on('transaction', this.traceHandler);
    };
    TracingFeature.prototype.destroy = function () {
        if (this.tracer === undefined)
            return;
        this.tracer.getBus().removeAllListeners();
        if (typeof this.tracer.disable_ === 'function') {
            this.tracer.disable_();
            this.logger('stopped tracing agent');
        }
        this.logger('destroy');
    };
    return TracingFeature;
}());
exports.TracingFeature = TracingFeature;
//# sourceMappingURL=data:application/json;base64,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