"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var module_1 = require("../utils/module");
var configuration_1 = require("../configuration");
var serviceManager_1 = require("../serviceManager");
var miscellaneous_1 = require("../utils/miscellaneous");
var Debug = require("debug");
var CurrentProfile = (function () {
    function CurrentProfile() {
    }
    return CurrentProfile;
}());
var AddonProfiler = (function () {
    function AddonProfiler() {
        this.profiler = null;
        this.modules = ['v8-profiler-node8', 'v8-profiler'];
        this.currentProfile = null;
        this.logger = Debug('axm:features:profiling:addon');
    }
    AddonProfiler.prototype.init = function () {
        var e_1, _a;
        try {
            for (var _b = tslib_1.__values(this.modules), _c = _b.next(); !_c.done; _c = _b.next()) {
                var moduleName = _c.value;
                var path = module_1.default.detectModule(moduleName);
                if (path === null)
                    continue;
                var profiler = module_1.default.loadModule(moduleName);
                if (profiler instanceof Error)
                    continue;
                this.profiler = profiler;
                break;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (this.profiler === null) {
            configuration_1.default.configureModule({
                heapdump: false,
                'feature.profiler.heap_snapshot': false,
                'feature.profiler.heap_sampling': false,
                'feature.profiler.cpu_js': false
            });
            return this.logger("Failed to require the profiler via addon, disabling profiling ...");
        }
        this.logger('init');
        this.actionService = serviceManager_1.ServiceManager.get('actions');
        if (this.actionService === undefined) {
            return this.logger("Fail to get action service");
        }
        this.transport = serviceManager_1.ServiceManager.get('transport');
        if (this.transport === undefined) {
            return this.logger("Fail to get transport service");
        }
        configuration_1.default.configureModule({
            heapdump: true,
            'feature.profiler.heapsnapshot': true,
            'feature.profiler.heapsampling': false,
            'feature.profiler.cpu_js': true
        });
        this.register();
    };
    AddonProfiler.prototype.register = function () {
        if (this.actionService === undefined) {
            return this.logger("Fail to get action service");
        }
        this.logger('register');
        this.actionService.registerAction('km:heapdump', this.onHeapdump.bind(this));
        this.actionService.registerAction('km:cpu:profiling:start', this.onCPUProfileStart.bind(this));
        this.actionService.registerAction('km:cpu:profiling:stop', this.onCPUProfileStop.bind(this));
    };
    AddonProfiler.prototype.destroy = function () {
        this.logger('Addon Profiler destroyed !');
        if (this.profiler === null)
            return;
        this.profiler.deleteAllProfiles();
    };
    AddonProfiler.prototype.onCPUProfileStart = function (opts, cb) {
        var _this = this;
        if (typeof cb !== 'function') {
            cb = opts;
            opts = {};
        }
        if (typeof opts !== 'object' || opts === null) {
            opts = {};
        }
        if (this.currentProfile !== null) {
            return cb({
                err: 'A profiling is already running',
                success: false
            });
        }
        this.currentProfile = new CurrentProfile();
        this.currentProfile.uuid = miscellaneous_1.default.generateUUID();
        this.currentProfile.startTime = Date.now();
        this.currentProfile.initiated = typeof opts.initiated === 'string'
            ? opts.initiated : 'manual';
        cb({ success: true, uuid: this.currentProfile.uuid });
        this.profiler.startProfiling();
        if (isNaN(parseInt(opts.timeout, 10)))
            return;
        var duration = parseInt(opts.timeout, 10);
        setTimeout(function (_) {
            _this.onCPUProfileStop(function (_) {
                return;
            });
        }, duration);
    };
    AddonProfiler.prototype.onCPUProfileStop = function (cb) {
        if (this.currentProfile === null) {
            return cb({
                err: 'No profiling are already running',
                success: false
            });
        }
        if (this.transport === undefined) {
            return cb({
                err: 'No profiling are already running',
                success: false
            });
        }
        var profile = this.profiler.stopProfiling();
        var data = JSON.stringify(profile);
        cb({ success: true, uuid: this.currentProfile.uuid });
        this.transport.send('profilings', {
            uuid: this.currentProfile.uuid,
            duration: Date.now() - this.currentProfile.startTime,
            at: this.currentProfile.startTime,
            data: data,
            dump_file_size: data.length,
            success: true,
            initiated: this.currentProfile.initiated,
            type: 'cpuprofile',
            cpuprofile: true
        });
        this.currentProfile = null;
    };
    AddonProfiler.prototype.onHeapdump = function (opts, cb) {
        var _this = this;
        if (typeof cb !== 'function') {
            cb = opts;
            opts = {};
        }
        if (typeof opts !== 'object' || opts === null) {
            opts = {};
        }
        cb({ success: true });
        setTimeout(function () {
            var startTime = Date.now();
            _this.takeSnapshot()
                .then(function (data) {
                return _this.transport.send('profilings', {
                    data: data,
                    at: startTime,
                    initiated: typeof opts.initiated === 'string' ? opts.initiated : 'manual',
                    duration: Date.now() - startTime,
                    type: 'heapdump'
                });
            }).catch(function (err) {
                return cb({
                    success: err.message,
                    err: err
                });
            });
        }, 200);
    };
    AddonProfiler.prototype.takeSnapshot = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var snapshot = _this.profiler.takeSnapshot();
            snapshot.export(function (err, data) {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(data);
                }
                snapshot.delete();
            });
        });
    };
    return AddonProfiler;
}());
exports.default = AddonProfiler;
//# sourceMappingURL=data:application/json;base64,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