'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var debug_1 = require("debug");
var module_1 = require("../utils/module");
var eventemitter2_1 = require("eventemitter2");
var RuntimeStatsService = (function (_super) {
    tslib_1.__extends(RuntimeStatsService, _super);
    function RuntimeStatsService() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.logger = debug_1.default('axm:services:runtimeStats');
        _this.enabled = false;
        return _this;
    }
    RuntimeStatsService.prototype.init = function () {
        var _this = this;
        this.logger('init');
        if (process.env.PM2_APM_DISABLE_RUNTIME_STATS === 'true') {
            return this.logger('disabling service because of the environment flag');
        }
        var modulePath = module_1.default.detectModule('@pm2/node-runtime-stats');
        if (typeof modulePath !== 'string')
            return;
        var RuntimeStats = module_1.default.loadModule(modulePath);
        if (RuntimeStats instanceof Error) {
            return this.logger("Failed to require module @pm2/node-runtime-stats: " + RuntimeStats.message);
        }
        this.noduleInstance = new RuntimeStats({
            delay: 1000
        });
        this.logger('starting runtime stats');
        this.noduleInstance.start();
        this.handle = function (data) {
            _this.logger('received runtime stats', data);
            _this.emit('data', data);
        };
        this.noduleInstance.on('sense', this.handle);
        this.enabled = true;
    };
    RuntimeStatsService.prototype.isEnabled = function () {
        return this.enabled;
    };
    RuntimeStatsService.prototype.destroy = function () {
        if (this.noduleInstance !== undefined && this.noduleInstance !== null) {
            this.logger('removing listener on runtime stats service');
            this.noduleInstance.removeListener('sense', this.handle);
            this.noduleInstance.stop();
        }
        this.logger('destroy');
    };
    return RuntimeStatsService;
}(eventemitter2_1.EventEmitter2));
exports.RuntimeStatsService = RuntimeStatsService;
//# sourceMappingURL=data:application/json;base64,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