/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeCallers$Caller;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeEviction$EvictionData;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public final class IvyNode
implements Comparable {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map dds = new HashMap();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection confsToFetch = new HashSet();
    private Collection fetchedConfigurations = new HashSet();
    private Collection loadedRootModuleConfs = new HashSet();
    private IvyNodeUsage usage = new IvyNodeUsage(this);
    private Map mergedUsages = new LinkedHashMap();

    private IvyNode(ResolveData resolveData, IvyNode ivyNode, DependencyDescriptor dependencyDescriptor) {
        this.id = dependencyDescriptor.getDependencyRevisionId();
        this.dds.put(ivyNode, dependencyDescriptor);
        this.root = ivyNode.root;
        this.init(resolveData);
    }

    public IvyNode(ResolveData resolveData, ModuleDescriptor moduleDescriptor) {
        this.id = moduleDescriptor.getModuleRevisionId();
        this.md = moduleDescriptor;
        this.root = this;
        this.init(resolveData);
    }

    private void init(ResolveData resolveData) {
        this.data = resolveData;
        this.settings = resolveData.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public final boolean loadData(String string, IvyNode ivyNode, String string2, String string3, boolean bl, IvyNodeUsage ivyNodeUsage) {
        Object object;
        Message.debug("loadData of " + this.toString() + " of rootConf=" + string);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean bl2 = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(string)) {
            Message.debug(string + " is evicted.  Skip loading");
        } else {
            String string4;
            IvyNode ivyNode2 = null;
            if (!(!this.confsToFetch.isEmpty()) && this.loadedRootModuleConfs.contains(string4 = string)) {
                Message.debug(string + " is loaded and no conf to load.  Skip loading");
            } else {
                string4 = string;
                this.loadedRootModuleConfs.add(string4);
                if (this.md == null) {
                    object = this.data.getSettings().getResolver(this.id);
                    if (object == null) {
                        Message.error("no resolver found for " + this.id.getModuleId() + ": check your configuration");
                        this.problem = new RuntimeException("no resolver found for " + this.id.getModuleId() + ": check your configuration");
                        return false;
                    }
                    try {
                        Message.debug("\tusing " + object + " to resolve " + this.id);
                        DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(ivyNode);
                        long l = System.currentTimeMillis();
                        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
                        this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent((DependencyResolver)object, dependencyDescriptor, moduleRevisionId));
                        this.module = object.getDependency(dependencyDescriptor, this.data);
                        this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent((DependencyResolver)object, dependencyDescriptor, moduleRevisionId, this.module, System.currentTimeMillis() - l));
                        if (this.module != null) {
                            this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                            if (this.settings.logModuleWhenFound() && "default".equals(this.data.getOptions().getLog())) {
                                Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                            } else {
                                Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                            }
                            if (this.settings.getVersionMatcher().isDynamic(this.id) && this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                                Message.error("impossible to resolve dynamic revision for " + this.id + ": check your configuration and make sure revision is part of your pattern");
                                this.problem = new RuntimeException("impossible to resolve dynamic revision");
                                return false;
                            }
                            if (!this.id.equals(this.module.getId())) {
                                IvyNode ivyNode3 = this.data.getNode(this.module.getId());
                                if (ivyNode3 != null) {
                                    this.md = this.module.getDescriptor();
                                    if (!this.handleConfiguration(false, string, ivyNode, string2, string3, bl, ivyNodeUsage)) {
                                        return false;
                                    }
                                    IvyNode ivyNode4 = ivyNode3;
                                    String string5 = string3;
                                    String string6 = string2;
                                    IvyNode ivyNode5 = ivyNode;
                                    string4 = string;
                                    ivyNode2 = this;
                                    if (ivyNode4.md == null) {
                                        ivyNode4.md = ivyNode2.md;
                                    }
                                    if (ivyNode4.module == null) {
                                        ivyNode4.module = ivyNode2.module;
                                    }
                                    ivyNode4.downloaded |= ivyNode2.module.getReport().isDownloaded();
                                    ivyNode4.searched |= ivyNode2.module.getReport().isSearched();
                                    ivyNode4.dds.putAll(ivyNode2.dds);
                                    ivyNode4.updateDataFrom(ivyNode2, string4, true);
                                    ivyNode4.loadData(string4, ivyNode5, string6, string5, bl, ivyNode2.usage);
                                    ivyNode4.usage.updateDataFrom(ivyNode2.getAllUsages(), string4);
                                    ivyNode2.usage = ivyNode4.usage;
                                    ivyNode2.data.replaceNode(ivyNode2.id, ivyNode4, string4);
                                    if (ivyNode2.settings.logResolvedRevision() && "default".equals(ivyNode2.data.getOptions().getLog())) {
                                        Message.info("\t[" + ivyNode2.module.getId().getRevision() + "] " + ivyNode2.id);
                                    } else {
                                        Message.verbose("\t[" + ivyNode2.module.getId().getRevision() + "] " + ivyNode2.id);
                                    }
                                    return true;
                                }
                                String string7 = "\t[" + this.module.getId().getRevision() + "] " + this.id;
                                if (!this.settings.getVersionMatcher().isDynamic(this.id)) {
                                    string7 = string7 + " (forced)";
                                }
                                if (this.settings.logResolvedRevision() && "default".equals(this.data.getOptions().getLog())) {
                                    Message.info(string7);
                                } else {
                                    Message.verbose(string7);
                                }
                            }
                        } else {
                            Message.warn("\tmodule not found: " + this.id);
                            object.reportFailure();
                            this.problem = new RuntimeException("not found");
                            return false;
                        }
                        this.downloaded = this.module.getReport().isDownloaded();
                        this.searched = this.module.getReport().isSearched();
                        bl2 = true;
                        this.md = this.module.getDescriptor();
                        this.confsToFetch.remove("*");
                        this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(ivyNode, string2))));
                    }
                    catch (ResolveProcessException resolveProcessException) {
                        throw resolveProcessException;
                    }
                    catch (Exception exception) {
                        this.problem = exception;
                        return false;
                    }
                } else {
                    bl2 = true;
                }
            }
        }
        this.handleConfiguration(bl2, string, ivyNode, string2, string3, bl, ivyNodeUsage);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        object = this.getDependencyDescriptor(ivyNode);
        if (object != null) {
            ivyNodeUsage.addUsage(string, (DependencyDescriptor)object, string2);
        }
        return bl2;
    }

    public final Collection getDependencies(String string, String[] stringArray, String string2) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(stringArray).contains("*")) {
            stringArray = this.isRoot() ? this.md.getConfigurationsNames() : this.md.getPublicConfigurationsNames();
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(this.getDependencies(string, stringArray[i], string2));
        }
        return hashSet;
    }

    public final Collection getDependencies(String string, String string2, String string3) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dependencyDescriptorArray = this.md.getDependencies();
        LinkedHashMap<ModuleRevisionId, IvyNode> linkedHashMap = new LinkedHashMap<ModuleRevisionId, IvyNode>();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            Object object;
            ModuleRevisionId moduleRevisionId;
            DependencyDescriptor dependencyDescriptor = this.data.mediate(dependencyDescriptorArray[i]);
            String[] stringArray = dependencyDescriptor.getDependencyConfigurations(string2, string3);
            if (stringArray.length == 0) continue;
            ModuleRevisionId moduleRevisionId2 = moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
            Object object2 = string;
            Object object3 = dependencyDescriptor;
            IvyNode ivyNode = this;
            String[] stringArray2 = DefaultArtifact.newIvyArtifact(moduleRevisionId2, null);
            boolean bl = ivyNode.isRoot() ? ((object = ivyNode.doesExclude(ivyNode.md, (String)object2, new String[]{object2}, (DependencyDescriptor)object3, (Artifact)stringArray2, new Stack())) == null ? false : (Boolean)object) : ivyNode.callers.doesCallersExclude((String)object2, (Artifact)stringArray2);
            if (bl) {
                Message.verbose("excluding " + dependencyDescriptor + " in " + string2);
                continue;
            }
            IvyNode ivyNode2 = (IvyNode)linkedHashMap.get(moduleRevisionId);
            if (ivyNode2 == null) {
                ivyNode2 = this.data.getNode(moduleRevisionId);
            }
            if (ivyNode2 == null) {
                ivyNode2 = new IvyNode(this.data, this, dependencyDescriptor);
            } else {
                object2 = dependencyDescriptor;
                object3 = this;
                ivyNode2.dds.put(object3, object2);
                ivyNode2.hasProblem();
            }
            String[] stringArray3 = ivyNode2.resolveSpecialConfigurations(stringArray);
            List<String> list = Arrays.asList(stringArray3);
            ivyNode2.updateConfsToFetch(list);
            ivyNode2.addRootModuleConfigurations(ivyNode2.usage, string, stringArray3);
            ivyNode2.usage.setRequiredConfs(this, string2, list);
            object = dependencyDescriptor;
            stringArray2 = stringArray;
            String string4 = string3;
            object2 = this;
            object3 = string;
            ivyNode = ivyNode2;
            ivyNode.callers.addCaller$687b35de((String)object3, (IvyNode)object2, string4, stringArray2, (DependencyDescriptor)object);
            if (ivyNode.callers.getAllCallersModuleIds().contains(ivyNode.id.getModuleId())) {
                ModuleId moduleId = ivyNode.id.getModuleId();
                IvyNode ivyNode3 = ivyNode;
                IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(IvyNode.toMrids(ivyNode3.findPath(moduleId, ivyNode3, new LinkedList()), ivyNode));
            }
            linkedHashMap.put(moduleRevisionId, ivyNode2);
        }
        return linkedHashMap.values();
    }

    public final DependencyDescriptor getDependencyDescriptor(IvyNode ivyNode) {
        return (DependencyDescriptor)this.dds.get(ivyNode);
    }

    final Boolean doesExclude(ModuleDescriptor moduleDescriptor, String string, String[] stringArray, DependencyDescriptor dependencyDescriptor, Artifact artifact, Stack stack) {
        if (dependencyDescriptor != null && dependencyDescriptor.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        if (moduleDescriptor.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        IvyNode ivyNode = this.data.getNode(moduleDescriptor.getModuleRevisionId());
        if (ivyNode != null) {
            if (stack.contains(ivyNode.id)) {
                return null;
            }
            Stack stack2 = stack;
            Artifact artifact2 = artifact;
            String string2 = string;
            return ivyNode.callers.doesCallersExclude(string2, artifact2, stack2);
        }
        return Boolean.FALSE;
    }

    private boolean handleConfiguration(boolean bl, String string, IvyNode ivyNode, String string2, String string3, boolean bl2, IvyNodeUsage ivyNodeUsage) {
        if (this.md != null) {
            String[] stringArray = this.getRealConfs(string3);
            this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                Configuration configuration = this.md.getConfiguration(stringArray[i]);
                if (configuration == null) {
                    this.confsToFetch.remove(string3);
                    if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                        Message.verbose("configuration required by evicted revision is not available in selected revision. skipping " + string3 + " in " + this);
                    } else {
                        this.problem = !string3.equals(stringArray[i]) ? new RuntimeException("configuration not found in " + this + ": '" + string3 + "'. Missing configuration: '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2) : new RuntimeException("configuration not found in " + this + ": '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2);
                    }
                    return false;
                }
                if (!bl2 || this.isRoot() || configuration.getVisibility() == Configuration$Visibility.PUBLIC) continue;
                this.confsToFetch.remove(string3);
                if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                    Message.verbose("configuration required by evicted revision is not visible in selected revision. skipping " + string3 + " in " + this);
                } else {
                    this.problem = new RuntimeException("configuration not public in " + this + ": '" + configuration + "'. It was required from " + ivyNode + " " + string2);
                }
                return false;
            }
            if (bl) {
                this.fetchedConfigurations.add(string3);
                this.confsToFetch.removeAll(Arrays.asList(stringArray));
                this.confsToFetch.remove(string3);
            }
        }
        return true;
    }

    private static String getDefaultConf(String string) {
        Matcher matcher = FALLBACK_CONF_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }

    private static String getMainConf(String string) {
        Matcher matcher = FALLBACK_CONF_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public final void updateConfsToFetch(Collection collection) {
        this.confsToFetch.addAll(collection);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].startsWith("*") && this.isLoaded()) {
            String string = stringArray[0];
            if ("*".equals(string)) {
                return this.md.getPublicConfigurationsNames();
            }
            List<String> list = Arrays.asList(string.substring(2).split("\\!"));
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.md.getPublicConfigurationsNames()));
            arrayList.removeAll(list);
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    public final String[] getRequiredConfigurations(IvyNode ivyNode, String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        IvyNode.addAllIfNotNull(linkedHashSet, this.usage.getRequiredConfigurations(ivyNode, string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            IvyNode.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRequiredConfigurations(ivyNode, string));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static void addAllIfNotNull(Collection collection, Collection collection2) {
        if (collection2 != null) {
            collection.addAll(collection2);
        }
    }

    public final Configuration getConfiguration(String string) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String string2 = IvyNode.getDefaultConf(string);
        Configuration configuration = this.md.getConfiguration(string = IvyNode.getMainConf(string));
        if (configuration == null) {
            configuration = this.md.getConfiguration(string2);
        }
        return configuration;
    }

    public final String[] getConfigurations(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        IvyNode.addAllIfNotNull(linkedHashSet, this.usage.getConfigurations(string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            IvyNode.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getConfigurations(string));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    protected final boolean isConfRequiredByMergedUsageOnly(String string, String string2) {
        Set set = this.usage.getConfigurations(string);
        return set == null || !set.contains(string2);
    }

    private void addRootModuleConfigurations(IvyNodeUsage ivyNodeUsage, String string, String[] stringArray) {
        Set set = ivyNodeUsage.addAndGetConfigurations(string);
        if (this.md != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
                Configuration configuration = this.md.getConfiguration(stringArray[i]);
                if (configuration == null) continue;
                String[] stringArray2 = configuration.getExtends();
                this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray2);
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            set.add(stringArray[i]);
        }
    }

    public final String[] getRootModuleConfigurations() {
        Set set = this.getRootModuleConfigurationsSet();
        return set.toArray(new String[set.size()]);
    }

    private Set getRootModuleConfigurationsSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        IvyNode.addAllIfNotNull(linkedHashSet, this.usage.getRootModuleConfigurations());
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            IvyNode.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRootModuleConfigurations());
        }
        return linkedHashSet;
    }

    public final String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public final String[] getRealConfs(String string) {
        if (this.md == null) {
            return new String[]{string};
        }
        String string2 = IvyNode.getDefaultConf(string);
        if (this.md.getConfiguration(string = IvyNode.getMainConf(string)) == null || Configuration$Visibility.PRIVATE.equals(this.md.getConfiguration(string).getVisibility())) {
            if ("".equals(string2)) {
                return new String[0];
            }
            string = string2;
        }
        if (string.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{string});
        }
        if (string.indexOf(44) != -1) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return new String[]{string};
    }

    private Collection findPath(ModuleId moduleId, IvyNode ivyNode, List list) {
        while (true) {
            ModuleId moduleId2;
            IvyNode ivyNode2;
            if ((ivyNode2 = ivyNode.callers.getDirectCallerFor(moduleId2 = moduleId)) == null) {
                throw new IllegalArgumentException("no path from " + moduleId + " to " + this.id + " found");
            }
            if (list.contains(ivyNode2)) {
                list.add(0, ivyNode2);
                Message.verbose("circular dependency found while looking for the path for another one: was looking for " + moduleId + " as a caller of " + list.get(list.size() - 1));
                return list;
            }
            list.add(0, ivyNode2);
            if (ivyNode2.id.getModuleId().equals(moduleId)) {
                return list;
            }
            ivyNode = ivyNode2;
        }
    }

    private void updateDataFrom(IvyNode ivyNode, String string, boolean bl) {
        this.callers.updateFrom(ivyNode.callers, string, bl);
        if (bl) {
            this.usage.updateDataFrom(ivyNode.getAllUsages(), string);
        } else {
            IvyNodeUsage ivyNodeUsage = (IvyNodeUsage)this.mergedUsages.get(ivyNode.id);
            if (ivyNodeUsage == null) {
                ivyNodeUsage = new IvyNodeUsage(ivyNode);
                this.mergedUsages.put(ivyNode.id, ivyNodeUsage);
            }
            ivyNodeUsage.updateDataFrom(ivyNode.getAllUsages(), string);
        }
        this.updateConfsToFetch(ivyNode.fetchedConfigurations);
        this.updateConfsToFetch(ivyNode.confsToFetch);
    }

    private Collection getAllUsages() {
        ArrayList<IvyNodeUsage> arrayList = new ArrayList<IvyNodeUsage>();
        arrayList.add(this.usage);
        arrayList.addAll(this.mergedUsages.values());
        return arrayList;
    }

    public final Artifact[] getSelectedArtifacts(Filter filter2) {
        Collection<Artifact> collection = new HashSet();
        for (String string : this.getRootModuleConfigurationsSet()) {
            if (this.isEvicted(string) || this.isBlacklisted(string)) continue;
            collection.addAll(Arrays.asList(this.getArtifacts(string)));
        }
        collection = FilterHelper.filter(collection, filter2);
        return collection.toArray(new Artifact[collection.size()]);
    }

    public final Artifact[] getArtifacts(String string) {
        Object object;
        String[] stringArray = this.getConfigurations(string);
        if (stringArray == null || stringArray.length == 0) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artifacts when data has not been loaded. IvyNode = " + this.toString());
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        Set set = this.usage.getDependencyArtifactsSet(string);
        if (this.md.isDefault() && set != null && !set.isEmpty()) {
            this.addArtifactsFromOwnUsage(hashSet, set);
            this.addArtifactsFromMergedUsage(string, hashSet);
        } else {
            object = new LinkedHashSet();
            IvyNode.addAllIfNotNull(object, this.usage.getDependencyIncludesSet(string));
            for (Object object2 : this.mergedUsages.values()) {
                IvyNode.addAllIfNotNull((Collection)object, ((IvyNodeUsage)object2).getDependencyIncludesSet(string));
            }
            if ((set == null || set.isEmpty()) && object.isEmpty()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.addAll(Arrays.asList(this.md.getArtifacts(stringArray[i])));
                }
            } else {
                Object object3;
                Object object2;
                HashMap hashMap = new HashMap();
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = this.md.getArtifacts(stringArray[i]);
                    for (int j = 0; j < ((Artifact[])object3).length; ++j) {
                        hashMap.put(object3[j].getId().getArtifactId(), object3[j]);
                    }
                }
                if (set != null) {
                    this.addArtifactsFromOwnUsage(hashSet, set);
                }
                this.addArtifactsFromMergedUsage(string, hashSet);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    object3 = (IncludeRule)object2.next();
                    Collection collection = IvyNode.findArtifactsMatching((IncludeRule)object3, hashMap);
                    if (collection.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + object3.getId());
                        object2.remove();
                        continue;
                    }
                    Message.debug(this + " in " + string + ": including " + collection);
                    hashSet.addAll(collection);
                }
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Artifact artifact = (Artifact)object.next();
            if (!this.callers.doesCallersExclude(string, artifact)) continue;
            Message.debug(this + " in " + string + ": excluding " + artifact);
            object.remove();
        }
        return hashSet.toArray(new Artifact[hashSet.size()]);
    }

    private void addArtifactsFromOwnUsage(Set set, Set set2) {
        for (DependencyArtifactDescriptor dependencyArtifactDescriptor : set2) {
            set.add(new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), dependencyArtifactDescriptor.getQualifiedExtraAttributes()));
        }
    }

    private void addArtifactsFromMergedUsage(String string, Set set) {
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            Set set2 = ivyNodeUsage.getDependencyArtifactsSet(string);
            if (set2 == null) continue;
            for (DependencyArtifactDescriptor dependencyArtifactDescriptor : set2) {
                HashMap<String, String> hashMap = new HashMap<String, String>(dependencyArtifactDescriptor.getQualifiedExtraAttributes());
                MDArtifact mDArtifact = new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), hashMap);
                if (set.contains(mDArtifact)) continue;
                hashMap.put("ivy:merged", dependencyArtifactDescriptor.getDependencyDescriptor().getParentRevisionId() + " -> " + ivyNodeUsage.getNode().id);
                set.add(mDArtifact);
            }
        }
    }

    private static Collection findArtifactsMatching(IncludeRule includeRule, Map map2) {
        ArrayList arrayList = new ArrayList();
        for (ArtifactId artifactId : map2.keySet()) {
            if (!LogOptions.matches(includeRule.getMatcher(), includeRule.getId(), artifactId)) continue;
            arrayList.add(map2.get(artifactId));
        }
        return arrayList;
    }

    public final boolean hasProblem() {
        return this.problem != null;
    }

    public final Exception getProblem() {
        return this.problem;
    }

    public final String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public final boolean isDownloaded() {
        return this.downloaded;
    }

    public final boolean isSearched() {
        return this.searched;
    }

    public final boolean isLoaded() {
        return this.md != null;
    }

    public final IvyNode findNode(ModuleRevisionId moduleRevisionId) {
        return this.data.getNode(moduleRevisionId);
    }

    final boolean isRoot() {
        return this.root == this;
    }

    public final IvyNode getRoot() {
        return this.root;
    }

    public final ConflictManager getConflictManager(ModuleId moduleId) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this.toString());
        }
        ConflictManager conflictManager = this.md.getConflictManager(moduleId);
        if (conflictManager == null) {
            return this.settings.getConflictManager(moduleId);
        }
        return conflictManager;
    }

    public final IvyNode getRealNode() {
        IvyNode ivyNode = this.data.getNode(this.id);
        if (ivyNode != null) {
            return ivyNode;
        }
        return this;
    }

    public final ModuleRevisionId getId() {
        return this.id;
    }

    public final ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public final ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public final ResolveData getData() {
        return this.data;
    }

    public final ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public final long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public final long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public final ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.id;
    }

    public final void clean() {
        this.confsToFetch.clear();
    }

    final boolean canExclude(String string) {
        IvyNodeCallers$Caller[] ivyNodeCallers$CallerArray = this.getCallers(string);
        for (int i = 0; i < ivyNodeCallers$CallerArray.length; ++i) {
            if (!ivyNodeCallers$CallerArray[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    public final IvyNodeCallers$Caller[] getCallers(String string) {
        return this.callers.getCallers(string);
    }

    public final Collection getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public final IvyNodeCallers$Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    private static ModuleRevisionId[] toMrids(Collection collection, IvyNode ivyNode) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[collection.size() + 1];
        int n = 0;
        for (IvyNode ivyNode2 : collection) {
            moduleRevisionIdArray[n] = ivyNode2.id;
            ++n;
        }
        moduleRevisionIdArray[moduleRevisionIdArray.length - 1] = ivyNode.id;
        return moduleRevisionIdArray;
    }

    public final Set getResolvedNodes(ModuleId moduleId, String string) {
        return this.eviction.getResolvedNodes(moduleId, string);
    }

    public final Collection getResolvedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getResolvedRevisions(moduleId, string);
    }

    public final void markEvicted(IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData) {
        this.eviction.markEvicted(ivyNodeEviction$EvictionData);
        String string = ivyNodeEviction$EvictionData.getRootModuleConf();
        if (ivyNodeEviction$EvictionData.getSelected() != null) {
            Iterator iterator2 = ivyNodeEviction$EvictionData.getSelected().iterator();
            while (iterator2.hasNext()) {
                ((IvyNode)iterator2.next()).updateDataFrom(this, string, false);
            }
        }
    }

    public final Collection getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public final Collection getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public final String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public final IvyNodeEviction$EvictionData getEvictedData(String string) {
        return this.eviction.getEvictedData(string);
    }

    public final Collection getEvictedNodes(ModuleId moduleId, String string) {
        return this.eviction.getEvictedNodes(moduleId, string);
    }

    public final Collection getEvictedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getEvictedRevisions(moduleId, string);
    }

    public final IvyNodeEviction$EvictionData getEvictionDataInRoot(String string, IvyNode ivyNode) {
        return this.eviction.getEvictionDataInRoot(string, ivyNode);
    }

    public final boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public final boolean isEvicted(String string) {
        return this.eviction.isEvicted(string);
    }

    public final void markEvicted(String string, IvyNode ivyNode, ConflictManager conflictManager, Collection collection) {
        IvyNodeEviction$EvictionData ivyNodeEviction$EvictionData = new IvyNodeEviction$EvictionData(string, ivyNode, conflictManager, collection);
        this.markEvicted(ivyNodeEviction$EvictionData);
    }

    public final void setEvictedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setEvictedNodes(moduleId, string, collection);
    }

    public final void setResolvedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setResolvedNodes(moduleId, string, collection);
    }

    public final String toString() {
        return this.getResolvedId().toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof IvyNode)) {
            return false;
        }
        return ((IvyNode)object).id.equals(this.id);
    }

    public final int compareTo(Object object) {
        IvyNode ivyNode = (IvyNode)object;
        return this.id.getModuleId().compareTo(ivyNode.id.getModuleId());
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final Collection getPendingConflicts(String string, ModuleId moduleId) {
        return this.eviction.getPendingConflicts(string, moduleId);
    }

    public final void setPendingConflicts(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setPendingConflicts(moduleId, string, collection);
    }

    public final void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + ivyNodeBlacklist);
        } else {
            Message.verbose("BLACKLISTING " + ivyNodeBlacklist);
        }
        Stack<IvyNode> stack = new Stack<IvyNode>();
        stack.push(this);
        this.clearEvictionDataInAllCallers(ivyNodeBlacklist.getRootModuleConf(), stack);
        this.usage.blacklist(ivyNodeBlacklist);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String string, Stack stack) {
        IvyNodeCallers$Caller[] ivyNodeCallers$CallerArray = ((IvyNode)stack.peek()).getCallers(string);
        for (int i = 0; i < ivyNodeCallers$CallerArray.length; ++i) {
            IvyNode ivyNode = this.findNode(ivyNodeCallers$CallerArray[i].getModuleRevisionId());
            if (ivyNode == null) continue;
            ivyNode.eviction = new IvyNodeEviction(ivyNode);
            if (stack.contains(ivyNode)) continue;
            stack.push(ivyNode);
            this.clearEvictionDataInAllCallers(string, stack);
            stack.pop();
        }
    }

    public final boolean isBlacklisted(String string) {
        return this.usage.isBlacklisted(string);
    }

    public final boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        String[] stringArray = this.getRootModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isBlacklisted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public final IvyNodeBlacklist getBlacklistData(String string) {
        return this.usage.getBlacklistData(string);
    }

    public final IvyNodeUsage getMainUsage() {
        return this.usage;
    }

    public final boolean hasAnyMergedUsageWithTransitiveDependency(String string) {
        if (this.mergedUsages == null) {
            return false;
        }
        Iterator iterator2 = this.mergedUsages.values().iterator();
        while (iterator2.hasNext()) {
            if (!((IvyNodeUsage)iterator2.next()).hasTransitiveDepender(string)) continue;
            return true;
        }
        return false;
    }
}

