/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.StructuralTableNode;

public class SessionStructure {
    public static final String ROOT = "Root";
    public static final String DATA_DRIVEN_NODE_PREFIX = "\u00ab";
    public static final String DATA_DRIVEN_NODE_POSTFIX = "\u00bb";
    public static final String DATA_DRIVEN_NODE_REGEX = "(.+?)";
    private static final Logger log = Logger.getLogger(SessionStructure.class);

    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg) {
        return SessionStructure.addPath(session, ref, msg, false);
    }

    public static StructuralNode addPath(Session session, HistoryReference ref, HttpMessage msg, boolean newOnly) {
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = session.getSiteTree().addPath(ref, msg, newOnly);
            if (node != null) {
                return new StructuralSiteNode(node);
            }
            return null;
        }
        try {
            List<String> paths = session.getTreePath(msg);
            String host = SessionStructure.getHostName(msg.getRequestHeader().getURI());
            RecordStructure rs = SessionStructure.addStructure(session, host, msg, paths, paths.size(), ref.getHistoryId(), newOnly);
            if (rs != null) {
                return new StructuralTableNode(rs);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static StructuralNode find(long sessionId, URI uri, String method, String postData) throws DatabaseException, URIException {
        Model model = Model.getSingleton();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode node = model.getSession().getSiteTree().findNode(uri, method, postData);
            if (node == null) {
                return null;
            }
            return new StructuralSiteNode(node);
        }
        String nodeName = SessionStructure.getNodeName(uri, method, postData);
        RecordStructure rs = model.getDb().getTableStructure().find(sessionId, nodeName, method);
        if (rs == null) {
            return null;
        }
        return new StructuralTableNode(rs);
    }

    private static String getNodeName(URI uri, String method, String postData) throws URIException {
        String params;
        Session session = Model.getSingleton().getSession();
        List<String> paths = session.getTreePath(uri);
        String host = SessionStructure.getHostName(uri);
        String nodeUrl = SessionStructure.pathsToUrl(host, paths, paths.size());
        if (postData != null && (params = SessionStructure.getParams(session, uri, postData)).length() > 0) {
            nodeUrl = nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    private static String getNodeName(Session session, String host, HttpMessage msg, List<String> paths, int size) throws URIException {
        String params;
        String nodeUrl = SessionStructure.pathsToUrl(host, paths, size);
        if (msg != null && (params = SessionStructure.getParams(session, msg)).length() > 0) {
            nodeUrl = nodeUrl + " " + params;
        }
        return nodeUrl;
    }

    public static String getNodeName(HttpMessage msg) throws URIException {
        return SessionStructure.getNodeName(msg.getRequestHeader().getURI(), msg.getRequestHeader().getMethod(), msg.getRequestBody().toString());
    }

    public static String regexEscape(String str) {
        String chrsToEscape = ".*+?^=!${}()|[]\\";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (chrsToEscape.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getRegexName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, true);
    }

    public static String getCleanRelativeName(StructuralNode sn, boolean incParams) {
        return SessionStructure.getSpecifiedName(sn, incParams, false);
    }

    private static String getSpecifiedName(StructuralNode sn, boolean incParams, boolean dataDrivenNodesAsRegex) {
        int colonIndex;
        int quesIndex;
        String name = sn.getName();
        if (sn.isDataDriven() && dataDrivenNodesAsRegex) {
            return DATA_DRIVEN_NODE_REGEX;
        }
        int bracketIndex = name.lastIndexOf("(");
        if (bracketIndex >= 0) {
            name = name.substring(0, bracketIndex);
        }
        if ((quesIndex = name.indexOf("?")) >= 0) {
            if (incParams) {
                String params = name.substring(quesIndex);
                name = name.substring(0, quesIndex) + SessionStructure.regexEscape(params);
            } else {
                name = name.substring(0, quesIndex);
            }
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        try {
            if (sn.getURI().getPath() == null || sn.getURI().getPath().length() == 1) {
                return name;
            }
        }
        catch (URIException params) {
            // empty catch block
        }
        int slashIndex = name.lastIndexOf(47);
        if (slashIndex >= 0) {
            name = name.substring(slashIndex + 1);
        }
        if (sn.isLeaf() && (colonIndex = name.indexOf(":")) > 0) {
            name = name.substring(colonIndex + 1);
        }
        return name;
    }

    public static String getRegexPattern(StructuralNode sn) throws DatabaseException {
        return SessionStructure.getRegexPattern(sn, true);
    }

    public static String getRegexPattern(StructuralNode sn, boolean incChildren) throws DatabaseException {
        boolean incParams;
        StringBuilder sb = new StringBuilder();
        boolean bl = incParams = sn.isLeaf() || !incChildren;
        while (!sn.isRoot()) {
            if (sb.length() > 0) {
                sb.insert(0, "/");
            }
            sb.insert(0, SessionStructure.getRegexName(sn, incParams));
            sn = sn.getParent();
            incParams = false;
        }
        if (incChildren) {
            sb.append(".*");
        }
        return sb.toString();
    }

    private static RecordStructure addStructure(Session session, String host, HttpMessage msg, List<String> paths, int size, int historyId, boolean newOnly) throws DatabaseException, URIException {
        RecordStructure msgRs;
        String nodeName = SessionStructure.getNodeName(session, host, msg, paths, size);
        String parentName = SessionStructure.pathsToUrl(host, paths, size - 1);
        String url = "";
        if (msg != null) {
            url = msg.getRequestHeader().getURI().toString();
            String params = SessionStructure.getParams(session, msg);
            if (params.length() > 0) {
                nodeName = nodeName + " " + params;
            }
        }
        String method = "GET";
        if (msg != null) {
            method = msg.getRequestHeader().getMethod();
        }
        if ((msgRs = Model.getSingleton().getDb().getTableStructure().find(session.getSessionId(), nodeName, method)) == null) {
            long parentId = -1L;
            if (!nodeName.equals(ROOT)) {
                HttpMessage tmpMsg = null;
                int parentHistoryId = -1;
                if (!parentName.equals(ROOT)) {
                    tmpMsg = SessionStructure.getTempHttpMessage(session, parentName, msg);
                    parentHistoryId = tmpMsg.getHistoryRef().getHistoryId();
                }
                RecordStructure parentRs = SessionStructure.addStructure(session, host, tmpMsg, paths, size - 1, parentHistoryId, false);
                parentId = parentRs.getStructureId();
            }
            msgRs = Model.getSingleton().getDb().getTableStructure().insert(session.getSessionId(), parentId, historyId, nodeName, url, method);
        } else if (newOnly) {
            return null;
        }
        return msgRs;
    }

    private static HttpMessage getTempHttpMessage(Session session, String url, HttpMessage base) {
        try {
            HttpMessage newMsg = base.cloneRequest();
            URI uri = new URI(url, false);
            newMsg.getRequestHeader().setURI(uri);
            newMsg.getRequestHeader().setMethod("GET");
            newMsg.getRequestBody().setBody("");
            newMsg.getRequestHeader().setHeader("Content-Type", null);
            newMsg.getRequestHeader().setHeader("Content-Length", null);
            HistoryReference historyRef = new HistoryReference(session, 0, newMsg);
            newMsg.setHistoryRef(historyRef);
            return newMsg;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String pathsToUrl(String host, List<String> paths, int size) {
        if (size < 0) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(host);
        int i = 1;
        for (String path : paths) {
            if (i > size) break;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(path);
            ++i;
        }
        return sb.toString();
    }

    public static String getHostName(HttpMessage msg) throws URIException {
        return SessionStructure.getHostName(msg.getRequestHeader().getURI());
    }

    public static String getHostName(URI uri) throws URIException {
        StringBuilder host = new StringBuilder();
        String scheme = uri.getScheme().toLowerCase();
        host.append(scheme).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (port != -1 && (port == 80 && !"http".equals(scheme) || port == 443 && !"https".equals(scheme) || port != 80 && port != 443)) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private static String getParams(Session session, HttpMessage msg) throws URIException {
        String postData = null;
        if (msg.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            String contentType = msg.getRequestHeader().getHeader("Content-Type");
            postData = contentType != null && contentType.startsWith("multipart/form-data") ? "(multipart/form-data)" : msg.getRequestBody().toString();
        }
        return SessionStructure.getParams(session, msg.getRequestHeader().getURI(), postData);
    }

    private static String getParams(Session session, URI uri, String postData) throws URIException {
        String leafName = "";
        String query = "";
        try {
            query = uri.getQuery();
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (query == null) {
            query = "";
        }
        leafName = leafName + SessionStructure.getQueryParamString(session.getUrlParams(uri));
        query = "";
        if (postData != null && postData.length() > 0) {
            leafName = postData.equals("multipart/form-data") ? leafName + "(multipart/form-data)" : leafName + SessionStructure.getQueryParamString(session.getFormParams(uri, postData));
        }
        return leafName;
    }

    private static String getQueryParamString(Map<String, String> map) {
        TreeSet<String> set = new TreeSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            set.add(entry.getKey());
        }
        return SessionStructure.getQueryParamString(set);
    }

    private static String getQueryParamString(SortedSet<String> querySet) {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = querySet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (name != null) {
                if (i > 0) {
                    sb.append(',');
                }
                if (name.length() > 40) {
                    name = name.substring(0, 40);
                }
                sb.append(name);
            }
            ++i;
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.insert(0, '(').append(')').toString();
        }
        return result;
    }
}

