/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.DistributionDescriptor;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGridGUI.Application.Adapter;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.DbEnv;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.PlainServerEditor;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.Server;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PlainServer
extends Communicator
implements Server {
    private ServerDescriptor _descriptor;
    private final boolean _ephemeral;
    private PlainServerEditor _editor;
    private Utils.Resolver _resolver;
    private Editable _editable;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _serverIcon;
    private static Icon _iceboxServerIcon;
    private static JPopupMenu _popup;

    public static ServerDescriptor copyDescriptor(ServerDescriptor sd) {
        ServerDescriptor copy = sd.clone();
        copy.adapters = Adapter.copyDescriptors(copy.adapters);
        copy.dbEnvs = DbEnv.copyDescriptors(copy.dbEnvs);
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        copy.distrib = copy.distrib.clone();
        if (copy instanceof IceBoxDescriptor) {
            IceBoxDescriptor ib = (IceBoxDescriptor)copy;
            ib.services = ServiceInstance.copyDescriptors(ib.services);
        }
        return copy;
    }

    public static void shallowRestore(ServerDescriptor from, ServerDescriptor into) {
        into.propertySet = from.propertySet;
        into.description = from.description;
        into.id = from.id;
        into.exe = from.exe;
        into.options = from.options;
        into.envs = from.envs;
        into.activation = from.activation;
        into.activationTimeout = from.activationTimeout;
        into.deactivationTimeout = from.deactivationTimeout;
        into.applicationDistrib = from.applicationDistrib;
        into.distrib.icepatch = from.distrib.icepatch;
        into.distrib.directories = from.distrib.directories;
    }

    public static ServerDescriptor newServerDescriptor() {
        return new ServerDescriptor(new LinkedList(), new PropertySetDescriptor(new String[0], new LinkedList()), new LinkedList(), new String[0], "", "NewServer", "", "", "", new LinkedList(), new LinkedList(), "manual", "", "", true, new DistributionDescriptor("", new LinkedList()), false, "");
    }

    public static IceBoxDescriptor newIceBoxDescriptor() {
        return new IceBoxDescriptor(new LinkedList(), new PropertySetDescriptor(new String[0], new LinkedList()), new LinkedList(), new String[0], "", "NewIceBox", "", "", "", new LinkedList(), new LinkedList(), "manual", "", "", true, new DistributionDescriptor("", new LinkedList()), false, "", new LinkedList());
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && (clipboard instanceof ServerDescriptor || clipboard instanceof ServerInstanceDescriptor || this.isIceBox() && clipboard instanceof ServiceInstanceDescriptor || !this.isIceBox() && (clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor))) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[13] = true;
            actions[16] = true;
            actions[17] = true;
            actions[0] = !this._services.initialized();
            actions[1] = !this._services.initialized();
            actions[8] = this._services.initialized();
            actions[9] = this._services.initialized();
        }
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
            _popup.add(actions.get(8));
            _popup.add(actions.get(9));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(PlainServer.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (PlainServerEditor)this.getRoot().getEditor(PlainServerEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new PlainServerEditor();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _serverIcon = Utils.getIcon("/icons/16x16/server_inactive.png");
            _iceboxServerIcon = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
        }
        if (expanded) {
            _cellRenderer.setOpenIcon(this.isIceBox() ? _iceboxServerIcon : _serverIcon);
        } else {
            _cellRenderer.setClosedIcon(this.isIceBox() ? _iceboxServerIcon : _serverIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public void destroy() {
        Node node = (Node)this._parent;
        if (this._ephemeral) {
            node.removeServer(this);
        } else {
            node.removeDescriptor(this._descriptor);
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            this.getRoot().updated();
        }
    }

    @Override
    public Object getDescriptor() {
        return this._descriptor;
    }

    @Override
    public Object saveDescriptor() {
        ServerDescriptor clone = this._descriptor.clone();
        clone.distrib = clone.distrib.clone();
        return clone;
    }

    @Override
    public void restoreDescriptor(Object savedDescriptor) {
        PlainServer.shallowRestore((ServerDescriptor)savedDescriptor, this._descriptor);
    }

    PlainServer(boolean brandNew, TreeNode parent, String serverId, Utils.Resolver resolver, ServerDescriptor serverDescriptor) throws UpdateFailedException {
        super(parent, serverId);
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(resolver, serverDescriptor);
    }

    PlainServer(TreeNode parent, String serverId, ServerDescriptor serverDescriptor) {
        block2: {
            super(parent, serverId);
            this._ephemeral = true;
            this._editable = null;
            try {
                this.rebuild(null, serverDescriptor);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    static List<String[]> createAttributes(ServerDescriptor descriptor) {
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        attributes.add(PlainServer.createAttribute("id", descriptor.id));
        if (descriptor.activation.length() > 0) {
            attributes.add(PlainServer.createAttribute("activation", descriptor.activation));
        }
        if (descriptor.activationTimeout.length() > 0) {
            attributes.add(PlainServer.createAttribute("activation-timeout", descriptor.activationTimeout));
        }
        if (!descriptor.applicationDistrib) {
            attributes.add(PlainServer.createAttribute("application-distrib", "false"));
        }
        if (descriptor.deactivationTimeout.length() > 0) {
            attributes.add(PlainServer.createAttribute("deactivation-timeout", descriptor.deactivationTimeout));
        }
        if (descriptor.exe.length() > 0) {
            attributes.add(PlainServer.createAttribute("exe", descriptor.exe));
        }
        if (descriptor.iceVersion.length() > 0) {
            attributes.add(PlainServer.createAttribute("ice-version", descriptor.iceVersion));
        }
        if (descriptor.pwd.length() > 0) {
            attributes.add(PlainServer.createAttribute("pwd", descriptor.pwd));
        }
        return attributes;
    }

    static void writeOptions(XMLWriter writer, List<String> options) throws IOException {
        for (String p : options) {
            writer.writeElement("option", p);
        }
    }

    static void writeEnvs(XMLWriter writer, List<String> envs) throws IOException {
        for (String p : envs) {
            writer.writeElement("env", p);
        }
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            if (this.isIceBox()) {
                writer.writeStartTag("icebox", PlainServer.createAttributes(this._descriptor));
                if (this._descriptor.description.length() > 0) {
                    writer.writeElement("description", this._descriptor.description);
                }
                PlainServer.writeOptions(writer, this._descriptor.options);
                PlainServer.writeEnvs(writer, this._descriptor.envs);
                PlainServer.writePropertySet(writer, "", "", this._descriptor.propertySet, this._descriptor.adapters, this._descriptor.logs);
                PlainServer.writeLogs(writer, this._descriptor.logs, this._descriptor.propertySet.properties);
                PlainServer.writeDistribution(writer, this._descriptor.distrib);
                this._adapters.write(writer, this._descriptor.propertySet.properties);
                this._services.write(writer);
                writer.writeEndTag("icebox");
            } else {
                writer.writeStartTag("server", PlainServer.createAttributes(this._descriptor));
                if (this._descriptor.description.length() > 0) {
                    writer.writeElement("description", this._descriptor.description);
                }
                PlainServer.writeOptions(writer, this._descriptor.options);
                PlainServer.writeEnvs(writer, this._descriptor.envs);
                PlainServer.writePropertySet(writer, this._descriptor.propertySet, this._descriptor.adapters, this._descriptor.logs);
                PlainServer.writeLogs(writer, this._descriptor.logs, this._descriptor.propertySet.properties);
                PlainServer.writeDistribution(writer, this._descriptor.distrib);
                this._adapters.write(writer, this._descriptor.propertySet.properties);
                this._dbEnvs.write(writer);
                writer.writeEndTag("server");
            }
        }
    }

    @Override
    boolean isIceBox() {
        return this._descriptor instanceof IceBoxDescriptor;
    }

    @Override
    public Object rebuild(List<Editable> editables) throws UpdateFailedException {
        Node node = (Node)this._parent;
        PlainServer newServer = node.createServer(false, this._descriptor);
        Editable backup = null;
        if (this._id.equals(newServer.getId())) {
            if (this._editable.isModified()) {
                newServer.getEditable().markModified();
            }
            node.removeServer(this);
            try {
                node.insertServer(newServer, true);
            }
            catch (UpdateFailedException e) {
                assert (false);
            }
        } else {
            newServer.getEditable().markNew();
            node.removeServer(this);
            backup = node.getEditable().save();
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            try {
                node.insertServer(newServer, true);
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    @Override
    public void restore(Object backupObj) {
        block4: {
            TreeNode badServer;
            Editable backup = (Editable)backupObj;
            Node node = (Node)this._parent;
            if (backup != null) {
                node.getEditable().restore(backup);
            }
            if ((badServer = node.findChildWithDescriptor(this._descriptor)) != null) {
                node.removeServer(badServer);
            }
            try {
                node.insertServer(this, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    void setServerDescriptor(ServerDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    void rebuild(Utils.Resolver resolver, ServerDescriptor serverDescriptor) throws UpdateFailedException {
        assert (serverDescriptor != null);
        this._resolver = resolver;
        this._descriptor = serverDescriptor;
        this._adapters.clear();
        this._dbEnvs.clear();
        this._services.clear();
        if (!this._ephemeral) {
            this._adapters.init(this._descriptor.adapters);
            if (this.isIceBox()) {
                IceBoxDescriptor iceBoxDescriptor = (IceBoxDescriptor)this._descriptor;
                this._services.init(iceBoxDescriptor.services);
                assert (this._descriptor.dbEnvs.size() == 0);
            } else {
                this._dbEnvs.init(this._descriptor.dbEnvs);
            }
        }
    }

    @Override
    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._descriptor;
    }

    @Override
    Utils.Resolver getResolver() {
        return this._resolver;
    }

    @Override
    public Editable getEditable() {
        return this._editable;
    }

    @Override
    Editable getEnclosingEditable() {
        return this._editable;
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }
}

