/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.CPExtensionsRepository;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.Injector;
import org.netbeans.lib.profiler.instrumentation.ObjLivenessMethodInstrumentor;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;

class ObjLivenessInstrCallsInjector
extends Injector
implements CommonConstants {
    protected static byte[] injectedCode;
    protected static int injectedCodeLen;
    protected static int injectedCodeMethodIdxPos;
    protected static int injectedCodeClassIdPos;
    protected boolean[] allUnprofiledClassStatusArray;
    private final InstrumentationFilter instrFilter;
    private final boolean checkForOpcNew;
    private final boolean checkForOpcNewArray;

    public ObjLivenessInstrCallsInjector(DynamicClassInfo dynamicClassInfo, int n, int n2, boolean[] blArray, InstrumentationFilter instrumentationFilter, boolean bl, boolean bl2) {
        super(dynamicClassInfo, n2);
        this.baseCPoolCount = n;
        this.allUnprofiledClassStatusArray = blArray;
        this.instrFilter = instrumentationFilter;
        this.checkForOpcNew = bl;
        this.checkForOpcNewArray = bl2;
    }

    @Override
    public byte[] instrumentMethod() {
        int n = 0;
        int n2 = 0;
        if (ObjLivenessMethodInstrumentor.isObjectConstructor(this.clazz, this.methodIdx)) {
            this.injectTraceObjAllocObjCtor(n);
            ++n2;
        } else {
            Object object;
            int n3 = this.clazz.getLoaderId();
            int n4 = 0;
            int n5 = 0;
            block0: do {
                n5 = n4 + 1;
                for (n = 0; n < this.bytecodesLength && this.bytecodesLength + injectedCodeLen < 65535; n += this.opcodeLength(n)) {
                    int n6;
                    int n7 = this.bytecodes[n] & 0xFF;
                    if ((n7 != 187 || !this.checkForOpcNew) && (!this.checkForOpcNewArray || n7 != 189 && n7 != 188 && n7 != 197) || --n5 != 0) continue;
                    ++n4;
                    if (n7 == 187 || n7 == 189 || n7 == 197) {
                        n6 = this.getU2(n + 1);
                        String string = this.clazz.getRefClassName(n6);
                        if (n7 == 187) {
                            if (!this.instrFilter.passes(string)) continue block0;
                            object = ClassManager.javaClassOrPlaceholderForName(string, n3);
                        } else if (n7 == 189) {
                            if (!this.instrFilter.passes(string.concat("[]"))) continue block0;
                            object = ClassManager.javaClassForObjectArrayType(string);
                        } else {
                            if (!this.instrFilter.passes(ObjLivenessInstrCallsInjector.getMultiArrayClassName(string))) continue block0;
                            object = ClassRepository.lookupSpecialClass(string);
                        }
                        if (object == null) continue block0;
                        int n8 = ((BaseClassInfo)object).getInstrClassId();
                        if (this.allUnprofiledClassStatusArray != null && this.allUnprofiledClassStatusArray.length > n8 && this.allUnprofiledClassStatusArray[n8]) continue block0;
                        if (n7 == 189 || n7 == 197) {
                            this.injectTraceObjAlloc(n8, n + this.opcodeLength(n));
                            ++n2;
                            continue block0;
                        }
                        if ((n7 = this.bytecodes[n += this.opcodeLength(n)] & 0xFF) != 89 && n7 != 90 && n7 != 91) {
                            this.injectDup(n);
                            n = this.locateConstructorCallForNewOp(n, this.bytecodesLength, string);
                            this.injectTraceObjAllocNoDup(n8, n);
                            ++n2;
                            continue block0;
                        }
                        if ((n = this.locateConstructorCallForNewOp(n, this.bytecodesLength, string)) == -1) continue block0;
                        this.injectTraceObjAlloc(n8, n);
                        ++n2;
                        continue block0;
                    }
                    n6 = this.getByte(n + 1);
                    object = ClassManager.javaClassForPrimitiveArrayType(n6);
                    int n9 = ((BaseClassInfo)object).getInstrClassId();
                    String string = StringUtils.userFormClassName(((BaseClassInfo)object).getName());
                    if (!this.instrFilter.passes(string) || this.allUnprofiledClassStatusArray != null && this.allUnprofiledClassStatusArray[n9]) continue block0;
                    this.injectTraceObjAlloc(n9, n + 2);
                    ++n2;
                    continue block0;
                }
            } while (n5 == 0);
            if (n < this.bytecodesLength) {
                object = this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx) + this.clazz.getMethodSignature(this.methodIdx);
                MiscUtils.printWarningMessage("Method " + (String)object + " is too big to be fully instrumented.");
            }
        }
        if (n2 == 0) {
            ((DynamicClassInfo)this.clazz).unsetMethodInstrumented(this.methodIdx);
        } else {
            this.maxStack += 2;
        }
        return this.createPackedMethodInfo();
    }

    private static String getMultiArrayClassName(String string) {
        int n = string.lastIndexOf(91);
        String string2 = string.substring(n + 1);
        if (VMUtils.isVMPrimitiveType(string2)) {
            return StringUtils.userFormClassName(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + n + 1);
        stringBuilder.append(string.substring(n + 1));
        for (int i = 0; i <= n; ++i) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    private static void initializeInjectedCode() {
        injectedCodeLen = 8;
        injectedCode = new byte[injectedCodeLen];
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
        ObjLivenessInstrCallsInjector.injectedCode[1] = 17;
        injectedCodeClassIdPos = 2;
        ObjLivenessInstrCallsInjector.injectedCode[4] = -72;
        injectedCodeMethodIdxPos = 5;
        ObjLivenessInstrCallsInjector.injectedCode[7] = 0;
    }

    private void injectDup(int n) {
        byte[] byArray = new byte[]{89, 0, 0, 0};
        this.injectCodeAndRewrite(byArray, 4, n, false);
    }

    private void injectTraceObjAlloc(int n, int n2) {
        int n3 = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, n3);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, n);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, n2, false);
    }

    private void injectTraceObjAllocNoDup(int n, int n2) {
        ObjLivenessInstrCallsInjector.injectedCode[0] = 0;
        int n3 = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, n3);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, n);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, n2, false);
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
    }

    private void injectTraceObjAllocObjCtor(int n) {
        ObjLivenessInstrCallsInjector.injectedCode[0] = 42;
        int n2 = CPExtensionsRepository.memoryProfContents_TraceObjAllocMethodIdx + this.baseCPoolCount;
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, n2);
        ObjLivenessInstrCallsInjector.putU2(injectedCode, injectedCodeClassIdPos, 0);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, n, true);
        ObjLivenessInstrCallsInjector.injectedCode[0] = 89;
    }

    private int locateConstructorCallForNewOp(int n, int n2, String string) {
        int n3 = 0;
        for (int i = n; i < n2; i += this.opcodeLength(i)) {
            int n4 = this.bytecodes[i] & 0xFF;
            if (n4 == 187) {
                ++n3;
                continue;
            }
            if (n4 != 183) continue;
            int n5 = this.getU2(i + 1);
            String[] stringArray = this.clazz.getRefMethodsClassNameAndSig(n5);
            if (stringArray == null) {
                System.err.println("Failed to locate constant pool ref in: " + this.clazz.getName());
                System.err.println("new Op class: " + string);
                System.err.println("bci: " + i + ", startBCI: " + n);
                System.err.println("constant pool ref index: " + n5);
                this.dumpClassFile();
                return -1;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string3 != "<init>") continue;
            if (n3 == 0) {
                i += this.opcodeLength(i);
                return i;
            }
            --n3;
        }
        System.err.println("Profiler Warning: Failed to instrument creation of class " + string + " in method " + this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx));
        this.dumpClassFile();
        return -1;
    }

    private void dumpClassFile() {
        try {
            ClassRewriter.saveToDisk(this.clazz.getName(), ((DynamicClassInfo)this.clazz).getClassFileBytes());
        }
        catch (IOException iOException) {
            System.err.println("Caught exception while dumping class: " + this.clazz.getName() + ", " + iOException.getMessage());
            iOException.printStackTrace(System.err);
        }
    }

    static {
        ObjLivenessInstrCallsInjector.initializeInjectedCode();
    }
}

