/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class ObjectDataContentHandler
implements DataContentHandler {
    private DataContentHandler dch;
    private Object object;
    private String mimeType;
    private DataFlavor[] flavors;

    public ObjectDataContentHandler(DataContentHandler dataContentHandler, Object object, String string) {
        this.dch = dataContentHandler;
        this.object = object;
        this.mimeType = string;
    }

    @Override
    public Object getContent(DataSource dataSource) {
        return this.object;
    }

    public DataContentHandler getDCH() {
        return this.dch;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(dataFlavor, dataSource);
        }
        if (this.flavors == null) {
            this.getTransferDataFlavors();
        }
        if (dataFlavor.equals(this.flavors[0])) {
            return this.object;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.flavors == null) {
            if (this.dch != null) {
                this.flavors = this.dch.getTransferDataFlavors();
            } else {
                this.flavors = new DataFlavor[1];
                this.flavors[0] = new ActivationDataFlavor(this.object.getClass(), this.mimeType, this.mimeType);
            }
        }
        return this.flavors;
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no object DCH for MIME type " + string);
        }
        this.dch.writeTo(object, string, outputStream);
    }
}

