/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import sun.tools.jconsole.inspector.Utils;

class XArrayDataViewer {
    private XArrayDataViewer() {
    }

    public static boolean isViewableValue(Object value) {
        return Utils.canBeRenderedAsArray(value);
    }

    public static Component loadArray(Object value) {
        JScrollPane comp = null;
        if (XArrayDataViewer.isViewableValue(value)) {
            JScrollPane scrollp;
            Object[] arr;
            if (value instanceof Collection) {
                arr = ((Collection)value).toArray();
            } else if (value instanceof Map) {
                arr = ((Map)value).entrySet().toArray();
            } else if (value instanceof Object[]) {
                arr = (Object[])value;
            } else {
                int length = Array.getLength(value);
                arr = new Object[length];
                for (int i = 0; i < length; ++i) {
                    arr[i] = Array.get(value, i);
                }
            }
            JEditorPane arrayEditor = new JEditorPane();
            arrayEditor.setContentType("text/html");
            arrayEditor.setEditable(false);
            Color evenRowColor = arrayEditor.getBackground();
            int red = evenRowColor.getRed();
            int green = evenRowColor.getGreen();
            int blue = evenRowColor.getBlue();
            String evenRowColorStr = "rgb(" + red + "," + green + "," + blue + ")";
            Color oddRowColor = new Color(red < 20 ? red + 20 : red - 20, green < 20 ? green + 20 : green - 20, blue < 20 ? blue + 20 : blue - 20);
            String oddRowColorStr = "rgb(" + oddRowColor.getRed() + "," + oddRowColor.getGreen() + "," + oddRowColor.getBlue() + ")";
            Color foreground = arrayEditor.getForeground();
            String textColor = String.format("%06x", foreground.getRGB() & 0xFFFFFF);
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body text=#" + textColor + "><table width=\"100%\">");
            for (int i = 0; i < arr.length; ++i) {
                if (i % 2 == 0) {
                    sb.append("<tr style=\"background-color: " + evenRowColorStr + "\"><td><pre>" + (arr[i] == null ? arr[i] : XArrayDataViewer.htmlize(arr[i].toString())) + "</pre></td></tr>");
                    continue;
                }
                sb.append("<tr style=\"background-color: " + oddRowColorStr + "\"><td><pre>" + (arr[i] == null ? arr[i] : XArrayDataViewer.htmlize(arr[i].toString())) + "</pre></td></tr>");
            }
            if (arr.length == 0) {
                sb.append("<tr style=\"background-color: " + evenRowColorStr + "\"><td></td></tr>");
            }
            sb.append("</table></body></html>");
            arrayEditor.setText(sb.toString());
            comp = scrollp = new JScrollPane(arrayEditor);
        }
        return comp;
    }

    private static String htmlize(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;");
    }
}

