/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.text.Format;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.swing.renderer.FormattedLabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;

public class PercentRenderer
extends FormattedLabelRenderer
implements RelativeRenderer {
    private static final String NUL = Formatters.percentFormat().format(0);
    private static final String NAN = NUL.replace('0', '-');
    private long maxValue = 100L;
    protected boolean renderingDiff;

    public PercentRenderer() {
        super(Formatters.percentFormat());
    }

    public void setMaxValue(long l) {
        this.maxValue = l;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setDiffMode(boolean bl) {
        this.renderingDiff = bl;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    protected String getValueString(Object object, int n, Format format) {
        if (object == null) {
            return "-";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (this.maxValue == 0L) {
            stringBuilder.append(NAN);
        } else {
            double d = ((Number)object).doubleValue();
            if (d == 0.0) {
                if (this.renderingDiff) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(NUL);
            } else {
                d /= (double)this.maxValue;
                if (this.renderingDiff && d > 0.0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(format.format(d));
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

