/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class BitFile {
    ImageOutputStream output;
    byte[] buffer;
    int index;
    int bitsLeft;
    boolean blocks = false;

    public BitFile(ImageOutputStream imageOutputStream, boolean bl) {
        this.output = imageOutputStream;
        this.blocks = bl;
        this.buffer = new byte[256];
        this.index = 0;
        this.bitsLeft = 8;
    }

    public void flush() throws IOException {
        int n = this.index + (this.bitsLeft == 8 ? 0 : 1);
        if (n > 0) {
            if (this.blocks) {
                this.output.write(n);
            }
            this.output.write(this.buffer, 0, n);
            this.buffer[0] = 0;
            this.index = 0;
            this.bitsLeft = 8;
        }
    }

    public void writeBits(int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 255;
        do {
            if (this.index == 254 && this.bitsLeft == 0 || this.index > 254) {
                if (this.blocks) {
                    this.output.write(n4);
                }
                this.output.write(this.buffer, 0, n4);
                this.buffer[0] = 0;
                this.index = 0;
                this.bitsLeft = 8;
            }
            if (n2 <= this.bitsLeft) {
                if (this.blocks) {
                    int n5 = this.index;
                    this.buffer[n5] = (byte)(this.buffer[n5] | (n & (1 << n2) - 1) << 8 - this.bitsLeft);
                    n3 += n2;
                    this.bitsLeft -= n2;
                    n2 = 0;
                    continue;
                }
                int n6 = this.index;
                this.buffer[n6] = (byte)(this.buffer[n6] | (n & (1 << n2) - 1) << this.bitsLeft - n2);
                n3 += n2;
                this.bitsLeft -= n2;
                n2 = 0;
                continue;
            }
            if (this.blocks) {
                int n7 = this.index++;
                this.buffer[n7] = (byte)(this.buffer[n7] | (n & (1 << this.bitsLeft) - 1) << 8 - this.bitsLeft);
                n3 += this.bitsLeft;
                n >>= this.bitsLeft;
                n2 -= this.bitsLeft;
                this.buffer[this.index] = 0;
                this.bitsLeft = 8;
                continue;
            }
            int n8 = n >>> n2 - this.bitsLeft & (1 << this.bitsLeft) - 1;
            int n9 = this.index++;
            this.buffer[n9] = (byte)(this.buffer[n9] | n8);
            n2 -= this.bitsLeft;
            n3 += this.bitsLeft;
            this.buffer[this.index] = 0;
            this.bitsLeft = 8;
        } while (n2 != 0);
    }
}

