/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;
import org.netbeans.lib.profiler.utils.StringUtils;

class MonitorInfo {
    private final int monitorId;
    private String className;
    private Map<ThreadInfo, OpenThread> openThreads;
    private Map<ThreadInfo, ThreadDetail> waitThreads;
    private Map<ThreadInfo, ThreadDetail> ownerThreads;

    MonitorInfo(int n) {
        this.monitorId = n;
        this.waitThreads = new HashMap<ThreadInfo, ThreadDetail>();
        this.ownerThreads = new HashMap<ThreadInfo, ThreadDetail>();
        this.openThreads = new HashMap<ThreadInfo, OpenThread>();
        this.className = "*unknown*";
    }

    MonitorInfo(int n, String string) {
        this(n);
        this.className = StringUtils.userFormClassName(string);
    }

    void setClassName(String string) {
        this.className = StringUtils.userFormClassName(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MonitorInfo) {
            MonitorInfo monitorInfo = (MonitorInfo)object;
            return monitorInfo.monitorId == this.monitorId;
        }
        return false;
    }

    public int hashCode() {
        return this.monitorId;
    }

    void openThread(ThreadInfo threadInfo, ThreadInfo threadInfo2, long l) {
        assert (this.openThreads.get(threadInfo) == null);
        this.openThreads.put(threadInfo, new OpenThread(threadInfo, threadInfo2, l));
    }

    void closeThread(ThreadInfo threadInfo, long l) {
        OpenThread openThread = this.openThreads.remove(threadInfo);
        assert (openThread != null);
        long l2 = l - openThread.timeStamp;
        MonitorInfo.addThread(this.waitThreads, threadInfo, openThread.owner, l2);
        MonitorInfo.addThread(this.ownerThreads, openThread.owner, threadInfo, l2);
    }

    private static void addThread(Map<ThreadInfo, ThreadDetail> map, ThreadInfo threadInfo, ThreadInfo threadInfo2, long l) {
        ThreadDetail threadDetail = map.get(threadInfo);
        if (threadDetail == null) {
            threadDetail = new ThreadDetail(threadInfo);
            map.put(threadInfo, threadDetail);
        }
        threadDetail.addWait(threadInfo2, l);
    }

    void timeAdjust(ThreadInfo threadInfo, long l) {
        OpenThread openThread = this.openThreads.get(threadInfo);
        assert (openThread != null);
        openThread.timeAdjust(l);
    }

    List<ThreadDetail> cloneWaitThreadDetails() {
        return MonitorInfo.cloneThreadDetails(this.waitThreads);
    }

    List<ThreadDetail> cloneOwnerThreadDetails() {
        return MonitorInfo.cloneThreadDetails(this.ownerThreads);
    }

    static List<ThreadDetail> cloneThreadDetails(Map<ThreadInfo, ThreadDetail> map) {
        ArrayList<ThreadDetail> arrayList = new ArrayList<ThreadDetail>(map.size());
        for (ThreadDetail threadDetail : map.values()) {
            arrayList.add(new ThreadDetail(threadDetail));
        }
        return arrayList;
    }

    String getName() {
        return new StringBuffer(this.className).append('(').append(Integer.toHexString(this.monitorId)).append(')').toString();
    }

    static class ThreadDetail {
        final ThreadInfo threadInfo;
        private Map<ThreadInfo, ThreadDetail> threads;
        long count;
        long waitTime;

        ThreadDetail(ThreadInfo threadInfo) {
            this.threadInfo = threadInfo;
            this.threads = new HashMap<ThreadInfo, ThreadDetail>();
        }

        ThreadDetail(ThreadDetail threadDetail) {
            this.threadInfo = threadDetail.threadInfo;
            this.count = threadDetail.count;
            this.waitTime = threadDetail.waitTime;
            this.threads = new HashMap<ThreadInfo, ThreadDetail>();
            for (ThreadDetail threadDetail2 : threadDetail.threads.values()) {
                this.threads.put(threadDetail2.threadInfo, new ThreadDetail(threadDetail2));
            }
        }

        List<ThreadDetail> cloneThreadDetails() {
            return MonitorInfo.cloneThreadDetails(this.threads);
        }

        void addWait(ThreadInfo threadInfo, long l) {
            this.waitTime += l;
            ++this.count;
            if (threadInfo != null) {
                this.addThread(threadInfo, l);
            }
        }

        private void addThread(ThreadInfo threadInfo, long l) {
            ThreadDetail threadDetail = this.threads.get(threadInfo);
            if (threadDetail == null) {
                threadDetail = new ThreadDetail(threadInfo);
                this.threads.put(threadInfo, threadDetail);
            }
            threadDetail.addWait(null, l);
        }
    }

    private static class OpenThread {
        private final ThreadInfo threadInfo;
        private final ThreadInfo owner;
        private long timeStamp;

        OpenThread(ThreadInfo threadInfo, ThreadInfo threadInfo2, long l) {
            this.threadInfo = threadInfo;
            this.owner = threadInfo2;
            this.timeStamp = l;
        }

        private void timeAdjust(long l) {
            this.timeStamp += l;
        }
    }
}

