/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.Timer;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.impl.TabListPopupAction;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ButtonFactory {
    public static JButton createDropDownButton(Controller controller) {
        JButton jButton = new JButton(new TabListPopupAction(controller));
        jButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/down.png", (boolean)true));
        jButton.setActionCommand("pressed");
        jButton.setFocusable(false);
        jButton.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_DocumentList"));
        return jButton;
    }

    public static JButton createMaximizeButton(final Controller controller) {
        final JButton jButton = new JButton();
        jButton.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/maximize.png", (boolean)true));
        jButton.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_MaximizeRestore"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                controller.postActionEvent(new TabActionEvent((Object)jButton, "maximize", -1));
            }
        });
        jButton.setFocusable(false);
        return jButton;
    }

    public static JButton createScrollLeftButton(Action action) {
        TimerButton timerButton = new TimerButton(action);
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/left.png", (boolean)true);
        timerButton.setIcon(imageIcon);
        timerButton.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_ScrollLeft"));
        return timerButton;
    }

    public static JButton createScrollRightButton(Action action) {
        TimerButton timerButton = new TimerButton(action);
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/core/multitabs/resources/right.png", (boolean)true);
        timerButton.setIcon(imageIcon);
        timerButton.setToolTipText(NbBundle.getMessage(ButtonFactory.class, (String)"Hint_ScrollRight"));
        return timerButton;
    }

    private static class TimerButton
    extends JButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(Action action) {
            this.setAction(action);
            this.setFocusable(false);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer timer = this.getTimer();
            if (timer.isRunning()) {
                return;
            }
            this.repaint();
            timer.setDelay(400);
            timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (this.isEnabled() && mouseEvent.getID() == 501) {
                this.startTimer();
            } else if (mouseEvent.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                this.stopTimer();
            }
        }
    }
}

