/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    protected AbstractTreeTableModel treeTableModel;
    protected JTree tree;
    protected JTreeTable treeTable;
    private boolean firingChange;

    public TreeTableModelAdapter(AbstractTreeTableModel abstractTreeTableModel, JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
        this.tree = jTreeTable.getTree();
        this.treeTableModel = abstractTreeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }
        });
        abstractTreeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public List getExpandedPaths() {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(this.getRootPath());
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    public TreePath getRootPath() {
        return new TreePath(this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()));
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
        return object;
    }

    public void expandRoot() {
        this.tree.expandPath(this.getRootPath());
    }

    public void restoreExpandedPaths(List list) {
        this.tree.putClientProperty("expansion_transaction", Boolean.TRUE);
        for (Object e : list) {
            this.tree.expandPath((TreePath)e);
        }
        this.tree.putClientProperty("expansion_transaction", Boolean.FALSE);
    }

    private TreePath getCurrentPath(TreePath treePath) {
        if (treePath == null || treePath.getPathCount() < 1) {
            return null;
        }
        if (!this.treeTableModel.getRoot().equals(treePath.getPathComponent(0))) {
            return null;
        }
        TreePath treePath2 = this.getRootPath();
        Object[] objectArray = treePath.getPath();
        CCTNode cCTNode = (CCTNode)this.treeTableModel.getRoot();
        for (int i = 1; i < objectArray.length; ++i) {
            CCTNode[] cCTNodeArray = cCTNode.getChildren();
            if (cCTNodeArray == null) {
                return null;
            }
            CCTNode cCTNode2 = null;
            for (CCTNode cCTNode3 : cCTNodeArray) {
                if (!cCTNode3.equals(objectArray[i])) continue;
                cCTNode2 = cCTNode3;
                break;
            }
            if (cCTNode2 == null) {
                return null;
            }
            cCTNode = cCTNode2;
            treePath2 = treePath2.pathByAddingChild(cCTNode);
        }
        return treePath2;
    }

    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List list = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.tree.getSelectionModel().clearSelection();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                if (treePathArray != null) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        treePathArray[i] = TreeTableModelAdapter.this.getCurrentPath(treePathArray[i]);
                    }
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
                TreeTableModelAdapter.this.restoreExpandedPaths(list);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public void changeRoot(final CCTNode cCTNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List list = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.treeTableModel.setRoot(cCTNode);
                TreeTableModelAdapter.this.tree.getSelectionModel().clearSelection();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                if (treePathArray != null) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        treePathArray[i] = TreeTableModelAdapter.this.getCurrentPath(treePathArray[i]);
                    }
                }
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                for (Object e : list) {
                    arrayList.add(TreeTableModelAdapter.this.getCurrentPath((TreePath)e));
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
                TreeTableModelAdapter.this.restoreExpandedPaths(arrayList);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public void setup(List list, TreePath treePath) {
        this.tree.getSelectionModel().clearSelection();
        this.treeTableModel.fireTreeStructureChanged(this, this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()), null, null);
        this.treeTable.getTableHeader().repaint();
        this.fireTableDataChanged();
        if (list != null) {
            this.restoreExpandedPaths(list);
        }
        if (treePath != null) {
            this.tree.setSelectionPath(treePath);
            final Rectangle rectangle = this.tree.getPathBounds(treePath);
            if (rectangle != null) {
                this.treeTable.scrollRectToVisible(this.tree.getPathBounds(treePath));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeTableModelAdapter.this.treeTable.scrollRectToVisible(rectangle);
                    }
                });
            }
        }
    }

    public final boolean isFiringChange() {
        return this.firingChange;
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.firingChange = true;
                try {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
                finally {
                    TreeTableModelAdapter.this.firingChange = false;
                }
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }
        });
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }
}

