/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.Exceptions;

final class Utils {
    Utils() {
    }

    static String getFontName(Instance instance, Heap heap) {
        Instance instance2;
        Instance instance3;
        String string = Utils.getFieldString(instance, "name");
        if (string == null && (instance3 = (Instance)instance.getValueOfField("font2DHandle")) != null && (instance2 = (Instance)instance3.getValueOfField("font2D")) != null && (string = Utils.getFieldString(instance, "fullName")) == null) {
            string = Utils.getFieldString(instance, "nativeFontName");
        }
        return string;
    }

    static String getFieldString(Instance instance, String string) {
        Object object = instance.getValueOfField(string);
        if (object instanceof Instance) {
            try {
                Class<?> clazz = Class.forName("org.netbeans.lib.profiler.heap.HprofProxy");
                Method method = clazz.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(clazz, object);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    static abstract class View<T extends InstanceBuilder>
    extends DetailsProvider.View
    implements Scrollable {
        private static final int DASH_SIZE = 20;
        private final int margin;
        private final boolean pattern;
        private final boolean stretch;
        private Component component;
        private JPanel glassPane;

        View(Instance instance, Heap heap) {
            this(10, true, false, instance, heap);
        }

        View(int n, boolean bl, boolean bl2, Instance instance, Heap heap) {
            super(instance, heap);
            this.margin = n;
            this.pattern = bl;
            this.stretch = bl2;
        }

        protected T getBuilder(Instance instance, Heap heap) {
            return null;
        }

        protected Component getComponent(T t) {
            return null;
        }

        protected void setupGlassPane(JPanel jPanel) {
        }

        @Override
        protected final void computeView(Instance instance, Heap heap) {
            T t = this.getBuilder(instance, heap);
            SwingUtilities.invokeLater(new Runnable((InstanceBuilder)t){
                final /* synthetic */ InstanceBuilder val$builder;
                {
                    this.val$builder = instanceBuilder;
                }

                @Override
                public void run() {
                    this.removeAll();
                    component = this.val$builder == null ? null : this.getComponent(this.val$builder);
                    if (component != null) {
                        component.setVisible(true);
                        if (stretch) {
                            this.add(component, "Center");
                        } else {
                            glassPane = new JPanel(null){

                                @Override
                                public Point getToolTipLocation(MouseEvent mouseEvent) {
                                    Point point = mouseEvent.getPoint();
                                    point.translate(15, 15);
                                    return point;
                                }
                            };
                            glassPane.setOpaque(false);
                            glassPane.addMouseListener(new MouseAdapter(){});
                            glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
                            glassPane.addKeyListener(new KeyAdapter(){});
                            this.setupGlassPane(glassPane);
                            this.add(glassPane);
                            this.setLayout(null);
                            this.add(component);
                        }
                        if (component.getWidth() == 0 || component.getHeight() == 0) {
                            component.setSize(component.getPreferredSize());
                        }
                        Dimension dimension = component.getSize();
                        dimension.width += margin;
                        dimension.height += margin;
                        this.setPreferredSize(dimension);
                        this.setBackground(UIUtils.getProfilerResultsBackground());
                        this.setForeground(UIUtils.getDarker((Color)this.getBackground()));
                    } else {
                        component = new JLabel(Bundle.Utils_NoDetails(), 0);
                        component.setEnabled(false);
                        this.add(component, "Center");
                    }
                    this.revalidate();
                    this.doLayout();
                    this.repaint();
                }
            });
        }

        @Override
        public void doLayout() {
            if (this.getLayout() != null) {
                super.doLayout();
            } else {
                Dimension dimension = this.getSize();
                Dimension dimension2 = this.component.getSize();
                int n = dimension2.width >= dimension.width ? 0 : (dimension.width - dimension2.width) / 2;
                int n2 = dimension2.height >= dimension.height ? 0 : (dimension.height - dimension2.height) / 2;
                this.component.move(n, n2);
                this.glassPane.setBounds(this.component.getBounds());
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.pattern || this.component == null) {
                super.paintComponent(graphics);
            } else {
                int n = 0;
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                for (int i = 0; i <= n3; i += 20) {
                    boolean bl;
                    boolean bl2 = bl = i / 20 % 2 == 0;
                    while (n <= n2) {
                        graphics.setColor(bl ? this.getBackground() : this.getForeground());
                        graphics.fillRect(n, i, 20, 20);
                        n += 20;
                        bl = !bl;
                    }
                    n = 0;
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                return 50;
            }
            return (int)((float)((JViewport)container).getHeight() * 0.95f);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().height < ((JViewport)container).getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().width < ((JViewport)container).getWidth();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }
    }

    static abstract class InstanceBuilder<T> {
        InstanceBuilder(Instance instance, Heap heap) {
        }

        protected void setupInstance(T t) {
        }

        protected T createInstanceImpl() {
            return null;
        }

        final T createInstance() {
            T t = this.createInstanceImpl();
            if (t != null) {
                this.setupInstance(t);
            }
            return t;
        }
    }

    static final class JPopupMenuImpl
    extends JPopupMenu {
        JPopupMenuImpl() {
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public Component add(Component component) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            return super.add(component);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.repaint();
                }
            });
        }
    }

    static final class PlaceholderPanel
    extends JPanel {
        private static final Color LINE = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        private final JLabel label;

        PlaceholderPanel(String string) {
            super(null);
            this.putClientProperty("className", string);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(LINE));
            this.label = new JLabel(BrowserUtils.getSimpleType(string), 0);
            this.label.setOpaque(true);
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.label.getPreferredSize();
            int n = (dimension.width - dimension2.width) / 2;
            int n2 = (dimension.height - dimension2.height) / 2;
            this.label.setBounds(n, n2, dimension2.width, dimension2.height);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(LINE);
            graphics.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
            Point point = this.label.getLocation();
            graphics.translate(point.x, point.y);
            this.label.paint(graphics);
            graphics.translate(-point.x, -point.y);
        }
    }

    static final class PlaceholderIcon
    implements Icon {
        private final int width;
        private final int height;

        PlaceholderIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n, n2, this.width, this.height);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2, n + this.width - 1, n2 + this.height - 1);
            graphics.drawLine(n, n2 + this.height - 1, n + this.width - 1, n2);
        }
    }
}

