/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;

final class PackageAttrsCache
implements Stamps.Updater {
    private static final String NULL_REPLACEMENT = "\u0000";
    private static final String CACHE = "package-attrs.dat";
    private static final String[] EMPTY = new String[7];
    private static final Logger LOG = Logger.getLogger(PackageAttrsCache.class.getName());
    private static PackageAttrsCache packages;
    private final Map<String, String[]> cache;

    static void initialize() {
        packages = new PackageAttrsCache();
    }

    PackageAttrsCache() {
        InputStream inputStream = Stamps.getModulesJARs().asStream(CACHE);
        ConcurrentHashMap<String, String[]> concurrentHashMap = null;
        if (inputStream != null) {
            try {
                String string;
                concurrentHashMap = new ConcurrentHashMap<String, String[]>();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                while (!(string = Stamps.readRelativePath(dataInputStream)).isEmpty()) {
                    String[] stringArray = new String[7];
                    for (int i = 0; i < 7; ++i) {
                        stringArray[i] = PackageAttrsCache.fromSafeValue(dataInputStream.readUTF());
                    }
                    concurrentHashMap.put(string, stringArray);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Cannot read package-attrs.dat", iOException);
                concurrentHashMap = null;
            }
        }
        if (concurrentHashMap == null) {
            this.cache = new ConcurrentHashMap<String, String[]>();
            Stamps.getModulesJARs().scheduleSave(this, CACHE, false);
        } else {
            this.cache = Collections.unmodifiableMap(concurrentHashMap);
        }
    }

    static String[] findPackageAttrs(URL uRL, Manifest manifest, String string) {
        PackageAttrsCache packageAttrsCache = packages;
        return packageAttrsCache == null ? PackageAttrsCache.extractFromManifest(manifest, string) : packageAttrsCache.findImpl(uRL, manifest, string);
    }

    final String[] findImpl(URL uRL, Manifest manifest, String string) {
        String[] stringArray;
        String string2 = uRL.toExternalForm();
        if (string2.startsWith("jar:file:")) {
            string2 = string2.substring(9);
        }
        if (!string2.endsWith("!/")) {
            string2 = string2 + "!/";
        }
        string2 = string2 + string;
        if (this.cache instanceof ConcurrentHashMap) {
            stringArray = PackageAttrsCache.extractFromManifest(manifest, string);
            if (PackageAttrsCache.isEmpty(stringArray)) {
                stringArray = EMPTY;
            } else {
                this.cache.put(string2, stringArray);
            }
        } else {
            stringArray = this.cache.get(string2);
            if (stringArray == null) {
                stringArray = EMPTY;
            }
        }
        return stringArray;
    }

    @Override
    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        for (Map.Entry<String, String[]> entry : this.cache.entrySet()) {
            Stamps.writeRelativePath(entry.getKey(), dataOutputStream);
            for (String string : entry.getValue()) {
                dataOutputStream.writeUTF(PackageAttrsCache.toSafeValue(string));
            }
        }
        Stamps.writeRelativePath("", dataOutputStream);
    }

    @Override
    public void cacheReady() {
    }

    private static String getAttr(Attributes attributes, Attributes attributes2, Attributes.Name name) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null && attributes2 != null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    private static String[] extractFromManifest(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        Attributes attributes2 = manifest.getMainAttributes();
        String[] stringArray = new String[]{PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_TITLE), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VERSION), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VENDOR), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_TITLE), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VERSION), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VENDOR), PackageAttrsCache.getAttr(attributes, attributes2, Attributes.Name.SEALED)};
        return stringArray;
    }

    private static boolean isEmpty(String[] stringArray) {
        if (stringArray == EMPTY) {
            return true;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            return false;
        }
        return true;
    }

    private static String toSafeValue(String string) {
        return string == null ? NULL_REPLACEMENT : string;
    }

    private static String fromSafeValue(String string) {
        return NULL_REPLACEMENT.equals(string) ? null : string;
    }
}

