/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import org.netbeans.modules.openide.explorer.NodeOperationImpl;
import org.openide.explorer.propertysheet.CustomEditorAction;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class CustomEditorAccessorImpl
implements NodeOperationImpl.CustomEditorAccessor {
    static void register() {
        NodeOperationImpl.registerCustomEditorAccessor(new CustomEditorAccessorImpl());
    }

    private CustomEditorAccessorImpl() {
    }

    @Override
    public void showDialog(Node.Property property, Object[] objectArray) {
        new CustomEditorAction(new Invoker(property, objectArray)).actionPerformed(new ActionEvent(property, 1001, "invokeCustomEditor"));
    }

    private static class Invoker
    implements CustomEditorAction.Invoker {
        private Node.Property property;
        private Object[] beans;
        private ReusablePropertyEnv propertyEnv;

        Invoker(Node.Property property, Object[] objectArray) {
            this.property = property;
            this.beans = objectArray;
            this.propertyEnv = new ReusablePropertyEnv();
            ReusablePropertyModel reusablePropertyModel = new ReusablePropertyModel(this.propertyEnv);
            reusablePropertyModel.setProperty(property);
            this.propertyEnv.setNode(objectArray);
        }

        @Override
        public FeatureDescriptor getSelection() {
            return this.property;
        }

        @Override
        public Object getPartialValue() {
            return null;
        }

        @Override
        public Component getCursorChangeComponent() {
            return null;
        }

        @Override
        public String getBeanName() {
            if (this.beans instanceof Node[]) {
                Node[] nodeArray = (Node[])this.beans;
                StringBuilder stringBuilder = new StringBuilder();
                String string = NbBundle.getMessage(ProxyNode.class, (String)"CTL_List_Delimiter");
                for (int i = 0; i < nodeArray.length; ++i) {
                    stringBuilder.append(nodeArray[i].getDisplayName());
                    if (i >= nodeArray.length - 1) continue;
                    stringBuilder.append(string);
                    if (i < 2) continue;
                    stringBuilder.append(NbBundle.getMessage(ProxyNode.class, (String)"MSG_ELLIPSIS"));
                    break;
                }
                return stringBuilder.toString();
            }
            return null;
        }

        @Override
        public void editorOpening() {
        }

        @Override
        public void editorOpened() {
        }

        @Override
        public void editorClosed() {
        }

        @Override
        public void valueChanged(PropertyEditor propertyEditor) {
        }

        @Override
        public boolean allowInvoke() {
            return true;
        }

        @Override
        public void failed() {
        }

        @Override
        public boolean wantAllChanges() {
            return false;
        }

        @Override
        public ReusablePropertyEnv getReusablePropertyEnv() {
            return this.propertyEnv;
        }
    }
}

