/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ui.mac.foundation;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.ui.mac.foundation.FoundationLibrary;
import org.jetbrains.kotlin.com.intellij.ui.mac.foundation.ID;

public class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    private static final Map<String, Object> ourMainThreadRunnables;
    private static long ourCurrentRunnableCount;
    private static final Object RUNNABLE_LOCK;

    public static ID getObjcClass(String className2) {
        return myFoundationLibrary.objc_getClass(className2);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    @NotNull
    public static ID nsString(@Nullable String s) {
        ID iD = s == null ? ID.NIL : NSString.create(s);
        if (iD == null) {
            Foundation.$$$reportNull$$$0(2);
        }
        return iD;
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    static /* synthetic */ long access$000(long x0) {
        return Foundation.convertCFEncodingToNS(x0);
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        HashMap foundationOptions = new HashMap();
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class, foundationOptions);
        ourMainThreadRunnables = new HashMap<String, Object>();
        ourCurrentRunnableCount = 0L;
        RUNNABLE_LOCK = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ui/mac/foundation/Foundation";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ui/mac/foundation/Foundation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "nsString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointerReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "castPointerToNSError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAtPath";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nsUUID";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDict";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "castPointerToNSError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertTypes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NSString {
        private static final ID nsStringCls = Foundation.getObjcClass("NSString");
        private static final Pointer stringSel = Foundation.createSelector("string");
        private static final Pointer allocSel = Foundation.createSelector("alloc");
        private static final Pointer autoreleaseSel = Foundation.createSelector("autorelease");
        private static final Pointer initWithBytesLengthEncodingSel = Foundation.createSelector("initWithBytes:length:encoding:");
        private static final long nsEncodingUTF16LE = Foundation.access$000(0x14000100L);

        @NotNull
        public static ID create(@NotNull String s) {
            if (s == null) {
                NSString.$$$reportNull$$$0(0);
            }
            if (s.isEmpty()) {
                ID iD = Foundation.invoke(nsStringCls, stringSel, new Object[0]);
                if (iD == null) {
                    NSString.$$$reportNull$$$0(1);
                }
                return iD;
            }
            byte[] utf16Bytes = s.getBytes(CharsetToolkit.UTF_16LE_CHARSET);
            ID iD = Foundation.invoke(Foundation.invoke(Foundation.invoke(nsStringCls, allocSel, new Object[0]), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, nsEncodingUTF16LE), autoreleaseSel, new Object[0]);
            if (iD == null) {
                NSString.$$$reportNull$$$0(2);
            }
            return iD;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ui/mac/foundation/Foundation$NSString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ui/mac/foundation/Foundation$NSString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

