/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtilRt {
    public static void rethrowUnchecked(@Nullable Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtilRt.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtilRt.rethrow(t);
        }
    }
}

