/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.IOException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ModuleVersionIdentifierSerializer
implements Serializer<ModuleVersionIdentifier> {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleVersionIdentifierSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void write(Encoder encoder, ModuleVersionIdentifier value) throws IOException {
        encoder.writeString((CharSequence)value.getGroup());
        encoder.writeString((CharSequence)value.getName());
        encoder.writeString((CharSequence)value.getVersion());
    }

    public ModuleVersionIdentifier read(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String module = decoder.readString();
        String version = decoder.readString();
        return this.moduleIdentifierFactory.moduleWithVersion(group, module, version);
    }
}

