/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class Atom
extends P3
implements Cloneable {
    public int atomSetIndex;
    public int index;
    public BS bsSymmetry;
    public int atomSite;
    public String elementSymbol;
    public short elementNumber = (short)-1;
    public String atomName;
    public int formalCharge = Integer.MIN_VALUE;
    public float partialCharge = Float.NaN;
    public V3 vib;
    public float bfactor = Float.NaN;
    public float foccupancy = 1.0f;
    public float radius = Float.NaN;
    public boolean isHetero;
    public int atomSerial = Integer.MIN_VALUE;
    public int chainID;
    public char altLoc = '\u0000';
    public String group3;
    public int sequenceNumber = Integer.MIN_VALUE;
    public char insertionCode = '\u0000';
    public float[] anisoBorU;
    public Lst<Object> tensors;
    public boolean ignoreSymmetry;
    private static final int[] elementCharMasks;

    static {
        int[] nArray = new int[26];
        nArray[0] = 1972292;
        nArray[1] = -2147351151;
        nArray[2] = -2146019271;
        nArray[3] = -2130706430;
        nArray[4] = 0x160000;
        nArray[5] = -2147348464;
        nArray[6] = 25;
        nArray[7] = -2147205008;
        nArray[8] = -2147344384;
        nArray[10] = -2147352576;
        nArray[11] = 0x120101;
        nArray[12] = 548936;
        nArray[13] = -2147434213;
        nArray[14] = -2147221504;
        nArray[15] = -2145759221;
        nArray[17] = 1056947;
        nArray[18] = -2147339946;
        nArray[19] = -2147477097;
        nArray[20] = Integer.MIN_VALUE;
        nArray[21] = Integer.MIN_VALUE;
        nArray[22] = Integer.MIN_VALUE;
        nArray[23] = 0x800010;
        nArray[24] = -2147483646;
        nArray[25] = 139264;
        elementCharMasks = nArray;
    }

    public Tensor addTensor(Tensor tensor, String string, boolean bl) {
        if (tensor == null) {
            return null;
        }
        if (bl || this.tensors == null) {
            this.tensors = new Lst();
        }
        this.tensors.addLast(tensor);
        if (string != null) {
            tensor.setType(string);
        }
        return tensor;
    }

    public Atom() {
        this.set(Float.NaN, Float.NaN, Float.NaN);
    }

    public Atom getClone() throws CloneNotSupportedException {
        Atom atom = (Atom)this.clone();
        if (this.vib != null) {
            atom.vib = this.vib instanceof Vibration ? (Vibration)((Vibration)this.vib).clone() : V3.newV(atom.vib);
        }
        if (this.anisoBorU != null) {
            atom.anisoBorU = AU.arrayCopyF(this.anisoBorU, -1);
        }
        if (this.tensors != null) {
            atom.tensors = new Lst();
            int n = this.tensors.size();
            while (--n >= 0) {
                atom.tensors.addLast(((Tensor)this.tensors.get(n)).copyTensor());
            }
        }
        return atom;
    }

    public String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int n = this.atomName.length();
            int n2 = 0;
            char c = '\u0000';
            while (n2 < n && !Atom.isValidSymChar1(c = this.atomName.charAt(n2))) {
                ++n2;
            }
            switch (n - n2) {
                case 0: {
                    break;
                }
                default: {
                    char c2 = this.atomName.charAt(n2 + 1);
                    if (Atom.isValidSymNoCase(c, c2)) {
                        this.elementSymbol = "" + c + c2;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidSym1(c)) break;
                    this.elementSymbol = "" + c;
                }
            }
        }
        return this.elementSymbol;
    }

    public static boolean isValidSym1(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] < 0;
    }

    public static boolean isValidSym2(char c, char c2) {
        return c >= 'A' && c <= 'Z' && c2 >= 'a' && c2 <= 'z' && (elementCharMasks[c - 65] >> c2 - 97 & 1) != 0;
    }

    public static boolean isValidSymNoCase(char c, char c2) {
        return Atom.isValidSym2(c, c2 < 'a' ? (char)(c2 + 32) : c2);
    }

    private static boolean isValidSymChar1(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] != 0;
    }
}

