/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;

public class JosmTextArea
extends JTextArea
implements FocusListener {
    public JosmTextArea() {
        this(null, null, 0, 0);
    }

    public JosmTextArea(String text) {
        this(null, text, 0, 0);
    }

    public JosmTextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public JosmTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public JosmTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public JosmTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        TextContextualPopupMenu.enableMenuFor(this, true);
        this.addFocusListener(this);
    }

    public JosmTextArea transferFocusOnTab() {
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        return this;
    }

    @Override
    public void focusGained(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(true);
        }
    }
}

