/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    public static final long CACHED_IMAGE_MAX_SIZE = (long)(Registry.doubleValue("ide.cached.image.max.size") * 1024.0 * 1024.0);
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    private static LoadFunction measureLoad;
    public static final Component ourComponent;

    public static void clearCache() {
        ourCache.clear();
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, final boolean allowFloatScaling, boolean useCache, boolean dark, ImageFilter[] filters, final JBUI.ScaleContext ctx) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        return ImageDescList.create(url.toString(), null, dark, allowFloatScaling, ctx).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && desc.type != ImageDesc.Type.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(ctx), useCache);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUI.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(Image image, double scale) {
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(4);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(5);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(6);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, double scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(21);
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream2 = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream2.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream2.getInternalBuffer(), 0, outputStream2.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    static {
        ourComponent = new Component(){};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scaleImage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadFromBytes";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        ImageConverterChain withFilter(ImageFilter[] filters) {
            if (filters == null) {
                return this;
            }
            ImageConverterChain chain = this;
            for (ImageFilter filter2 : filters) {
                chain = chain.withFilter(filter2);
            }
            return chain;
        }

        ImageConverterChain withFilter(final ImageFilter filter2) {
            if (filter2 == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter2);
                }
            });
        }

        ImageConverterChain withHiDPI(final JBUI.ScaleContext ctx) {
            if (ctx == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.ensureHiDPI(source, ctx);
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters, boolean useCache) {
            if (converters == null) {
                ImageDescList.$$$reportNull$$$0(1);
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load(useCache);
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String path2, @Nullable Class cls, boolean dark, boolean allowFloatScaling, JBUI.ScaleContext ctx) {
            if (path2 == null) {
                ImageDescList.$$$reportNull$$$0(2);
            }
            boolean retina = JBUI.isHiDPI(ctx.getScale(JBUI.ScaleType.PIX_SCALE));
            Builder list2 = new Builder(FileUtil.getNameWithoutExtension(path2), FileUtilRt.getExtension(path2), cls, Registry.is("ide.svg.icon"), ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE)));
            if (path2.contains("://") && !path2.startsWith("file:")) {
                list2.add(StringUtil.endsWithIgnoreCase(path2, ".svg") ? ImageDesc.Type.SVG : ImageDesc.Type.IMG);
            } else if (retina && dark) {
                list2.add(true, true);
                list2.add(true, false);
            } else if (dark) {
                list2.add(false, true);
                list2.add(false, false);
            } else if (retina) {
                list2.add(true, false);
            } else {
                list2.add(false, false);
            }
            return list2.build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ImageLoader$ImageDescList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class Builder {
            final ImageDescList list = new ImageDescList();
            final String name;
            final String ext;
            final Class cls;
            final boolean svg;
            final double scale;

            Builder(String name, String ext, Class cls, boolean svg, double scale) {
                this.name = name;
                this.ext = ext;
                this.cls = cls;
                this.svg = svg;
                this.scale = scale;
            }

            void add(boolean retina, boolean dark) {
                if (this.svg) {
                    this.add(retina, dark, ImageDesc.Type.SVG);
                }
                this.add(retina, dark, ImageDesc.Type.IMG);
            }

            void add(boolean retina, boolean dark, ImageDesc.Type type2) {
                String _ext;
                String string = _ext = ImageDesc.Type.SVG == type2 ? "svg" : this.ext;
                double _scale = ImageDesc.Type.SVG == type2 ? this.scale : (retina ? 2.0 : 1.0);
                this.list.add(new ImageDesc(this.name + (dark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, this.cls, _scale, type2));
                if (retina && dark) {
                    this.list.add(new ImageDesc(this.name + "@2x_dark." + _ext, this.cls, _scale, type2));
                }
                if (retina) {
                    this.list.add(new ImageDesc(this.name + (dark ? "_dark" : "") + "." + _ext, this.cls, ImageDesc.Type.SVG == type2 ? this.scale : 1.0, type2));
                }
            }

            void add(ImageDesc.Type type2) {
                this.list.add(new ImageDesc(this.name + "." + this.ext, this.cls, 1.0, type2, true));
            }

            ImageDescList build() {
                return this.list;
            }
        }
    }

    public static class ImageDesc {
        final String path;
        final Class cls;
        final double scale;
        final Type type;
        final boolean original;

        /*
         * WARNING - void declaration
         */
        ImageDesc(@NotNull String path2, @Nullable Class cls, double scale, @NotNull Type type2) {
            void type3;
            if (path2 == null) {
                ImageDesc.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                ImageDesc.$$$reportNull$$$0(1);
            }
            this(path2, cls, scale, (Type)type3, false);
        }

        /*
         * WARNING - void declaration
         */
        ImageDesc(@NotNull String path2, @Nullable Class cls, double scale, @NotNull Type type2, boolean bl) {
            void original;
            if (path2 == null) {
                ImageDesc.$$$reportNull$$$0(2);
            }
            if (type2 == null) {
                ImageDesc.$$$reportNull$$$0(3);
            }
            this.path = path2;
            this.cls = cls;
            this.scale = scale;
            this.type = type2;
            this.original = original;
        }

        @Nullable
        public Image load(boolean useCache) throws IOException {
            Image image;
            InputStream stream2 = null;
            if (this.cls != null && (stream2 = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            String cacheKey = null;
            URL url = null;
            if (stream2 == null) {
                URLConnection connection;
                if (useCache) {
                    cacheKey = this.path + (this.type == Type.SVG ? "_@" + this.scale + "x" : "");
                    image = (Image)ourCache.get(cacheKey);
                    if (image != null) {
                        return image;
                    }
                }
                if ((connection = (url = new URL(this.path)).openConnection()) instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream2 = connection.getInputStream();
            }
            if ((image = this.loadImpl(url, stream2, this.scale)) != null && cacheKey != null && (long)(image.getWidth(null) * image.getHeight(null) * 4) <= CACHED_IMAGE_MAX_SIZE) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        Image loadImpl(final URL url, final InputStream stream2, final double scale) throws IOException {
            LoadFunction f = new LoadFunction(){

                @Override
                public Image load(@Nullable LoadFunction delegate, @NotNull Type type2) throws IOException {
                    if (type2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    switch (type2) {
                        case SVG: {
                            return SVGLoader.load(url, stream2, ImageDesc.this.scale);
                        }
                        case IMG: {
                            return ImageLoader.load(stream2, scale);
                        }
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/ImageLoader$ImageDesc$1", "load"));
                }
            };
            if (measureLoad != null) {
                return measureLoad.load(f, this.type);
            }
            return f.load(null, this.type);
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/ImageLoader$ImageDesc";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Type {
            IMG,
            SVG;

        }
    }

    public static interface LoadFunction {
        public Image load(@Nullable LoadFunction var1, @NotNull ImageDesc.Type var2) throws IOException;
    }
}

