/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilerPhase;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020!J6\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0$H\u0002R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR#\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR#\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR#\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004j\u0002`\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/CompilerPhases;", "", "phaseList", "", "Lorg/jetbrains/kotlin/backend/common/CompilerPhase;", "Lorg/jetbrains/kotlin/backend/common/AnyPhase;", "config", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Ljava/util/List;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "enabled", "", "getEnabled", "()Ljava/util/Set;", "phases", "", "", "", "getPhases", "()Ljava/util/Map;", "toDumpStateAfter", "getToDumpStateAfter", "toDumpStateBefore", "getToDumpStateBefore", "toValidateStateAfter", "getToValidateStateAfter", "toValidateStateBefore", "getToValidateStateBefore", "verbose", "getVerbose", "computeEnabled", "known", "name", "list", "", "phaseSetFromConfiguration", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "ir.backend.common"})
public final class CompilerPhases {
    @NotNull
    private final Map<String, CompilerPhase<?, ? extends Object>> phases;
    @NotNull
    private final Set<CompilerPhase<?, ?>> enabled;
    @NotNull
    private final Set<CompilerPhase<?, ?>> verbose;
    @NotNull
    private final Set<CompilerPhase<?, ?>> toDumpStateBefore;
    @NotNull
    private final Set<CompilerPhase<?, ?>> toDumpStateAfter;
    @NotNull
    private final Set<CompilerPhase<?, ?>> toValidateStateBefore;
    @NotNull
    private final Set<CompilerPhase<?, ?>> toValidateStateAfter;
    private final List<CompilerPhase<?, ?>> phaseList;

    @NotNull
    public final Map<String, CompilerPhase<?, ? extends Object>> getPhases() {
        return this.phases;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getToDumpStateBefore() {
        return this.toDumpStateBefore;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getToDumpStateAfter() {
        return this.toDumpStateAfter;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getToValidateStateBefore() {
        return this.toValidateStateBefore;
    }

    @NotNull
    public final Set<CompilerPhase<?, ?>> getToValidateStateAfter() {
        return this.toValidateStateAfter;
    }

    @NotNull
    public final String known(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (this.phases.get(name) == null) {
            String string = "Unknown phase: " + name + ". Use -Xlist-phases to see the list of phases.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return name;
    }

    public final void list() {
        Iterable $receiver$iv = this.phaseList;
        for (Object element$iv : $receiver$iv) {
            CompilerPhase phase = (CompilerPhase)element$iv;
            String enabled = this.enabled.contains(phase) ? "(Enabled)" : "";
            String verbose = this.verbose.contains(phase) ? "(Verbose)" : "";
            Object object = StringCompanionObject.INSTANCE;
            String string = "%1$-30s %2$-50s %3$-10s";
            Object[] objectArray = new Object[]{phase.getName() + ':', phase.getDescription(), enabled + ' ' + verbose};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(format, *args)");
            object = string2;
            System.out.println(object);
        }
    }

    private final Set<CompilerPhase<?, ?>> computeEnabled(CompilerConfiguration config) {
        CommonConfigurationKeys commonConfigurationKeys;
        CommonConfigurationKeys $receiver = commonConfigurationKeys = CommonConfigurationKeys.INSTANCE;
        Set<CompilerPhase<?, ?>> disabledPhases = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.DISABLED_PHASES);
        return SetsKt.minus(CollectionsKt.toSet((Iterable)this.phases.values()), (Iterable)disabledPhases);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CompilerPhase<?, ?>> phaseSetFromConfiguration(CompilerConfiguration config, CompilerConfigurationKey<Set<String>> key) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Set<String> phaseNames;
        Set<String> set = config.get(key);
        if (set == null) {
            set = phaseNames = SetsKt.emptySet();
        }
        if (phaseNames.contains("ALL")) {
            return CollectionsKt.toSet((Iterable)this.phases.values());
        }
        Iterable iterable = $receiver$iv = (Iterable)phaseNames;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            CompilerPhase<?, ? extends Object> compilerPhase;
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (this.phases.get(it) == null) {
                Intrinsics.throwNpe();
            }
            collection.add(compilerPhase);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public CompilerPhases(@NotNull List<? extends CompilerPhase<?, ?>> phaseList, @NotNull CompilerConfiguration config) {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(phaseList, "phaseList");
        Intrinsics.checkParameterIsNotNull(config, "config");
        this.phaseList = phaseList;
        Object object = this.phaseList;
        CompilerPhases compilerPhases = this;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        void var5_7 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map3 = destination$iv$iv;
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            Pair<String, CompilerPhase> pair = TuplesKt.to(it.getName(), it);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        compilerPhases.phases = map2 = destination$iv$iv;
        this.enabled = this.computeEnabled(config);
        this.verbose = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.VERBOSE_PHASES);
        Object $receiver = object = CommonConfigurationKeys.INSTANCE;
        Set<CompilerPhase<?, ?>> beforeDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE_BEFORE);
        Set<CompilerPhase<?, ?>> afterDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE_AFTER);
        Set<CompilerPhase<?, ?>> bothDumpSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_DUMP_STATE);
        this.toDumpStateBefore = SetsKt.plus(beforeDumpSet, (Iterable)bothDumpSet);
        this.toDumpStateAfter = SetsKt.plus(afterDumpSet, (Iterable)bothDumpSet);
        Set<CompilerPhase<?, ?>> beforeValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE_BEFORE);
        Set<CompilerPhase<?, ?>> afterValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE_AFTER);
        Set<CompilerPhase<?, ?>> bothValidateSet = this.phaseSetFromConfiguration(config, CommonConfigurationKeys.PHASES_TO_VALIDATE);
        this.toValidateStateBefore = SetsKt.plus(beforeValidateSet, (Iterable)bothValidateSet);
        this.toValidateStateAfter = SetsKt.plus(afterValidateSet, (Iterable)bothValidateSet);
    }
}

