"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var notify_1 = require("./features/notify");
var profiling_1 = require("./features/profiling");
var eventLoopInspector_1 = require("./features/eventLoopInspector");
var events_1 = require("./features/events");
var metrics_1 = require("./features/metrics");
var Debug = require("debug");
var tracing_1 = require("./features/tracing");
function getObjectAtPath(context, path) {
    if (path.indexOf('.') === -1 && path.indexOf('[') === -1) {
        return context[path];
    }
    var crumbs = path.split(/\.|\[|\]/g);
    var i = -1;
    var len = crumbs.length;
    var result;
    while (++i < len) {
        if (i === 0)
            result = context;
        if (!crumbs[i])
            continue;
        if (result === undefined)
            break;
        result = result[crumbs[i]];
    }
    return result;
}
exports.getObjectAtPath = getObjectAtPath;
var AvailableFeature = (function () {
    function AvailableFeature() {
    }
    return AvailableFeature;
}());
var availablesFeatures = [
    {
        name: 'notify',
        optionsPath: '.',
        module: notify_1.NotifyFeature
    },
    {
        name: 'profiler',
        optionsPath: 'profiling',
        module: profiling_1.ProfilingFeature
    },
    {
        name: 'eventLoopInspector',
        optionsPath: 'actions.eventLoopDump',
        module: eventLoopInspector_1.EventLoopInspectorFeature
    },
    {
        name: 'events',
        module: events_1.EventsFeature
    },
    {
        name: 'metrics',
        optionsPath: 'metrics',
        module: metrics_1.MetricsFeature
    },
    {
        name: 'tracing',
        optionsPath: 'tracing',
        module: tracing_1.TracingFeature
    }
];
var FeatureManager = (function () {
    function FeatureManager() {
        this.logger = Debug('axm:features');
    }
    FeatureManager.prototype.init = function (options) {
        var e_1, _a;
        try {
            for (var availablesFeatures_1 = tslib_1.__values(availablesFeatures), availablesFeatures_1_1 = availablesFeatures_1.next(); !availablesFeatures_1_1.done; availablesFeatures_1_1 = availablesFeatures_1.next()) {
                var availableFeature = availablesFeatures_1_1.value;
                this.logger("Creating feature " + availableFeature.name);
                var feature = new availableFeature.module();
                var config = undefined;
                if (typeof availableFeature.optionsPath !== 'string') {
                    config = {};
                }
                else if (availableFeature.optionsPath === '.') {
                    config = options;
                }
                else {
                    config = getObjectAtPath(options, availableFeature.optionsPath);
                }
                this.logger("Init feature " + availableFeature.name);
                feature.init(config);
                availableFeature.instance = feature;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (availablesFeatures_1_1 && !availablesFeatures_1_1.done && (_a = availablesFeatures_1.return)) _a.call(availablesFeatures_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    FeatureManager.prototype.get = function (name) {
        var feature = availablesFeatures.find(function (feature) { return feature.name === name; });
        if (feature === undefined || feature.instance === undefined) {
            throw new Error("Tried to call feature " + name + " which doesn't exist or wasn't initiated");
        }
        return feature.instance;
    };
    FeatureManager.prototype.destroy = function () {
        var e_2, _a;
        try {
            for (var availablesFeatures_2 = tslib_1.__values(availablesFeatures), availablesFeatures_2_1 = availablesFeatures_2.next(); !availablesFeatures_2_1.done; availablesFeatures_2_1 = availablesFeatures_2.next()) {
                var availableFeature = availablesFeatures_2_1.value;
                if (availableFeature.instance === undefined)
                    continue;
                this.logger("Destroy feature " + availableFeature.name);
                availableFeature.instance.destroy();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (availablesFeatures_2_1 && !availablesFeatures_2_1.done && (_a = availablesFeatures_2.return)) _a.call(availablesFeatures_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return FeatureManager;
}());
exports.FeatureManager = FeatureManager;
var FeatureConfig = (function () {
    function FeatureConfig() {
    }
    return FeatureConfig;
}());
exports.FeatureConfig = FeatureConfig;
//# sourceMappingURL=data:application/json;base64,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