/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.ShapeTools;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.JTextComponent;

public class SwingTools {
    private static Border unfocusedViewBorder;
    private static Border focusedViewBorder;
    private static Map<TextureImage, BufferedImage> patternImages;
    private static Float defaultResolutionScale;

    private SwingTools() {
    }

    public static void installFocusBorder(JComponent jComponent) {
        Serializable serializable;
        if (unfocusedViewBorder == null) {
            serializable = new AbstractBorder(){
                private Color topLeftColor;
                private Color botomRightColor;
                private Insets insets = new Insets(1, 1, 1, 1);
                {
                    if (OperatingSystem.isMacOSX()) {
                        this.topLeftColor = Color.GRAY;
                        this.botomRightColor = Color.LIGHT_GRAY;
                    } else {
                        this.topLeftColor = UIManager.getColor("TextField.darkShadow");
                        this.botomRightColor = UIManager.getColor("TextField.shadow");
                    }
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return this.insets;
                }

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    Color color = graphics.getColor();
                    Rectangle rectangle = this.getInteriorRectangle(component, n, n2, n3, n4);
                    graphics.setColor(this.topLeftColor);
                    graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x + rectangle.width, rectangle.y - 1);
                    graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height);
                    graphics.setColor(this.botomRightColor);
                    graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                    graphics.setColor(color);
                }
            };
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                unfocusedViewBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Panel.background"), 2), (Border)((Object)serializable));
                focusedViewBorder = new AbstractBorder(){
                    private Insets insets = new Insets(3, 3, 3, 3);

                    @Override
                    public Insets getBorderInsets(Component component) {
                        return this.insets;
                    }

                    @Override
                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        Color color = graphics.getColor();
                        Rectangle rectangle = this.getInteriorRectangle(component, n, n2, n3, n4);
                        graphics.setColor(Color.GRAY);
                        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x + rectangle.width, rectangle.y - 1);
                        graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height);
                        graphics.setColor(Color.LIGHT_GRAY);
                        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                        Color color2 = UIManager.getColor("Focus.color");
                        int n5 = 128;
                        int n6 = 180;
                        if (color2 == null) {
                            color2 = UIManager.getColor("textHighlight");
                            n5 = 128;
                            n6 = 255;
                        }
                        graphics.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n5));
                        graphics.drawRoundRect(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5, 6, 6);
                        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        graphics.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n6));
                        graphics.drawRoundRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3, 4, 4);
                        graphics.setColor(UIManager.getColor("Panel.background"));
                        graphics.drawLine(rectangle.x - 3, rectangle.y - 3, rectangle.x - 2, rectangle.y - 3);
                        graphics.drawLine(rectangle.x - 3, rectangle.y - 2, rectangle.x - 3, rectangle.y - 2);
                        graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y - 3, rectangle.x + rectangle.width + 2, rectangle.y - 3);
                        graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y - 2, rectangle.x + rectangle.width + 2, rectangle.y - 2);
                        graphics.drawLine(rectangle.x - 3, rectangle.y + rectangle.height + 2, rectangle.x - 2, rectangle.y + rectangle.height + 2);
                        graphics.drawLine(rectangle.x - 3, rectangle.y + rectangle.height + 1, rectangle.x - 3, rectangle.y + rectangle.height + 1);
                        graphics.drawLine(rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height + 2, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 2);
                        graphics.drawLine(rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 1, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 1);
                        graphics.setColor(color);
                    }
                };
            } else {
                unfocusedViewBorder = OperatingSystem.isMacOSX() ? BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Panel.background"), 1), (Border)((Object)serializable)) : BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), (Border)((Object)serializable));
                focusedViewBorder = BorderFactory.createLineBorder(UIManager.getColor("textHighlight"), 2);
            }
        }
        serializable = jComponent.getParent() instanceof JViewport && jComponent.getParent().getParent() instanceof JScrollPane ? (JComponent)jComponent.getParent().getParent() : jComponent;
        ((JComponent)serializable).setBorder(unfocusedViewBorder);
        jComponent.addFocusListener(new FocusListener((JComponent)serializable){
            final /* synthetic */ JComponent val$feedbackComponent;
            {
                this.val$feedbackComponent = jComponent;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (this.val$feedbackComponent.getBorder() == focusedViewBorder) {
                    this.val$feedbackComponent.setBorder(unfocusedViewBorder);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (this.val$feedbackComponent.getBorder() == unfocusedViewBorder) {
                    this.val$feedbackComponent.setBorder(focusedViewBorder);
                }
            }
        });
    }

    public static void updateSwingResourceLanguage() {
        SwingTools.updateSwingResourceLanguage(Arrays.asList(SwingTools.class.getClassLoader()), null);
    }

    public static void updateSwingResourceLanguage(UserPreferences userPreferences) {
        SwingTools.updateSwingResourceLanguage(userPreferences.getResourceClassLoaders(), userPreferences.getLanguage());
    }

    private static void updateSwingResourceLanguage(List<ClassLoader> list, String string) {
        UIManager.getDefaults().removeResourceBundle(null);
        UIManager.getDefaults().setDefaultLocale(Locale.getDefault());
        SwingTools.updateSwingResourceBundle("com.sun.swing.internal.plaf.metal.resources.metal", list, string);
        SwingTools.updateSwingResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic", list, string);
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            SwingTools.updateSwingResourceBundle("com.sun.java.swing.plaf.gtk.resources.gtk", list, string);
        } else if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            SwingTools.updateSwingResourceBundle("com.sun.java.swing.plaf.motif.resources.motif", list, string);
        }
    }

    private static void updateSwingResourceBundle(String string, List<ClassLoader> list, String string2) {
        Object object;
        Object object3;
        try {
            Locale locale = string2 == null ? Locale.getDefault() : (string2.indexOf(95) == -1 ? new Locale(string2) : new Locale(string2.substring(0, 2), string2.substring(3, 5)));
            object3 = ResourceBundle.getBundle(string, locale);
            for (ClassLoader object22 : list) {
                object = ResourceBundle.getBundle(string, locale, object22);
                if (locale.equals(((ResourceBundle)object).getLocale())) {
                    object3 = object;
                    break;
                }
                if (((ResourceBundle)object3).getLocale().getLanguage().equals(((ResourceBundle)object).getLocale().getLanguage()) || !locale.getLanguage().equals(((ResourceBundle)object).getLocale().getLanguage())) continue;
                object3 = object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            object3 = ResourceBundle.getBundle(string, Locale.ENGLISH);
        }
        Enumeration<String> enumeration = ((ResourceBundle)object3).getKeys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.endsWith(".textAndMnemonic")) continue;
            object = ((ResourceBundle)object3).getString(string3);
            UIManager.put(string3, object);
            String string4 = ((String)object).replace("&", "");
            String string5 = string3.substring(0, string3.length() - ".textAndMnemonic".length());
            UIManager.put(string5 + "NameText", string4);
            UIManager.put(string5 + "Text", string4);
            int n = ((String)object).indexOf(38);
            if (n < 0 || n >= ((String)object).length() - 1) continue;
            UIManager.put(string3.replace(".textAndMnemonic", "Mnemonic"), String.valueOf(Character.toUpperCase(((String)object).charAt(n + 1))));
        }
        enumeration = ((ResourceBundle)object3).getKeys();
        while (enumeration.hasMoreElements()) {
            String string6 = enumeration.nextElement();
            if (string6.endsWith(".textAndMnemonic")) continue;
            UIManager.put(string6, ((ResourceBundle)object3).getString(string6));
        }
    }

    public static String getLocalizedLabelText(UserPreferences userPreferences, Class<?> clazz, String string, Object ... objectArray) {
        char c;
        int n;
        int n2;
        String string2 = userPreferences.getLocalizedString(clazz, string, objectArray);
        String string3 = Locale.getDefault().getLanguage();
        if (OperatingSystem.isMacOSX() && (string3.equals(Locale.CHINESE.getLanguage()) || string3.equals(Locale.JAPANESE.getLanguage()) || string3.equals(Locale.KOREAN.getLanguage()) || string3.equals("uk")) && (n2 = string2.indexOf(40)) != -1 && n2 == (n = string2.indexOf(41)) - 2 && (c = string2.charAt(n2 + 1)) >= 'A' && c <= 'Z') {
            string2 = string2.substring(0, n2) + string2.substring(n + 1);
        }
        return string2;
    }

    public static void addAutoSelectionOnFocusGain(JTextComponent jTextComponent) {
        class SelectionOnFocusManager
        extends MouseAdapter
        implements FocusListener {
            private boolean mousePressedInTextField = false;
            private int selectionStartBeforeFocusLost = -1;
            private int selectionEndBeforeFocusLost = -1;
            final /* synthetic */ JTextComponent val$textComponent;

            SelectionOnFocusManager(JTextComponent jTextComponent) {
                this.val$textComponent = jTextComponent;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.mousePressedInTextField = true;
                this.selectionStartBeforeFocusLost = -1;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() == null || SwingUtilities.getWindowAncestor(focusEvent.getOppositeComponent()) != SwingUtilities.getWindowAncestor(this.val$textComponent)) {
                    this.selectionStartBeforeFocusLost = this.val$textComponent.getSelectionStart();
                    this.selectionEndBeforeFocusLost = this.val$textComponent.getSelectionEnd();
                } else {
                    this.selectionStartBeforeFocusLost = -1;
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (this.selectionStartBeforeFocusLost != -1) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            val$textComponent.setSelectionStart(selectionStartBeforeFocusLost);
                            val$textComponent.setSelectionEnd(selectionEndBeforeFocusLost);
                        }
                    });
                } else if (!this.mousePressedInTextField && focusEvent.getOppositeComponent() != null && SwingUtilities.getWindowAncestor(focusEvent.getOppositeComponent()) == SwingUtilities.getWindowAncestor(this.val$textComponent)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            val$textComponent.selectAll();
                        }
                    });
                }
                this.mousePressedInTextField = false;
            }
        }
        SelectionOnFocusManager selectionOnFocusManager = new SelectionOnFocusManager(jTextComponent);
        jTextComponent.addFocusListener(selectionOnFocusManager);
        jTextComponent.addMouseListener(selectionOnFocusManager);
    }

    public static void deselectAllRadioButtons(JRadioButton ... jRadioButtonArray) {
        for (JRadioButton jRadioButton : jRadioButtonArray) {
            if (jRadioButton == null) continue;
            ButtonGroup buttonGroup = ((JToggleButton.ToggleButtonModel)jRadioButton.getModel()).getGroup();
            buttonGroup.remove(jRadioButton);
            jRadioButton.setSelected(false);
            buttonGroup.add(jRadioButton);
        }
    }

    public static int showConfirmDialog(JComponent jComponent, JComponent jComponent2, String string, final JComponent jComponent3) {
        JOptionPane jOptionPane = new JOptionPane(jComponent2, -1, 2);
        if ((jComponent = SwingUtilities.getRootPane(jComponent)) != null) {
            jOptionPane.setComponentOrientation(jComponent.getComponentOrientation());
        }
        final JDialog jDialog = jOptionPane.createDialog(jComponent, string);
        if (jComponent3 != null) {
            jDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    SwingTools.requestFocusInWindow(jComponent3);
                    jDialog.removeComponentListener(this);
                }
            });
        }
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = jOptionPane.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    public static void requestFocusInWindow(final JComponent jComponent) {
        if (!jComponent.requestFocusInWindow()) {
            new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jComponent.requestFocusInWindow();
                    ((Timer)actionEvent.getSource()).stop();
                }
            }).start();
        }
    }

    public static void showMessageDialog(JComponent jComponent, JComponent jComponent2, String string, int n, final JComponent jComponent3) {
        JOptionPane jOptionPane = new JOptionPane(jComponent2, n, -1);
        if ((jComponent = SwingUtilities.getRootPane(jComponent)) != null) {
            jOptionPane.setComponentOrientation(jComponent.getComponentOrientation());
        }
        final JDialog jDialog = jOptionPane.createDialog(jComponent, string);
        if (jComponent3 != null) {
            jDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    SwingTools.requestFocusInWindow(jComponent3);
                    jDialog.removeComponentListener(this);
                }
            });
        }
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public static int showOptionDialog(Component component, String string, String string2, int n, int n2, Object[] objectArray, Object object) {
        Font font;
        if (SwingTools.getResolutionScale() > 1.0f && string.indexOf("<font size=\"-2\">") != -1 && (font = UIManager.getFont("OptionPane.font")) != null) {
            string = string.replace("<font size=\"-2\">", "<font size=\"" + Math.round((float)font.getSize() / 5.0f) + "\">");
        }
        return JOptionPane.showOptionDialog(component, string, string2, n, n2, null, objectArray, object);
    }

    public static BufferedImage getPatternImage(TextureImage textureImage, Color color, Color color2) {
        if (patternImages == null) {
            patternImages = new HashMap<TextureImage, BufferedImage>();
        }
        BufferedImage bufferedImage = new BufferedImage((int)textureImage.getWidth(), (int)textureImage.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = patternImages.get(textureImage);
        if (bufferedImage2 == null) {
            try {
                InputStream inputStream = textureImage.getImage().openStream();
                bufferedImage2 = ImageIO.read(inputStream);
                inputStream.close();
                patternImages.put(textureImage, bufferedImage2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Can't read pattern image " + textureImage.getName());
            }
        }
        final int n = color2.getRGB() & 0xFFFFFF;
        graphics2D.drawImage(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bufferedImage2.getSource(), new RGBImageFilter(){
            {
                this.canFilterIndexColorModel = true;
            }

            @Override
            public int filterRGB(int n4, int n2, int n3) {
                return n3 & 0xFF000000 | n;
            }
        })), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Border getDropableComponentBorder() {
        Border border = null;
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            border = UIManager.getBorder("InsetBorder.aquaVariant");
        }
        if (border == null) {
            border = BorderFactory.createLoweredBevelBorder();
        }
        return border;
    }

    public static void showSplashScreenWindow(URL uRL) {
        try {
            final BufferedImage bufferedImage = ImageIO.read(uRL);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            final float f = OperatingSystem.isMacOSX() ? 1.0f : (float)Math.min(2.0, Math.max(1.0, Math.min(dimension.getWidth() / 5.0 / (double)bufferedImage.getWidth(), dimension.getHeight() / 5.0 / (double)bufferedImage.getHeight())));
            final Window window = new Window(new Frame()){

                @Override
                public void paint(Graphics graphics) {
                    ((Graphics2D)graphics).scale(f, f);
                    graphics.drawImage(bufferedImage, 0, 0, this);
                }
            };
            window.setSize((int)((float)bufferedImage.getWidth() * f), (int)((float)bufferedImage.getHeight() * f));
            window.setLocationRelativeTo(null);
            window.setVisible(true);
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        while (window.isVisible()) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        for (Window window : (Window[])Window.class.getMethod("getWindows", new Class[0]).invoke(null, new Object[0])) {
                                            if (!(window instanceof JFrame) && !(window instanceof JDialog) || !window.isShowing()) continue;
                                            window.dispose();
                                            break;
                                        }
                                    }
                                    catch (Exception exception) {
                                        for (Frame frame : Frame.getFrames()) {
                                            if (!frame.isShowing()) continue;
                                            window.dispose();
                                            break;
                                        }
                                    }
                                }
                            });
                            Thread.sleep(200L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                window.dispose();
                            }
                        });
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JPanel createTitledPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        AbstractBorder abstractBorder = BorderFactory.createTitledBorder(string);
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            abstractBorder = BorderFactory.createCompoundBorder(abstractBorder, BorderFactory.createEmptyBorder(0, 2, 2, 2));
        } else if (OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
            abstractBorder = BorderFactory.createCompoundBorder(abstractBorder, BorderFactory.createEmptyBorder(10, 0, 0, 0));
        }
        jPanel.setBorder(abstractBorder);
        return jPanel;
    }

    public static JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        if (OperatingSystem.isMacOSX()) {
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
        }
        SwingTools.installFocusBorder(jComponent);
        jScrollPane.setMinimumSize(new Dimension());
        return jScrollPane;
    }

    public static AdjustmentListener createAdjustmentListenerUpdatingScrollPaneViewToolTip(final JScrollPane jScrollPane) {
        return new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                Point point2 = new Point(point);
                Component component = jScrollPane.getViewport().getView();
                SwingUtilities.convertPointFromScreen(point2, component);
                if (jScrollPane.isShowing() && jScrollPane.getViewport().getViewRect().contains(point2)) {
                    MouseEvent mouseEvent = new MouseEvent(component, 503, System.currentTimeMillis(), 0, point2.x, point2.y, 0, false, 0);
                    if (SwingTools.isToolTipShowing()) {
                        ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
                    }
                }
            }
        };
    }

    public static boolean isToolTipShowing() {
        for (Frame frame : Frame.getFrames()) {
            if (!SwingTools.isToolTipShowing(frame)) continue;
            return true;
        }
        return false;
    }

    private static boolean isToolTipShowing(Container container) {
        if (container instanceof Window) {
            for (Window window : ((Window)container).getOwnedWindows()) {
                if (!SwingTools.isToolTipShowing(window)) continue;
                return true;
            }
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if ((!(component instanceof JToolTip) || !component.isShowing()) && (!(component instanceof Container) || !SwingTools.isToolTipShowing((Container)component))) continue;
            return true;
        }
        return false;
    }

    public static void hideDisabledMenuItems(JPopupMenu jPopupMenu) {
        jPopupMenu.addPopupMenuListener(new MenuItemsVisibilityListener());
    }

    public static boolean showDocumentInBrowser(URL uRL) {
        return BrowserSupport.showDocumentInBrowser(uRL);
    }

    public static <T extends Component> List<T> findChildren(JComponent jComponent, Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        SwingTools.findChildren(jComponent, clazz, arrayList);
        return arrayList;
    }

    private static <T extends Component> void findChildren(JComponent jComponent, Class<T> clazz, List<T> list) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (clazz.isInstance(component)) {
                list.add(component);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            SwingTools.findChildren((JComponent)component, clazz, list);
        }
    }

    public static boolean isRectangleVisibleAtScreen(Rectangle rectangle) {
        Area area = new Area();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            area.add(new Area(graphicsDevice.getDefaultConfiguration().getBounds()));
        }
        return area.contains(rectangle);
    }

    public static Cursor createCustomCursor(URL uRL, URL uRL2, float f, float f2, String string, Cursor cursor) {
        if (GraphicsEnvironment.isHeadless()) {
            return cursor;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        if (dimension.width == 0) {
            return cursor;
        }
        URL uRL3 = dimension.width > 16 ? uRL2 : uRL;
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL3);
            return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(Math.min(dimension.width - 1, Math.round((float)dimension.width * f)), Math.min(dimension.height - 1, Math.round((float)dimension.height * f2))), string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unknown resource " + uRL3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSizeInPixels(Content content) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = content.openStream();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                int n = imageReader.getWidth(imageReader.getMinIndex());
                int n2 = imageReader.getHeight(imageReader.getMinIndex());
                imageReader.dispose();
                Dimension dimension = new Dimension(n, n2);
                return dimension;
            }
            Dimension dimension = null;
            return dimension;
        }
    }

    public static Stroke getStroke(float f, Polyline.CapStyle capStyle, Polyline.JoinStyle joinStyle, Polyline.DashStyle dashStyle) {
        return ShapeTools.getStroke(f, capStyle, joinStyle, dashStyle.getDashPattern(), 0.0f);
    }

    static void updateComponentDefaults() {
        float f;
        if (defaultResolutionScale == null) {
            try {
                defaultResolutionScale = Float.valueOf(1.0f);
                if ((OperatingSystem.isLinux() || OperatingSystem.isWindows() && !OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) && UIManager.getLookAndFeel().getClass().isAssignableFrom(Class.forName(UIManager.getSystemLookAndFeelClassName()))) {
                    int n = new BasicLookAndFeel(){

                        @Override
                        public String getDescription() {
                            return null;
                        }

                        @Override
                        public String getID() {
                            return null;
                        }

                        @Override
                        public String getName() {
                            return null;
                        }

                        @Override
                        public boolean isNativeLookAndFeel() {
                            return false;
                        }

                        @Override
                        public boolean isSupportedLookAndFeel() {
                            return false;
                        }
                    }.getDefaults().getFont("Panel.font").getSize();
                    defaultResolutionScale = Float.valueOf((float)UIManager.getFont("Panel.font").getSize() / (float)n);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((f = SwingTools.getUserResolutionScale()) != 1.0f) {
            Font font = SwingTools.updateComponentFontSize("Button.font", f);
            SwingTools.updateComponentFontSize("ToggleButton.font", f);
            SwingTools.updateComponentFontSize("RadioButton.font", f);
            SwingTools.updateComponentFontSize("CheckBox.font", f);
            SwingTools.updateComponentFontSize("ColorChooser.font", f);
            SwingTools.updateComponentFontSize("ComboBox.font", f);
            SwingTools.updateComponentFontSize("InternalFrame.titleFont", f);
            Font font2 = SwingTools.updateComponentFontSize("Label.font", f);
            SwingTools.updateComponentFontSize("List.font", f);
            SwingTools.updateComponentFontSize("MenuBar.font", f);
            SwingTools.updateComponentFontSize("MenuItem.font", f);
            SwingTools.updateComponentFontSize("MenuItem.acceleratorFont", f);
            SwingTools.updateComponentFontSize("RadioButtonMenuItem.font", f);
            SwingTools.updateComponentFontSize("RadioButtonMenuItem.acceleratorFont", f);
            SwingTools.updateComponentFontSize("CheckBoxMenuItem.font", f);
            SwingTools.updateComponentFontSize("CheckBoxMenuItem.acceleratorFont", f);
            SwingTools.updateComponentFontSize("Menu.font", f);
            SwingTools.updateComponentFontSize("Menu.acceleratorFont", f);
            SwingTools.updateComponentFontSize("PopupMenu.font", f);
            SwingTools.updateComponentFontSize("OptionPane.font", f);
            SwingTools.updateComponentFontSize("Panel.font", f);
            SwingTools.updateComponentFontSize("ProgressBar.font", f);
            SwingTools.updateComponentFontSize("ScrollPane.font", f);
            SwingTools.updateComponentFontSize("Viewport.font", f);
            SwingTools.updateComponentFontSize("Slider.font", f);
            SwingTools.updateComponentFontSize("Spinner.font", f);
            SwingTools.updateComponentFontSize("Table.font", f);
            SwingTools.updateComponentFontSize("TabbedPane.font", f);
            SwingTools.updateComponentFontSize("TableHeader.font", f);
            SwingTools.updateComponentFontSize("TextField.font", f);
            SwingTools.updateComponentFontSize("FormattedTextField.font", f);
            SwingTools.updateComponentFontSize("PasswordField.font", f);
            SwingTools.updateComponentFontSize("TextArea.font", f);
            SwingTools.updateComponentFontSize("EditorPane.font", f);
            SwingTools.updateComponentFontSize("TitledBorder.font", f);
            SwingTools.updateComponentFontSize("ToolBar.font", f);
            SwingTools.updateComponentFontSize("ToolTip.font", f);
            SwingTools.updateComponentFontSize("Tree.font", f);
            UIManager.put("OptionPane.messageFont", font2);
            UIManager.put("OptionPane.buttonFont", font);
        }
        SwingTools.updateComponentSize("SplitPane.dividerSize", SwingTools.getResolutionScale());
    }

    private static Font updateComponentFontSize(String string, float f) {
        Font font = UIManager.getFont(string);
        if (font != null) {
            font = font.deriveFont((float)font.getSize() * f);
            UIManager.put(string, font);
        }
        return font;
    }

    private static int updateComponentSize(String string, float f) {
        int n = UIManager.getInt(string);
        if (n != 0) {
            n = Math.round((float)n * f);
            UIManager.put(string, n);
        }
        return n;
    }

    public static float getResolutionScale() {
        float f = defaultResolutionScale != null ? defaultResolutionScale.floatValue() : 1.0f;
        return f * SwingTools.getUserResolutionScale();
    }

    private static float getUserResolutionScale() {
        try {
            String string = System.getProperty("com.eteks.sweethome3d.resolutionScale");
            if (string != null) {
                return Float.parseFloat(string.trim());
            }
        }
        catch (AccessControlException accessControlException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1.0f;
    }

    public static ImageIcon getScaledImageIcon(URL uRL) {
        float f = SwingTools.getResolutionScale();
        if (f == 1.0f) {
            return new ImageIcon(uRL);
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            Image image = bufferedImage.getScaledInstance(Math.round((float)bufferedImage.getWidth() * f), Math.round((float)bufferedImage.getHeight() * f), 4);
            return new ImageIcon(image);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static class BrowserSupport {
        private BrowserSupport() {
        }

        public static boolean showDocumentInBrowser(URL uRL) {
            try {
                BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                if (basicService.isWebBrowserSupported()) {
                    return basicService.showDocument(uRL);
                }
            }
            catch (UnavailableServiceException unavailableServiceException) {
            }
            catch (LinkageError linkageError) {
                System.err.println("Can't show document in browser. JNLP classes not available in classpath.");
            }
            return false;
        }
    }

    private static class MenuItemsVisibilityListener
    implements PopupMenuListener {
        private MenuItemsVisibilityListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            this.hideDisabledMenuItems(jPopupMenu);
            boolean bl = true;
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                if (!jPopupMenu.getComponent(i).isVisible()) continue;
                bl = false;
                break;
            }
            if (bl && jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.getComponent(0).setVisible(true);
            }
        }

        private void hideDisabledMenuItems(JPopupMenu jPopupMenu) {
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                Component component = jPopupMenu.getComponent(i);
                if (component instanceof JMenu) {
                    boolean bl = this.containsEnabledItems((JMenu)component);
                    component.setVisible(bl);
                    if (!bl) continue;
                    this.hideDisabledMenuItems(((JMenu)component).getPopupMenu());
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                Action action = ((JMenuItem)component).getAction();
                component.setVisible(component.isEnabled() && (action == null || !Boolean.FALSE.equals(action.getValue("Visible"))));
            }
            this.hideUselessSeparators(jPopupMenu);
        }

        private void hideUselessSeparators(JPopupMenu jPopupMenu) {
            int n;
            boolean bl = true;
            int n2 = -1;
            for (n = 0; n < jPopupMenu.getComponentCount(); ++n) {
                Component component = jPopupMenu.getComponent(n);
                if (bl && component instanceof JMenuItem) {
                    if (!component.isVisible()) continue;
                    bl = false;
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                component.setVisible(!bl);
                if (!bl) {
                    n2 = n;
                }
                bl = true;
            }
            if (n2 != -1 && bl) {
                int n3;
                n = 1;
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    if (!jPopupMenu.getComponent(n3).isVisible()) continue;
                    n = 0;
                    break;
                }
                n3 = 1;
                for (int i = n2; i < jPopupMenu.getComponentCount(); ++i) {
                    if (!jPopupMenu.getComponent(i).isVisible()) continue;
                    n = 0;
                    break;
                }
                jPopupMenu.getComponent(n2).setVisible(n == 0 && n3 == 0);
            }
        }

        private boolean containsEnabledItems(JMenu jMenu) {
            boolean bl = false;
            for (int i = 0; i < jMenu.getMenuComponentCount() && !bl; ++i) {
                Component component = jMenu.getMenuComponent(i);
                if (component instanceof JMenu) {
                    bl = this.containsEnabledItems((JMenu)component);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                bl = component.isEnabled();
            }
            return bl;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

