/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.openide.util.Lookup;

public abstract class ProjectsSelector {
    private final Collection<Lookup.Provider> selected;

    public ProjectsSelector(Collection<Lookup.Provider> collection) {
        this.selected = new HashSet<Lookup.Provider>(collection);
    }

    public void show(Component component) {
        UI uI = new UI(this.selected);
        uI.show(component);
    }

    protected abstract void selectionChanged(Collection<Lookup.Provider> var1);

    private static class ProjectRenderer
    extends LabelRenderer {
        private final Font font = this.getFont();
        private final Lookup.Provider main = ProjectUtilities.getMainProject();

        public void setValue(Object object, int n) {
            if (object == null) {
                this.setText("");
                this.setIcon(null);
            } else {
                Lookup.Provider provider = (Lookup.Provider)object;
                this.setText(ProjectUtilities.getDisplayName((Lookup.Provider)provider));
                Icon icon = ProjectUtilities.getIcon((Lookup.Provider)provider);
                this.setIcon(this.isEnabled() ? icon : ProjectRenderer.disabledIcon(icon));
                this.setFont(Objects.equals(this.main, object) ? this.font.deriveFont(1) : this.font);
            }
        }

        private static Icon disabledIcon(Icon icon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
    }

    private class UI {
        private JPanel panel;

        UI(Collection<Lookup.Provider> collection) {
            this.populatePopup();
        }

        void show(Component component) {
            int n = 12;
            ProfilerPopup.createRelative((Component)component, (Component)this.panel, (int)6, (int)n).show();
        }

        private void populatePopup() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(Bundle.ProjectsSelector_selectProjects(), 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            jPanel.add((Component)jLabel, "North");
            SelectedProjectsModel selectedProjectsModel = new SelectedProjectsModel();
            final ProfilerTable profilerTable = new ProfilerTable((TableModel)selectedProjectsModel, true, false, null);
            profilerTable.setColumnToolTips(new String[]{Bundle.ProjectsSelector_columnSelectedToolTip(), Bundle.ProjectsSelector_columnProjectToolTip()});
            profilerTable.setMainColumn(1);
            profilerTable.setFitWidthColumn(1);
            profilerTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            profilerTable.setSortColumn(1);
            profilerTable.setFixedColumnSelection(0);
            profilerTable.setColumnRenderer(0, (ProfilerRenderer)new CheckBoxRenderer());
            ProjectRenderer projectRenderer = new ProjectRenderer();
            profilerTable.setColumnRenderer(1, (ProfilerRenderer)projectRenderer);
            int n = new JLabel((String)profilerTable.getColumnName((int)0)).getPreferredSize().width;
            profilerTable.setDefaultColumnWidth(0, n + 15);
            int n2 = profilerTable.getRowHeight() * 8;
            projectRenderer.setText("A longest expected project name A longest expected project name");
            Dimension dimension = new Dimension(n + projectRenderer.getPreferredSize().width, n2 += profilerTable.getTableHeader().getPreferredSize().height);
            profilerTable.setPreferredScrollableViewportSize(dimension);
            ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(profilerTable, true, null);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            jPanel2.add((Component)profilerTableContainer, "Center");
            jPanel.add((Component)jPanel2, "Center");
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.ProjectsSelector_filterProjects()){

                protected void filterChanged() {
                    if (this.isAll()) {
                        profilerTable.setRowFilter(null);
                    } else {
                        profilerTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return this.passes(entry.getStringValue(1));
                            }
                        });
                    }
                }
            };
            jPanel.add((Component)filteringToolbar, "South");
            this.panel = jPanel;
        }

        private class SelectedProjectsModel
        extends AbstractTableModel {
            Lookup.Provider[] projects = ProjectUtilities.getOpenedProjects();

            SelectedProjectsModel() {
                ProjectUtilities.getOpenedProjects();
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Bundle.ProjectsSelector_columnSelected();
                }
                if (n == 1) {
                    return Bundle.ProjectsSelector_columnProject();
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                if (n == 1) {
                    return Lookup.Provider.class;
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return this.projects.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ProjectsSelector.this.selected.contains(this.projects[n]);
                }
                if (n2 == 1) {
                    return this.projects[n];
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (Boolean.TRUE.equals(object)) {
                    if (ProjectsSelector.this.selected.add(this.projects[n])) {
                        ProjectsSelector.this.selectionChanged(ProjectsSelector.this.selected);
                    }
                } else if (ProjectsSelector.this.selected.size() > 1 && ProjectsSelector.this.selected.remove(this.projects[n])) {
                    ProjectsSelector.this.selectionChanged(ProjectsSelector.this.selected);
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        }
    }
}

