/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class AimsReader
extends AtomSetCollectionReader {
    private boolean globalDoApplySymmetry;
    private boolean isFractional;
    private int nLatticeVectors;

    @Override
    protected void initializeReader() {
        this.globalDoApplySymmetry = this.doApplySymmetry;
        this.doApplySymmetry = true;
        this.isFractional = true;
    }

    @Override
    protected boolean checkLine() {
        String[] tokens = this.getTokens();
        if (tokens.length == 0) {
            return true;
        }
        if (tokens[0].equals("lattice_vector")) {
            this.readLatticeVector(tokens);
            return true;
        }
        if (tokens[0].equals("atom")) {
            this.readAtom(tokens, false);
            return true;
        }
        if (tokens[0].equals("atom_frac")) {
            this.readAtom(tokens, true);
            return true;
        }
        if (tokens[0].equals("multipole")) {
            this.readMultipole(tokens);
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.doApplySymmetry = this.globalDoApplySymmetry;
        if (this.nLatticeVectors == 1 || this.nLatticeVectors == 2) {
            Logger.warn("ignoring translation symmetry for more or less than 3 dimensions(which is currently neither supported by FHI-aims");
        }
        this.finalizeReaderASCR();
    }

    private void readLatticeVector(String[] tokens) {
        if (tokens.length < 4) {
            Logger.warn("cannot read line with FHI-aims lattice vector: " + this.line);
        } else if (this.nLatticeVectors == 3) {
            Logger.warn("more than 3 FHI-aims lattice vectors found with line: " + this.line);
        } else {
            this.addExplicitLatticeVector(this.nLatticeVectors++, new float[]{this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3])}, 0);
            this.setFractionalCoordinates(this.nLatticeVectors == 3);
        }
    }

    private void readAtom(String[] tokens, boolean isFractional) {
        if (tokens.length < 5) {
            Logger.warn("cannot read line with FHI-aims line: " + this.line);
            return;
        }
        if (this.isFractional != isFractional) {
            this.isFractional = isFractional;
            this.setFractionalCoordinates(this.isFractional);
        }
        this.addAtomXYZSymName(tokens, 1, tokens[4], null);
    }

    private void readMultipole(String[] tokens) {
        if (tokens.length < 6) {
            Logger.warn("cannot read line with FHI-aims atom data: " + this.line);
            return;
        }
        int order = this.parseIntStr(tokens[4]);
        if (order > 0) {
            Logger.warn("multipole line ignored since only monopoles are currently supported: " + this.line);
            return;
        }
        if (this.isFractional) {
            this.isFractional = false;
            this.setFractionalCoordinates(false);
        }
        this.addAtomXYZSymName((String[])tokens, (int)1, null, null).partialCharge = this.parseFloatStr(tokens[5]);
    }
}

