/*
 * Decompiled with CFR 0.152.
 */
package ome.jxrlib;

import ome.jxrlib.FormatConverter;
import ome.jxrlib.ImageDecoder;
import ome.jxrlib.JXRJNI;
import ome.jxrlib.Stream;

class ImageEncoder {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ImageEncoder(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ImageEncoder obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JXRJNI.delete_ImageEncoder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ImageEncoder(Stream encodeStream, String extension) {
        this(JXRJNI.new_ImageEncoder(Stream.getCPtr(encodeStream), encodeStream, extension), true);
    }

    public void initializeWithDecoder(ImageDecoder decoder) {
        JXRJNI.ImageEncoder_initializeWithDecoder(this.swigCPtr, this, ImageDecoder.getCPtr(decoder), decoder);
    }

    public void writeSource(FormatConverter converter) {
        JXRJNI.ImageEncoder_writeSource(this.swigCPtr, this, FormatConverter.getCPtr(converter), converter);
    }

    public void close() {
        JXRJNI.ImageEncoder_close(this.swigCPtr, this);
    }
}

