/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    public static BundleInfo parseManifest(Manifest manifest) throws ParseException {
        String bundleClasspath;
        Version version;
        Attributes mainAttributes = manifest.getMainAttributes();
        String symbolicName = new ManifestHeaderValue(mainAttributes.getValue("Bundle-SymbolicName")).getSingleValue();
        if (symbolicName == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        String description = new ManifestHeaderValue(mainAttributes.getValue("Bundle-Description")).getSingleValue();
        if (description == null) {
            description = new ManifestHeaderValue(mainAttributes.getValue("Bundle-Description")).getSingleValue();
        }
        String vBundle = new ManifestHeaderValue(mainAttributes.getValue("Bundle-Version")).getSingleValue();
        try {
            version = ManifestParser.versionOf(vBundle);
        }
        catch (NumberFormatException e) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + vBundle + " (" + e.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(symbolicName, version);
        bundleInfo.setDescription(description);
        List<String> environments = new ManifestHeaderValue(mainAttributes.getValue("Bundle-RequiredExecutionEnvironment")).getValues();
        bundleInfo.setExecutionEnvironments(environments);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, "Require-Bundle", "bundle", "bundle-version");
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, "Import-Package", "package", "version");
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, "Import-Service", "service", "version");
        ManifestHeaderValue exportElements = new ManifestHeaderValue(mainAttributes.getValue("Export-Package"));
        for (ManifestHeaderElement exportElement : exportElements.getElements()) {
            String vExport = exportElement.getAttributes().get("version");
            Version v = null;
            try {
                v = ManifestParser.versionOf(vExport);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The Export-Package has an incorrect version: " + vExport + " (" + e.getMessage() + ")", 0);
            }
            for (String name : exportElement.getValues()) {
                ExportPackage export = new ExportPackage(name, v);
                String uses = exportElement.getDirectives().get("use");
                if (uses != null) {
                    String[] split = uses.trim().split(",");
                    for (int i = 0; i < split.length; ++i) {
                        export.addUse(split[i].trim());
                    }
                }
                bundleInfo.addCapability(export);
            }
        }
        ManifestParser.parseCapability(bundleInfo, mainAttributes, "Export-Service", "service");
        String eclipseSourceBundle = mainAttributes.getValue("Eclipse-SourceBundle");
        if (eclipseSourceBundle != null) {
            bundleInfo.setSource(true);
            ManifestHeaderValue eclipseSourceBundleValue = new ManifestHeaderValue(eclipseSourceBundle);
            ManifestHeaderElement element = eclipseSourceBundleValue.getElements().iterator().next();
            String symbolicNameTarget = element.getValues().iterator().next();
            bundleInfo.setSymbolicNameTarget(symbolicNameTarget);
            String v = element.getAttributes().get("version");
            if (v != null) {
                bundleInfo.setVersionTarget(new Version(v));
            }
        }
        if ((bundleClasspath = mainAttributes.getValue("Bundle-ClassPath")) != null) {
            ManifestHeaderValue bundleClasspathValue = new ManifestHeaderValue(bundleClasspath);
            bundleInfo.setClasspath(bundleClasspathValue.getValues());
            bundleInfo.setHasInnerClasspath(true);
        }
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type, String versionAttr) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element : elements.getElements()) {
            String resolution = element.getDirectives().get("resolution");
            String attVersion = element.getAttributes().get(versionAttr);
            VersionRange version = null;
            try {
                version = ManifestParser.versionRangeOf(attVersion);
            }
            catch (ParseException e) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e.getMessage() + ")", 0);
            }
            for (String name : element.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(type, name, version, resolution));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element : elements.getElements()) {
            String attVersion = element.getAttributes().get("version");
            Version version = null;
            try {
                version = ManifestParser.versionOf(attVersion);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e.getMessage() + ")", 0);
            }
            for (String name : element.getValues()) {
                BundleCapability export = new BundleCapability(type, name, version);
                bundleInfo.addCapability(export);
            }
        }
    }

    private static VersionRange versionRangeOf(String v) throws ParseException {
        if (v == null) {
            return null;
        }
        return new VersionRange(v);
    }

    private static Version versionOf(String v) throws ParseException {
        if (v == null) {
            return null;
        }
        return new Version(v);
    }
}

