/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.PriorityQueue;

class TopSuggestGroupDocsCollector
extends TopSuggestDocsCollector {
    private final SuggestScoreDocPriorityQueue priorityQueue;
    private final int num;
    private final List<TopSuggestDocs.SuggestScoreDoc> pendingResults;
    final CharArraySet seenSurfaceForms;
    protected int docBase;
    private Map<Integer, List<CharSequence>> docContexts = new HashMap<Integer, List<CharSequence>>();

    TopSuggestGroupDocsCollector(int num, boolean skipDuplicates) {
        super(1, skipDuplicates);
        if (num <= 0) {
            throw new IllegalArgumentException("'num' must be > 0");
        }
        this.num = num;
        this.priorityQueue = new SuggestScoreDocPriorityQueue(num);
        if (skipDuplicates) {
            this.seenSurfaceForms = new CharArraySet(num, false);
            this.pendingResults = new ArrayList<TopSuggestDocs.SuggestScoreDoc>();
        } else {
            this.seenSurfaceForms = null;
            this.pendingResults = null;
        }
    }

    public List<CharSequence> getContexts(int doc) {
        return this.docContexts.getOrDefault(doc, Collections.emptyList());
    }

    protected boolean doSkipDuplicates() {
        return this.seenSurfaceForms != null;
    }

    public int getCountToCollect() {
        return this.num;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
        if (this.seenSurfaceForms != null) {
            this.seenSurfaceForms.clear();
            for (TopSuggestDocs.SuggestScoreDoc hit : this.priorityQueue.getResults()) {
                this.pendingResults.add(hit);
            }
        }
    }

    public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
        int globalDoc = docID + this.docBase;
        boolean isDuplicate = this.docContexts.containsKey(globalDoc);
        List contexts = this.docContexts.computeIfAbsent(globalDoc, k -> new ArrayList());
        if (context != null) {
            contexts.add(context);
        }
        if (isDuplicate) {
            return;
        }
        TopSuggestDocs.SuggestScoreDoc current = new TopSuggestDocs.SuggestScoreDoc(globalDoc, key, context, score);
        if (current == this.priorityQueue.insertWithOverflow(current)) {
            throw new CollectionTerminatedException();
        }
    }

    public TopSuggestDocs get() throws IOException {
        TopSuggestDocs.SuggestScoreDoc[] suggestScoreDocs;
        if (this.seenSurfaceForms != null) {
            for (TopSuggestDocs.SuggestScoreDoc hit : this.priorityQueue.getResults()) {
                this.pendingResults.add(hit);
            }
            this.seenSurfaceForms.clear();
            Collections.sort(this.pendingResults, (a, b) -> {
                int cmp = Float.compare(b.score, a.score);
                if (cmp == 0 && (cmp = Lookup.CHARSEQUENCE_COMPARATOR.compare(a.key, b.key)) == 0) {
                    cmp = Integer.compare(a.doc, b.doc);
                }
                return cmp;
            });
            ArrayList<TopSuggestDocs.SuggestScoreDoc> hits = new ArrayList<TopSuggestDocs.SuggestScoreDoc>();
            for (TopSuggestDocs.SuggestScoreDoc hit : this.pendingResults) {
                if (this.seenSurfaceForms.contains(hit.key)) continue;
                this.seenSurfaceForms.add(hit.key);
                hits.add(hit);
                if (hits.size() != this.num) continue;
                break;
            }
            suggestScoreDocs = hits.toArray(new TopSuggestDocs.SuggestScoreDoc[0]);
        } else {
            suggestScoreDocs = this.priorityQueue.getResults();
        }
        if (suggestScoreDocs.length > 0) {
            return new TopSuggestDocs(suggestScoreDocs.length, suggestScoreDocs, suggestScoreDocs[0].score);
        }
        return TopSuggestDocs.EMPTY;
    }

    private final class SuggestScoreDocPriorityQueue
    extends PriorityQueue<TopSuggestDocs.SuggestScoreDoc> {
        private SuggestScoreDocPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(TopSuggestDocs.SuggestScoreDoc a, TopSuggestDocs.SuggestScoreDoc b) {
            if (a.score == b.score) {
                int cmp = Lookup.CHARSEQUENCE_COMPARATOR.compare(a.key, b.key);
                return cmp != 0 ? cmp > 0 : a.doc > b.doc;
            }
            return a.score < b.score;
        }

        public TopSuggestDocs.SuggestScoreDoc[] getResults() {
            int size = this.size();
            TopSuggestDocs.SuggestScoreDoc[] res = new TopSuggestDocs.SuggestScoreDoc[size];
            for (int i = size - 1; i >= 0; --i) {
                res[i] = (TopSuggestDocs.SuggestScoreDoc)this.pop();
            }
            return res;
        }
    }
}

