/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.DateFormat;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class DateProcessor
extends AbstractProcessor {
    public static final String TYPE = "date";
    static final String DEFAULT_TARGET_FIELD = "@timestamp";
    private final TemplateScript.Factory timezone;
    private final TemplateScript.Factory locale;
    private final String field;
    private final String targetField;
    private final List<String> formats;
    private final List<Function<Map<String, Object>, Function<String, DateTime>>> dateParsers;

    DateProcessor(String tag, @Nullable TemplateScript.Factory timezone, @Nullable TemplateScript.Factory locale, String field, List<String> formats, String targetField) {
        super(tag);
        this.timezone = timezone;
        this.locale = locale;
        this.field = field;
        this.targetField = targetField;
        this.formats = formats;
        this.dateParsers = new ArrayList<Function<Map<String, Object>, Function<String, DateTime>>>(this.formats.size());
        for (String format : formats) {
            DateFormat dateFormat = DateFormat.fromString(format);
            this.dateParsers.add(params -> dateFormat.getFunction(format, this.newDateTimeZone((Map<String, Object>)params), this.newLocale((Map<String, Object>)params)));
        }
    }

    private DateTimeZone newDateTimeZone(Map<String, Object> params) {
        return this.timezone == null ? DateTimeZone.UTC : DateTimeZone.forID((String)this.timezone.newInstance(params).execute());
    }

    private Locale newLocale(Map<String, Object> params) {
        return this.locale == null ? Locale.ROOT : LocaleUtils.parse((String)this.locale.newInstance(params).execute());
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class);
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        DateTime dateTime = null;
        Exception lastException = null;
        for (Function<Map<String, Object>, Function<String, DateTime>> dateParser : this.dateParsers) {
            try {
                dateTime = dateParser.apply(ingestDocument.getSourceAndMetadata()).apply(value);
            }
            catch (Exception e) {
                lastException = (Exception)ExceptionsHelper.useOrSuppress(lastException, (Throwable)e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + value + "]", lastException);
        }
        ingestDocument.setFieldValue(this.targetField, (Object)ISODateTimeFormat.dateTime().print(dateTime));
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    TemplateScript.Factory getTimezone() {
        return this.timezone;
    }

    TemplateScript.Factory getLocale() {
        return this.locale;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    List<String> getFormats() {
        return this.formats;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public DateProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DateProcessor.DEFAULT_TARGET_FIELD);
            String timezoneString = ConfigurationUtils.readOptionalStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"timezone");
            TemplateScript.Factory compiledTimezoneTemplate = null;
            if (timezoneString != null) {
                compiledTimezoneTemplate = ConfigurationUtils.compileTemplate((String)DateProcessor.TYPE, (String)processorTag, (String)"timezone", (String)timezoneString, (ScriptService)this.scriptService);
            }
            String localeString = ConfigurationUtils.readOptionalStringProperty((String)DateProcessor.TYPE, (String)processorTag, config, (String)"locale");
            TemplateScript.Factory compiledLocaleTemplate = null;
            if (localeString != null) {
                compiledLocaleTemplate = ConfigurationUtils.compileTemplate((String)DateProcessor.TYPE, (String)processorTag, (String)"locale", (String)localeString, (ScriptService)this.scriptService);
            }
            List formats = ConfigurationUtils.readList((String)DateProcessor.TYPE, (String)processorTag, config, (String)"formats");
            return new DateProcessor(processorTag, compiledTimezoneTemplate, compiledLocaleTemplate, field, formats, targetField);
        }
    }
}

