/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.plugins.quality.internal.findbugs;

import com.google.common.base.MoreObjects;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FindBugsSpec implements Serializable {
    private List<String> arguments;
    private String maxHeapSize;
    private boolean debugEnabled;
    private Collection<String> jvmArgs;

    public FindBugsSpec(List<String> arguments, String maxHeapSize, boolean debugEnabled, Collection<String> jvmArgs) {
        this.debugEnabled = debugEnabled;
        this.maxHeapSize = maxHeapSize;
        this.arguments = arguments;
        this.jvmArgs = jvmArgs;
    }

    public List<String> getArguments() {
        return arguments;
    }

    public String getMaxHeapSize() {
        return maxHeapSize;
    }

    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    public Collection<String> getJvmArgs() {
        return jvmArgs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("arguments", arguments).add("debugEnabled", debugEnabled).add("jvmArgs", jvmArgs).toString();
    }
}
